/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.tileentity;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.core.ModTileEntities;
import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.crafting.RecipeValidator;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber
public class CoinMintTileEntity
extends TileEntity {
    IInventory storage = new Inventory(2);
    private final LazyOptional<IItemHandler> inventoryHandlerLazyOptional = LazyOptional.of(() -> new MintItemCapability(this));

    public IInventory getStorage() {
        return this.storage;
    }

    private final List<CoinMintRecipe> getCoinMintRecipes() {
        if (this.field_145850_b != null) {
            return RecipeValidator.getValidRecipes(this.field_145850_b).getCoinMintRecipes();
        }
        return Lists.newArrayList();
    }

    public CoinMintTileEntity() {
        super(ModTileEntities.COIN_MINT);
    }

    protected CoinMintTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        InventoryUtil.saveAllItems("Storage", compound, this.storage);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.storage = InventoryUtil.loadAllItems("Storage", compound, 2);
    }

    public void dumpContents(World world, BlockPos pos) {
        InventoryUtil.dumpContents(world, pos, this.storage);
    }

    public boolean validMintInput() {
        return !this.getMintOutput().func_190926_b();
    }

    public boolean validMintInput(ItemStack item) {
        Inventory tempInv = new Inventory(1);
        tempInv.func_70299_a(0, item);
        for (CoinMintRecipe recipe : this.getCoinMintRecipes()) {
            if (!recipe.func_77569_a((IInventory)tempInv, this.field_145850_b)) continue;
            return true;
        }
        return false;
    }

    public int validMintOutput() {
        ItemStack mintOutput = this.getMintOutput();
        ItemStack currentOutputSlot = this.getStorage().func_70301_a(1);
        if (currentOutputSlot.func_190926_b()) {
            return 64;
        }
        if (currentOutputSlot.func_77973_b() != mintOutput.func_77973_b()) {
            return 0;
        }
        return currentOutputSlot.func_77976_d() - currentOutputSlot.func_190916_E();
    }

    public ItemStack getMintOutput() {
        ItemStack mintInput = this.getStorage().func_70301_a(0);
        if (mintInput.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (CoinMintRecipe recipe : this.getCoinMintRecipes()) {
            if (!recipe.func_77569_a(this.storage, this.field_145850_b)) continue;
            return recipe.func_77572_b(this.storage);
        }
        return ItemStack.field_190927_a;
    }

    public void mintCoins(int mintCount) {
        if (!this.validMintInput()) {
            return;
        }
        if (mintCount > this.getStorage().func_70301_a(0).func_190916_E()) {
            mintCount = this.getStorage().func_70301_a(0).func_190916_E();
        }
        if (mintCount > this.validMintOutput()) {
            mintCount = this.validMintOutput();
        }
        if (mintCount <= 0) {
            return;
        }
        ItemStack mintOutput = this.getMintOutput();
        mintOutput.func_190920_e(mintCount);
        if (this.getStorage().func_70301_a(1).func_190926_b()) {
            this.getStorage().func_70299_a(1, mintOutput);
        } else {
            this.getStorage().func_70301_a(1).func_190920_e(this.getStorage().func_70301_a(1).func_190916_E() + mintOutput.func_190916_E());
        }
        this.getStorage().func_70301_a(0).func_190920_e(this.getStorage().func_70301_a(0).func_190916_E() - mintCount);
        this.func_70296_d();
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            TileEntityUtil.requestUpdatePacket(this.field_145850_b, this.field_174879_c);
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHandlerLazyOptional.invalidate();
    }

    public static class MintItemCapability
    implements IItemHandler {
        final CoinMintTileEntity tileEntity;

        public MintItemCapability(CoinMintTileEntity tileEntity) {
            this.tileEntity = tileEntity;
        }

        public int getSlots() {
            return this.tileEntity.getStorage().func_70302_i_();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.tileEntity.getStorage().func_70301_a(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0) {
                return stack.func_77946_l();
            }
            if (!this.tileEntity.validMintInput(stack)) {
                return stack.func_77946_l();
            }
            ItemStack currentStack = this.tileEntity.getStorage().func_70301_a(0);
            if (currentStack.func_190926_b()) {
                if (stack.func_190916_E() > stack.func_77976_d()) {
                    if (!simulate) {
                        ItemStack placeStack = stack.func_77946_l();
                        placeStack.func_190920_e(stack.func_77976_d());
                        this.tileEntity.getStorage().func_70299_a(0, placeStack);
                    }
                    ItemStack leftoverStack = stack.func_77946_l();
                    leftoverStack.func_190920_e(stack.func_190916_E() - stack.func_77976_d());
                    return leftoverStack;
                }
                if (!simulate) {
                    this.tileEntity.getStorage().func_70299_a(0, stack.func_77946_l());
                }
                return ItemStack.field_190927_a;
            }
            if (InventoryUtil.ItemMatches(currentStack, stack)) {
                int newAmount = MathUtil.clamp(currentStack.func_190916_E() + stack.func_190916_E(), 0, currentStack.func_77976_d());
                if (!simulate) {
                    ItemStack newStack = currentStack.func_77946_l();
                    newStack.func_190920_e(newAmount);
                    this.tileEntity.getStorage().func_70299_a(0, newStack);
                }
                ItemStack leftoverStack = stack.func_77946_l();
                leftoverStack.func_190920_e(stack.func_190916_E() + currentStack.func_190916_E() - newAmount);
                return leftoverStack;
            }
            return stack.func_77946_l();
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 1) {
                return ItemStack.field_190927_a;
            }
            amount = MathUtil.clamp(amount, 0, 64);
            ItemStack currentStack = this.tileEntity.getStorage().func_70301_a(1).func_77946_l();
            if (currentStack.func_190926_b() || currentStack.func_190916_E() < amount) {
                int mintAmount = MathUtil.clamp(amount - currentStack.func_190916_E(), 0, this.tileEntity.validMintOutput());
                if (!simulate) {
                    if (mintAmount > 0) {
                        this.tileEntity.mintCoins(mintAmount);
                        currentStack = this.tileEntity.getStorage().func_70301_a(1).func_77946_l();
                    }
                } else if (mintAmount > 0) {
                    if (currentStack.func_190926_b()) {
                        currentStack = this.tileEntity.getMintOutput();
                        currentStack.func_190920_e(mintAmount);
                    } else {
                        currentStack.func_190917_f(mintAmount);
                    }
                }
            }
            if (currentStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack outputStack = currentStack.func_77946_l();
            outputStack.func_190920_e(MathUtil.clamp(amount, 0, currentStack.func_190916_E()));
            currentStack.func_190920_e(currentStack.func_190916_E() - outputStack.func_190916_E());
            if (currentStack.func_190916_E() <= 0) {
                currentStack = ItemStack.field_190927_a;
            }
            if (!simulate) {
                this.tileEntity.getStorage().func_70299_a(1, currentStack);
            }
            return outputStack;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 ? this.tileEntity.validMintInput(stack) : false;
        }
    }
}

