/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.tileentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ItemShopLogger;
import io.github.lightman314.lightmanscurrency.blocks.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.containers.ItemEditContainer;
import io.github.lightman314.lightmanscurrency.containers.ItemTraderContainer;
import io.github.lightman314.lightmanscurrency.containers.ItemTraderStorageContainer;
import io.github.lightman314.lightmanscurrency.core.ModTileEntities;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageSetItemPrice;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageSetTradeItem;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageAddOrRemoveTrade;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageUpdateTradeRule;
import io.github.lightman314.lightmanscurrency.tileentity.CashRegisterTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.ItemInterfaceTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.TraderTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.handler.TraderItemHandler;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.settings.ItemTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemTraderTileEntity
extends TraderTileEntity
implements IItemTrader {
    public static final int TRADE_LIMIT = 16;
    public static final int VERSION = 1;
    TraderItemHandler itemHandler = new TraderItemHandler(this);
    ItemTraderSettings itemSettings = new ItemTraderSettings(this, this::markItemSettingsDirty, this::sendSettingsUpdateToServer);
    protected IInventory storage = new Inventory(this.getSizeInventory());
    private final ItemShopLogger logger = new ItemShopLogger();
    protected int tradeCount = 1;
    private long rotationTime = 0L;
    protected List<ItemTradeData> trades;
    List<TradeRule> tradeRules = new ArrayList<TradeRule>();

    @Override
    public IItemHandler getItemHandler(Direction relativeSide) {
        ItemTraderSettings.ItemHandlerSettings handlerSettings = this.itemSettings.getHandlerSetting(relativeSide);
        return this.itemHandler.getHandler(handlerSettings);
    }

    @Override
    public Map<String, Integer> getAllyDefaultPermissions() {
        return ImmutableMap.of((Object)"changeExternalInputs", (Object)1);
    }

    public ItemTraderTileEntity() {
        super(ModTileEntities.ITEM_TRADER);
        this.trades = ItemTradeData.listOfSize(this.tradeCount);
        this.storage = new Inventory(this.getSizeInventory());
    }

    public ItemTraderTileEntity(int tradeCount) {
        super(ModTileEntities.ITEM_TRADER);
        this.tradeCount = tradeCount;
        this.trades = ItemTradeData.listOfSize(tradeCount);
        this.storage = new Inventory(this.getSizeInventory());
    }

    protected ItemTraderTileEntity(TileEntityType<?> type) {
        super(type);
        this.trades = ItemTradeData.listOfSize(this.tradeCount);
        this.storage = new Inventory(this.getSizeInventory());
    }

    protected ItemTraderTileEntity(TileEntityType<?> type, int tradeCount) {
        super(type);
        this.tradeCount = tradeCount;
        this.trades = ItemTradeData.listOfSize(tradeCount);
        this.storage = new Inventory(this.getSizeInventory());
    }

    public void restrictTrade(int index, ItemTradeRestriction restriction) {
        this.getTrade(index).setRestriction(restriction);
    }

    public int getSizeInventory() {
        return this.getTradeCount() * 9;
    }

    @Override
    public int getTradeCount() {
        return MathUtil.clamp(this.tradeCount, 1, 16);
    }

    @Override
    public int getTradeCountLimit() {
        return 16;
    }

    @Override
    public void requestAddOrRemoveTrade(boolean isAdd) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageAddOrRemoveTrade(this.field_174879_c, isAdd));
    }

    @Override
    public void addTrade(PlayerEntity requestor) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tradeCount >= 16) {
            return;
        }
        if (TradingOffice.isAdminPlayer(requestor)) {
            this.overrideTradeCount(this.tradeCount + 1);
            this.coreSettings.getLogger().LogAddRemoveTrade(requestor, true, this.tradeCount);
            this.markCoreSettingsDirty();
            this.forceReopen();
        } else {
            Settings.PermissionWarning(requestor, "add a trade slot", "LC_ADMIN_MODE");
        }
    }

    @Override
    public void removeTrade(PlayerEntity requestor) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tradeCount <= 1) {
            return;
        }
        if (TradingOffice.isAdminPlayer(requestor)) {
            this.overrideTradeCount(this.tradeCount - 1);
            this.coreSettings.getLogger().LogAddRemoveTrade(requestor, false, this.tradeCount);
            this.markCoreSettingsDirty();
            this.forceReopen();
        } else {
            Settings.PermissionWarning(requestor, "remove a trade slot", "LC_ADMIN_MODE");
        }
    }

    @Override
    protected void forceReopen(List<PlayerEntity> users) {
        for (PlayerEntity player : users) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (player.field_71070_bA instanceof ItemTraderStorageContainer) {
                this.openStorageMenu((PlayerEntity)serverPlayer);
                continue;
            }
            if (player.field_71070_bA instanceof ItemTraderContainer.ItemTraderContainerCR) {
                this.openCashRegisterTradeMenu((PlayerEntity)serverPlayer, ((ItemTraderContainer.ItemTraderContainerCR)player.field_71070_bA).getCashRegister());
                continue;
            }
            if (!(player.field_71070_bA instanceof ItemTraderContainer)) continue;
            this.openTradeMenu((PlayerEntity)serverPlayer);
        }
    }

    public void overrideTradeCount(int newTradeCount) {
        int i;
        if (this.tradeCount == newTradeCount) {
            return;
        }
        this.tradeCount = MathUtil.clamp(newTradeCount, 1, 16);
        List<ItemTradeData> oldTrades = this.trades;
        this.trades = ItemTradeData.listOfSize(this.getTradeCount());
        for (int i2 = 0; i2 < oldTrades.size() && i2 < this.trades.size(); ++i2) {
            this.trades.set(i2, oldTrades.get(i2));
        }
        IInventory oldStorage = this.storage;
        this.storage = new Inventory(this.getSizeInventory());
        for (i = 0; i < this.storage.func_70302_i_() && i < oldStorage.func_70302_i_(); ++i) {
            this.storage.func_70299_a(i, oldStorage.func_70301_a(i));
        }
        if (oldStorage.func_70302_i_() > this.storage.func_70302_i_()) {
            for (i = this.storage.func_70302_i_(); i < oldStorage.func_70302_i_(); ++i) {
                InventoryUtil.TryPutItemStack(this.storage, oldStorage.func_70301_a(i));
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeTrades(new CompoundNBT());
            this.writeItems(compound);
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
    }

    @Override
    public ItemTradeData getTrade(int tradeSlot) {
        if (tradeSlot < 0 || tradeSlot >= this.trades.size()) {
            LightmansCurrency.LogError("Cannot get trade in index " + tradeSlot + " from a trader with only " + this.trades.size() + " trades.");
            return new ItemTradeData();
        }
        return this.trades.get(tradeSlot);
    }

    @Override
    public List<ItemTradeData> getAllTrades() {
        return this.trades;
    }

    @Override
    public void markTradesDirty() {
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeTrades(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
        this.func_70296_d();
    }

    @Override
    public ItemTraderSettings getItemSettings() {
        return this.itemSettings;
    }

    @Override
    public List<Settings> getAdditionalSettings() {
        return Lists.newArrayList((Object[])new Settings[]{this.itemSettings});
    }

    @Override
    public void markItemSettingsDirty() {
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeItemSettings(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
        this.func_70296_d();
    }

    @Override
    public void markStorageDirty() {
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeItemSettings(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
        this.func_70296_d();
    }

    @Override
    public ItemShopLogger getLogger() {
        return this.logger;
    }

    @Override
    public void clearLogger() {
        this.logger.clear();
        this.markLoggerDirty();
    }

    @Override
    public void markLoggerDirty() {
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeLogger(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
        this.func_70296_d();
    }

    @Override
    public int getTradeStock(int tradeSlot) {
        ItemTradeData trade = this.getTrade(tradeSlot);
        if (!trade.getSellItem().func_190926_b()) {
            if (this.coreSettings.isCreative()) {
                return Integer.MAX_VALUE;
            }
            return trade.stockCount(this);
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, boolean isBlock) {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.GetStackRenderPos(tradeSlot, this.func_195044_w(), isBlock);
        }
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>();
        posList.add(new Vector3f(0.0f, 0.0f, 0.0f));
        return posList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, float partialTicks, boolean isBlock) {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            List<Quaternion> rotation = traderBlock.GetStackRenderRot(tradeSlot, this.func_195044_w(), isBlock);
            if (rotation == null) {
                rotation = new ArrayList<Quaternion>();
                rotation.add(Vector3f.field_229181_d_.func_229187_a_(((float)this.rotationTime + partialTicks) * 2.0f));
            }
            return rotation;
        }
        ArrayList<Quaternion> rotation = new ArrayList<Quaternion>();
        rotation.add(Vector3f.field_229181_d_.func_229187_a_(0.0f));
        return rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3f GetStackRenderScale(int tradeSlot, boolean isBlock) {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.GetStackRenderScale(tradeSlot, this.func_195044_w(), isBlock);
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.maxRenderIndex();
        }
        return 0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeItems(compound);
        this.writeTrades(compound);
        this.writeItemSettings(compound);
        this.writeLogger(compound);
        this.writeTradeRules(compound);
        return super.func_189515_b(compound);
    }

    protected CompoundNBT writeItems(CompoundNBT compound) {
        InventoryUtil.saveAllItems("Items", compound, this.storage);
        return compound;
    }

    public CompoundNBT writeTrades(CompoundNBT compound) {
        compound.func_74768_a("TradeLimit", this.tradeCount);
        ItemTradeData.saveAllData(compound, this.trades);
        return compound;
    }

    public CompoundNBT writeItemSettings(CompoundNBT compound) {
        compound.func_218657_a("ItemSettings", (INBT)this.itemSettings.save(new CompoundNBT()));
        return compound;
    }

    public CompoundNBT writeLogger(CompoundNBT compound) {
        this.logger.write(compound);
        return compound;
    }

    public CompoundNBT writeTradeRules(CompoundNBT compound) {
        TradeRule.writeRules(compound, this.tradeRules);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_150297_b("TradeLimit", 3)) {
            this.tradeCount = MathUtil.clamp(compound.func_74762_e("TradeLimit"), 1, 16);
        }
        if (compound.func_74764_b("Trades")) {
            this.trades = ItemTradeData.loadAllData(compound, this.getTradeCount());
        }
        if (this.storage == null) {
            this.storage = new Inventory(this.getSizeInventory());
        }
        if (compound.func_74764_b("Items")) {
            this.storage = InventoryUtil.loadAllItems("Items", compound, this.getSizeInventory());
        }
        if (compound.func_150297_b("ItemSettings", 10)) {
            this.itemSettings.load(compound.func_74775_l("ItemSettings"));
        }
        this.logger.read(compound);
        if (compound.func_150297_b("TradeRules", 9)) {
            this.tradeRules = TradeRule.readRules(compound);
        }
        super.func_230337_a_(state, compound);
    }

    @Override
    public void dumpContents(World world, BlockPos pos) {
        super.dumpContents(world, pos);
        InventoryUtil.dumpContents(world, pos, this.storage);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(2, 2, 2));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            ++this.rotationTime;
        }
    }

    @Override
    public INamedContainerProvider getTradeMenuProvider() {
        return new TradeContainerProvider(this);
    }

    @Override
    public INamedContainerProvider getStorageMenuProvider() {
        return new StorageContainerProvider(this);
    }

    @Override
    public INamedContainerProvider getCashRegisterTradeMenuProvider(CashRegisterTileEntity cashRegister) {
        return new TradeCRContainerProvider(this, cashRegister);
    }

    protected INamedContainerProvider getItemEditMenuProvider(int tradeIndex) {
        return new ItemEditContainerProvider(this, tradeIndex);
    }

    @Override
    public void openItemEditMenu(PlayerEntity player, int tradeIndex) {
        INamedContainerProvider provider = this.getItemEditMenuProvider(tradeIndex);
        if (provider == null) {
            LightmansCurrency.LogError("No item edit container provider was given for the trader of type " + this.func_200662_C().getRegistryName().toString());
            return;
        }
        if (!(player instanceof ServerPlayerEntity)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the storage menu.");
            return;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, (Consumer)new TraderTileEntity.TradeIndexDataWriter(this, this.field_174879_c, tradeIndex));
    }

    @Override
    public IInventory getStorage() {
        return this.storage;
    }

    @Override
    public int GetCurrentVersion() {
        return 1;
    }

    @Override
    protected void onVersionUpdate(int oldVersion) {
        if (oldVersion < 1) {
            for (ItemTradeData trade : this.trades) {
                ItemStack tradeStack = trade.getSellItem();
                if (!tradeStack.func_190926_b()) {
                    tradeStack = InventoryUtil.TryPutItemStack(this.storage, tradeStack);
                }
                if (tradeStack.func_190926_b()) continue;
                InventoryUtil.dumpContents(this.field_145850_b, this.field_174879_c, InventoryUtil.buildInventory(tradeStack));
            }
        }
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.beforeTrade(event));
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        this.tradeRules.forEach(rule -> rule.tradeCost(event));
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.afterTrade(event));
    }

    public void addRule(TradeRule newRule) {
        if (newRule == null) {
            return;
        }
        for (int i = 0; i < this.tradeRules.size(); ++i) {
            if (newRule.type != this.tradeRules.get((int)i).type) continue;
            LightmansCurrency.LogInfo("Blocked rule addition due to rule of same type already present.");
            return;
        }
        this.tradeRules.add(newRule);
    }

    @Override
    public List<TradeRule> getRules() {
        return this.tradeRules;
    }

    public void setRules(List<TradeRule> rules) {
        this.tradeRules = rules;
    }

    public void removeRule(TradeRule rule) {
        if (this.tradeRules.contains(rule)) {
            this.tradeRules.remove(rule);
        }
    }

    @Override
    public void clearRules() {
        this.tradeRules.clear();
    }

    @Override
    public void markRulesDirty() {
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeTradeRules(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
        this.func_70296_d();
    }

    public void closeRuleScreen(PlayerEntity player) {
        this.openStorageMenu(player);
    }

    @Override
    public ITradeRuleScreenHandler getRuleScreenHandler() {
        return new TraderScreenHandler(this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        ItemInterfaceTileEntity.IItemHandlerBlock handlerBlock;
        ItemInterfaceTileEntity.IItemHandlerTileEntity tileEntity;
        Block block;
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (block = this.func_195044_w().func_177230_c()) instanceof ItemInterfaceTileEntity.IItemHandlerBlock && (tileEntity = (handlerBlock = (ItemInterfaceTileEntity.IItemHandlerBlock)block).getItemHandlerEntity(this.func_195044_w(), this.field_145850_b, this.field_174879_c)) != null) {
            IItemHandler handler = tileEntity.getItemHandler(handlerBlock.getRelativeSide(this.func_195044_w(), side));
            if (handler != null) {
                return LazyOptional.of(() -> handler).cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void sendSetTradeItemMessage(int tradeIndex, ItemStack sellItem, int slot) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetTradeItem(this.field_174879_c, tradeIndex, sellItem, slot));
        }
    }

    @Override
    public void sendSetTradePriceMessage(int tradeIndex, CoinValue newPrice, String newCustomName, ItemTradeData.ItemTradeType newTradeType) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetItemPrice(this.field_174879_c, tradeIndex, newPrice, newCustomName, newTradeType.name()));
        }
    }

    @Override
    public void sendTradeRuleUpdateMessage(int tradeIndex, ResourceLocation type, CompoundNBT updateInfo) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdateTradeRule(this.field_174879_c, tradeIndex, type, updateInfo));
        }
    }

    @Override
    public void receiveTradeRuleMessage(PlayerEntity player, int index, ResourceLocation ruleType, CompoundNBT updateInfo) {
        if (!this.hasPermission(player, "editTradeRules")) {
            Settings.PermissionWarning(player, "edit trade rule", "editTradeRules");
            return;
        }
        if (index >= 0) {
            this.getTrade(index).updateRule(ruleType, updateInfo);
            this.markTradesDirty();
        } else {
            this.updateRule(ruleType, updateInfo);
            this.markRulesDirty();
        }
    }

    private static class TraderScreenHandler
    implements ITradeRuleScreenHandler {
        private final ItemTraderTileEntity tileEntity;

        public TraderScreenHandler(ItemTraderTileEntity tileEntity) {
            this.tileEntity = tileEntity;
        }

        @Override
        public ITradeRuleHandler ruleHandler() {
            return this.tileEntity;
        }

        @Override
        public void reopenLastScreen() {
            this.tileEntity.sendOpenStorageMessage();
        }

        @Override
        public void updateServer(ResourceLocation type, CompoundNBT updateInfo) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdateTradeRule(this.tileEntity.field_174879_c, type, updateInfo));
        }

        @Override
        public boolean stillValid() {
            return !this.tileEntity.func_145837_r();
        }
    }

    private class ItemEditContainerProvider
    implements INamedContainerProvider {
        ItemTraderTileEntity tileEntity;
        int tradeIndex;

        public ItemEditContainerProvider(ItemTraderTileEntity tileEntity, int tradeIndex) {
            this.tileEntity = tileEntity;
            this.tradeIndex = tradeIndex;
        }

        public ITextComponent func_145748_c_() {
            return this.tileEntity.getName();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity entity) {
            return new ItemEditContainer(id, inventory, this.tileEntity.field_174879_c, this.tradeIndex);
        }
    }

    private class TradeCRContainerProvider
    implements INamedContainerProvider {
        ItemTraderTileEntity trader;
        CashRegisterTileEntity registerEntity;

        public TradeCRContainerProvider(ItemTraderTileEntity trader, CashRegisterTileEntity registerEntity) {
            this.trader = trader;
            this.registerEntity = registerEntity;
        }

        public ITextComponent func_145748_c_() {
            return this.trader.getName();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity entity) {
            return new ItemTraderContainer.ItemTraderContainerCR(id, inventory, this.trader.field_174879_c, this.registerEntity);
        }
    }

    private class StorageContainerProvider
    implements INamedContainerProvider {
        ItemTraderTileEntity trader;

        public StorageContainerProvider(ItemTraderTileEntity trader) {
            this.trader = trader;
        }

        public ITextComponent func_145748_c_() {
            return this.trader.getName();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity entity) {
            return new ItemTraderStorageContainer(id, inventory, this.trader.field_174879_c);
        }
    }

    private class TradeContainerProvider
    implements INamedContainerProvider {
        ItemTraderTileEntity trader;

        public TradeContainerProvider(ItemTraderTileEntity trader) {
            this.trader = trader;
        }

        public ITextComponent func_145748_c_() {
            return this.trader.getName();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity entity) {
            return new ItemTraderContainer(id, inventory, this.trader.field_174879_c);
        }
    }
}

