/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.tileentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.containers.PaygateContainer;
import io.github.lightman314.lightmanscurrency.core.ModTileEntities;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PaygateTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity,
INameable {
    public static final int PRICE_MIN = 0;
    public static final int PRICE_MAX = Integer.MAX_VALUE;
    public static final int DURATION_MIN = 1;
    public static final int DURATION_MAX = 200;
    private ITextComponent customName;
    private UUID ownerID = null;
    private UUID ticketID = null;
    private String ownerName = "";
    private CoinValue storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
    private CoinValue price = new CoinValue(new CoinValue.CoinValuePair[0]);
    private int duration = 40;
    private int timer = 0;

    public PaygateTileEntity() {
        super(ModTileEntities.PAYGATE);
    }

    public void setOwner(Entity player) {
        this.ownerID = player.func_110124_au();
        this.ownerName = player.func_200200_C_().getString();
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeOwner(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    public boolean isOwner(Entity player) {
        if (this.ownerID == null) {
            return true;
        }
        return player.func_110124_au().equals(this.ownerID);
    }

    public boolean canBreak(PlayerEntity player) {
        if (this.isOwner((Entity)player)) {
            return true;
        }
        return player.func_211513_k(2) && player.func_184812_l_();
    }

    public boolean isActive() {
        return this.timer > 0;
    }

    public CoinValue getStoredMoney() {
        return this.storedMoney;
    }

    public void addStoredMoney(CoinValue amount) {
        this.storedMoney.addValue(amount);
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeStoredMoney(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    public void clearStoredMoney() {
        this.storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeStoredMoney(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    public CoinValue getPrice() {
        return this.price;
    }

    public void setPrice(CoinValue value) {
        this.price = value;
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writePrice(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int value) {
        this.duration = MathUtil.clamp(value, 1, 200);
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeDuration(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    public void SetTicketID(UUID ticketID) {
        this.ticketID = ticketID;
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeTicket(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    public boolean HasPairedTicket() {
        return this.ticketID != null;
    }

    public boolean validTicket(ItemStack ticket) {
        if (ticket.func_190926_b()) {
            return false;
        }
        if (ticket.func_77973_b() instanceof TicketItem) {
            return !TicketItem.isMasterTicket(ticket) && this.validTicket(TicketItem.GetTicketID(ticket));
        }
        return false;
    }

    public boolean validTicket(UUID ticketID) {
        if (this.ticketID == null || ticketID == null) {
            return false;
        }
        return this.ticketID.equals(ticketID);
    }

    public void activate() {
        this.timer = this.duration;
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(true)));
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            TileEntityUtil.requestUpdatePacket(this.field_145850_b, this.field_174879_c);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeOwner(compound);
        this.writeStoredMoney(compound);
        this.writePrice(compound);
        this.writeDuration(compound);
        this.writeTimer(compound);
        this.writeTicket(compound);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return super.func_189515_b(compound);
    }

    private CompoundNBT writeOwner(CompoundNBT compound) {
        if (this.ownerID != null) {
            compound.func_186854_a("OwnerID", this.ownerID);
        }
        compound.func_74778_a("OwnerName", this.ownerName);
        return compound;
    }

    private CompoundNBT writeStoredMoney(CompoundNBT compound) {
        this.storedMoney.writeToNBT(compound, "StoredMoney");
        return compound;
    }

    private CompoundNBT writePrice(CompoundNBT compound) {
        this.price.writeToNBT(compound, "Price");
        return compound;
    }

    private CompoundNBT writeDuration(CompoundNBT compound) {
        compound.func_74768_a("Duration", this.duration);
        return compound;
    }

    private CompoundNBT writeTimer(CompoundNBT compound) {
        compound.func_74768_a("Timer", this.timer);
        return compound;
    }

    private CompoundNBT writeTicket(CompoundNBT compound) {
        if (this.ticketID != null) {
            compound.func_186854_a("TicketID", this.ticketID);
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("OwnerID")) {
            this.ownerID = compound.func_186857_a("OwnerID");
        }
        if (compound.func_150297_b("OwnerName", 8)) {
            this.ownerName = compound.func_74779_i("OwnerName");
        }
        if (compound.func_150297_b("StoredMoney", 3)) {
            this.storedMoney.readFromOldValue(compound.func_74762_e("StoredMoney"));
            LightmansCurrency.LogInfo("Reading stored money from older value format. Will be updated to newer value format.");
        } else if (compound.func_74764_b("StoredMoney")) {
            this.storedMoney.readFromNBT(compound, "StoredMoney");
        }
        if (compound.func_150297_b("Price", 3)) {
            this.price.readFromOldValue(compound.func_74762_e("Price"));
            LightmansCurrency.LogInfo("Reading price from older value format. Will be updated to newer value format.");
        } else if (compound.func_74764_b("Price")) {
            this.price.readFromNBT(compound, "Price");
        }
        if (compound.func_150297_b("Duration", 3)) {
            this.duration = compound.func_74762_e("Duration");
        }
        if (compound.func_150297_b("Timer", 3)) {
            this.timer = compound.func_74762_e("Timer");
        }
        if (compound.func_74764_b("TicketID")) {
            this.ticketID = compound.func_186857_a("TicketID");
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        super.func_230337_a_(state, compound);
    }

    public void func_73660_a() {
        if (this.timer > 0) {
            --this.timer;
            if (!this.field_145850_b.field_72995_K) {
                CompoundNBT compound = this.writeTimer(new CompoundNBT());
                TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
            }
            if (this.timer <= 0) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new PaygateContainer(windowId, inventory, this);
    }

    public ITextComponent func_145748_c_() {
        return this.getTitle();
    }

    public ITextComponent getTitle() {
        return new TranslationTextComponent("gui.lightmanscurrency.paygate.title", new Object[]{this.func_200200_C_(), this.ownerName});
    }

    public ITextComponent func_200200_C_() {
        if (this.customName == null) {
            return new TranslationTextComponent("block.lightmanscurrency.paygate");
        }
        return this.customName;
    }

    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
    }
}

