/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.tileentity;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.MessageRequestNBT;
import io.github.lightman314.lightmanscurrency.network.message.logger.MessageClearLogger;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageChangeSettings;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageOpenStorage;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageOpenTrades;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageRequestSyncUsers;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageSyncUsers;
import io.github.lightman314.lightmanscurrency.tileentity.CashRegisterTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.IOwnableTileEntity;
import io.github.lightman314.lightmanscurrency.tileentity.IPermissions;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class TraderTileEntity
extends TileEntity
implements IOwnableTileEntity,
ITickableTileEntity,
IPermissions,
ITrader {
    CoreTraderSettings coreSettings = new CoreTraderSettings(this, this::markCoreSettingsDirty, this::sendSettingsUpdateToServer);
    protected CoinValue storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
    private List<PlayerEntity> users = new ArrayList<PlayerEntity>();
    private int userCount = 0;
    private boolean versionUpdate = false;
    private int oldVersion = 0;

    protected TraderTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void userOpen(PlayerEntity player) {
        if (!this.users.contains(player)) {
            this.users.add(player);
            this.sendUserUpdate();
        }
    }

    @Override
    public void userClose(PlayerEntity player) {
        if (this.users.contains(player)) {
            this.users.remove(player);
            this.sendUserUpdate();
        }
    }

    public int getUserCount() {
        if (this.field_145850_b.field_72995_K) {
            return this.userCount;
        }
        return this.users.size();
    }

    public final void forceReopen() {
        this.forceReopen(Lists.newArrayList(this.users));
    }

    protected abstract void forceReopen(List<PlayerEntity> var1);

    protected List<PlayerEntity> getUsers() {
        return this.users;
    }

    private void sendUserUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            Chunk chunk = (Chunk)this.field_145850_b.func_217349_x(this.field_174879_c);
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new MessageSyncUsers(this.field_174879_c, this.getUserCount()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setUserCount(int value) {
        this.userCount = value;
    }

    @Override
    public CoreTraderSettings getCoreSettings() {
        return this.coreSettings;
    }

    @Override
    public void markCoreSettingsDirty() {
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeCoreSettings(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, this.superWrite(compound));
        }
        this.func_70296_d();
    }

    protected final void sendSettingsUpdateToServer(ResourceLocation type, CompoundNBT compound) {
        if (this.field_145850_b.field_72995_K) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageChangeSettings(this.field_174879_c, type, compound));
        }
    }

    public final void changeSettings(ResourceLocation type, PlayerEntity requestor, CompoundNBT updateInfo) {
        if (this.field_145850_b.field_72995_K) {
            LightmansCurrency.LogError("TraderTileEntity.changeSettings was called on a client.");
        }
        if (type.equals((Object)this.coreSettings.getType())) {
            this.coreSettings.changeSetting(requestor, updateInfo);
        } else {
            this.getAdditionalSettings().forEach(setting -> {
                if (type.equals((Object)setting.getType())) {
                    setting.changeSetting(requestor, updateInfo);
                }
            });
        }
    }

    public void initOwner(PlayerReference player) {
        this.coreSettings.initializeOwner(player);
    }

    @Override
    public boolean canBreak(PlayerEntity player) {
        return this.hasPermission(player, "breakTrader");
    }

    @Override
    public CoinValue getStoredMoney() {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            return account.getCoinStorage().copy();
        }
        return this.storedMoney;
    }

    @Override
    public CoinValue getInternalStoredMoney() {
        return this.storedMoney;
    }

    @Override
    public void addStoredMoney(CoinValue addedAmount) {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            account.depositCoins(addedAmount);
            account.LogInteraction(this, addedAmount, true);
            return;
        }
        this.storedMoney.addValue(addedAmount);
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeStoredMoney(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    @Override
    public void removeStoredMoney(CoinValue removedAmount) {
        if (this.coreSettings.hasBankAccount()) {
            BankAccount account = this.coreSettings.getBankAccount();
            account.withdrawCoins(removedAmount);
            account.LogInteraction(this, removedAmount, false);
            return;
        }
        long newValue = this.storedMoney.getRawValue() - removedAmount.getRawValue();
        this.storedMoney.readFromOldValue(newValue);
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeStoredMoney(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    @Override
    public void clearStoredMoney() {
        this.storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
        if (!this.field_145850_b.field_72995_K) {
            CompoundNBT compound = this.writeStoredMoney(new CompoundNBT());
            TileEntityUtil.sendUpdatePacket(this, super.func_189515_b(compound));
        }
    }

    public void func_73660_a() {
        if (this.versionUpdate && this.field_145850_b != null) {
            this.versionUpdate = false;
            if (!this.field_145850_b.field_72995_K) {
                this.onVersionUpdate(this.oldVersion);
            }
        }
    }

    @Override
    public ITextComponent getName() {
        if (this.coreSettings.hasCustomName()) {
            return new StringTextComponent(this.coreSettings.getCustomName());
        }
        return this.getBlockName();
    }

    private ITextComponent getBlockName() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    @Override
    public ITextComponent getTitle() {
        if (this.coreSettings.isCreative() || this.coreSettings.getOwnerName().isEmpty()) {
            return this.getName();
        }
        return new TranslationTextComponent("gui.lightmanscurrency.trading.title", new Object[]{this.getName(), this.coreSettings.getOwnerName()});
    }

    public abstract INamedContainerProvider getTradeMenuProvider();

    public void openTradeMenu(PlayerEntity player) {
        INamedContainerProvider provider = this.getTradeMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No trade menu container provider was given for the trader of type " + this.func_200662_C().getRegistryName().toString());
            return;
        }
        if (!(player instanceof ServerPlayerEntity)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
            return;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, (BlockPos)this.field_174879_c);
    }

    public abstract INamedContainerProvider getStorageMenuProvider();

    public void openStorageMenu(PlayerEntity player) {
        if (!this.hasPermission(player, "openStorage")) {
            Settings.PermissionWarning(player, "open trader storage", "openStorage");
            return;
        }
        INamedContainerProvider provider = this.getStorageMenuProvider();
        if (provider == null) {
            LightmansCurrency.LogError("No storage container provider was given for the trader of type " + this.func_200662_C().getRegistryName().toString());
            return;
        }
        if (!(player instanceof ServerPlayerEntity)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the storage menu.");
            return;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, (BlockPos)this.field_174879_c);
    }

    public abstract INamedContainerProvider getCashRegisterTradeMenuProvider(CashRegisterTileEntity var1);

    public void openCashRegisterTradeMenu(PlayerEntity player, CashRegisterTileEntity cashRegister) {
        INamedContainerProvider provider = this.getCashRegisterTradeMenuProvider(cashRegister);
        if (provider == null) {
            LightmansCurrency.LogError("No cash register container provider was given for the trader of type " + this.func_200662_C().getRegistryName().toString());
            return;
        }
        if (!(player instanceof ServerPlayerEntity)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the cash register menu.");
            return;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, (Consumer)new CRDataWriter(this.field_174879_c, cashRegister.func_174877_v()));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeCoreSettings(compound);
        this.writeStoredMoney(compound);
        this.writeVersion(compound);
        return super.func_189515_b(compound);
    }

    public CompoundNBT superWrite(CompoundNBT compound) {
        return super.func_189515_b(compound);
    }

    protected CompoundNBT writeStoredMoney(CompoundNBT compound) {
        this.storedMoney.writeToNBT(compound, "StoredMoney");
        return compound;
    }

    protected CompoundNBT writeCoreSettings(CompoundNBT compound) {
        compound.func_218657_a("CoreSettings", (INBT)this.coreSettings.save(new CompoundNBT()));
        return compound;
    }

    protected CompoundNBT writeVersion(CompoundNBT compound) {
        compound.func_74768_a("TraderVersion", this.GetCurrentVersion());
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_150297_b("CoreSettings", 10)) {
            this.coreSettings.load(compound.func_74775_l("CoreSettings"));
        } else if (compound.func_74764_b("OwnerID")) {
            this.coreSettings.loadFromOldTraderData(compound);
        }
        if (compound.func_150297_b("StoredMoney", 3)) {
            LightmansCurrency.LogInfo("Reading stored money from older value format. Will be updated to newer value format.");
            this.storedMoney.readFromOldValue(compound.func_74762_e("StoredMoney"));
        } else if (compound.func_74764_b("StoredMoney")) {
            this.storedMoney.readFromNBT(compound, "StoredMoney");
        }
        if (compound.func_150297_b("TraderVersion", 3)) {
            this.oldVersion = compound.func_74762_e("TraderVersion");
        }
        if (this.oldVersion < this.GetCurrentVersion()) {
            this.versionUpdate = true;
        }
        super.func_230337_a_(state, compound);
    }

    protected abstract void onVersionUpdate(int var1);

    public int GetCurrentVersion() {
        return 0;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRequestNBT(this));
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRequestSyncUsers(this.field_174879_c));
        }
    }

    public void dumpContents(World world, BlockPos pos) {
        List<ItemStack> coinItems = MoneyUtil.getCoinsOfValue(this.storedMoney);
        if (coinItems.size() > 0) {
            InventoryUtil.dumpContents(world, pos, coinItems);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
    }

    @Override
    public boolean isClient() {
        if (this.field_145850_b == null) {
            return true;
        }
        return this.field_145850_b.field_72995_K;
    }

    @Override
    public void sendOpenTraderMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenTrades(this.field_174879_c));
        }
    }

    @Override
    public void sendOpenStorageMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage(this.field_174879_c));
        }
    }

    @Override
    public void sendClearLogMessage() {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageClearLogger(this.field_174879_c));
        }
    }

    protected class TradeIndexDataWriter
    implements Consumer<PacketBuffer> {
        BlockPos traderPos;
        int tradeIndex;

        public TradeIndexDataWriter(BlockPos traderPos, int tradeIndex) {
            this.traderPos = traderPos;
            this.tradeIndex = tradeIndex;
        }

        @Override
        public void accept(PacketBuffer buffer) {
            buffer.func_179255_a(this.traderPos);
            buffer.writeInt(this.tradeIndex);
        }
    }

    private class CRDataWriter
    implements Consumer<PacketBuffer> {
        BlockPos traderPos;
        BlockPos registerPos;

        public CRDataWriter(BlockPos traderPos, BlockPos registerPos) {
            this.traderPos = traderPos;
            this.registerPos = registerPos;
        }

        @Override
        public void accept(PacketBuffer buffer) {
            buffer.func_179255_a(this.traderPos);
            buffer.func_179255_a(this.registerPos);
        }
    }
}

