/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.tileentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.MessageRequestNBT;
import io.github.lightman314.lightmanscurrency.tileentity.IOwnableTileEntity;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public abstract class UniversalTraderTileEntity
extends TileEntity
implements IOwnableTileEntity {
    UUID traderID = null;

    protected UniversalTraderData getData() {
        if (this.traderID != null) {
            return TradingOffice.getData(this.traderID);
        }
        LightmansCurrency.LogError("Trader ID is null. Cannot get the trader data (" + DebugUtil.getSideText(this.field_145850_b) + ").");
        return null;
    }

    public UniversalTraderTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public UUID getTraderID() {
        return this.traderID;
    }

    public void updateNames(PlayerEntity player) {
        if (this.getData() == null) {
            LightmansCurrency.LogError("Trader Data for trader of id '" + this.traderID + "' is null (tileEntity.updateNames," + DebugUtil.getSideText((Entity)player) + ").");
            return;
        }
        this.getData().getCoreSettings().updateNames(player);
    }

    public boolean hasPermission(PlayerEntity player, String permission) {
        if (this.getData() == null) {
            LightmansCurrency.LogError("Trader Data for trader of id '" + this.traderID + "' is null (tileEntity.hasPermission," + DebugUtil.getSideText((Entity)player) + ").");
            return true;
        }
        return this.getData().hasPermission(player, permission);
    }

    public int getPermissionLevel(PlayerEntity player, String permission) {
        if (this.getData() == null) {
            LightmansCurrency.LogError("Trader Data for trader of id '" + this.traderID + "' is null (tileEntity.getPermisisonLevel," + DebugUtil.getSideText((Entity)player) + ").");
            return Integer.MAX_VALUE;
        }
        return this.getData().getPermissionLevel(player, permission);
    }

    @Override
    public boolean canBreak(PlayerEntity player) {
        return this.hasPermission(player, "breakTrader");
    }

    public void init(PlayerEntity owner) {
        this.init(owner, null);
    }

    public void init(PlayerEntity owner, String customName) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.traderID == null) {
            UniversalTraderData traderData = this.createInitialData(owner);
            if (customName != null) {
                traderData.getCoreSettings().setCustomName(null, customName);
            }
            this.traderID = TradingOffice.registerTrader(traderData, owner);
            TileEntityUtil.sendUpdatePacket(this);
        }
    }

    protected abstract UniversalTraderData createInitialData(PlayerEntity var1);

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRequestNBT(this));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.traderID != null) {
            compound.func_186854_a("ID", this.traderID);
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("ID")) {
            this.traderID = compound.func_186857_a("ID");
        }
        super.func_230337_a_(state, compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
    }

    public void openStorageMenu(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K && this.getData() != null) {
            this.getData().openStorageMenu((PlayerEntity)((ServerPlayerEntity)player));
        }
    }

    public void onDestroyed() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        UniversalTraderData data = this.getData();
        TradingOffice.removeTrader(this.traderID);
        if (data != null) {
            this.dumpContents(data);
        }
    }

    protected void dumpContents(@Nonnull UniversalTraderData data) {
        InventoryUtil.dumpContents(this.field_145850_b, this.field_174879_c, MoneyUtil.getCoinsOfValue(data.getInternalStoredMoney()));
    }
}

