/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.tileentity.handler;

import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.settings.ItemTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class TraderItemHandler {
    private final IItemHandler inputOnly;
    private final IItemHandler outputOnly;
    private final IItemHandler inputAndOutput;

    public TraderItemHandler(IItemTrader trader) {
        this.inputOnly = new InputOnly(trader);
        this.outputOnly = new OutputOnly(trader);
        this.inputAndOutput = new InputAndOutput(trader);
    }

    public IItemHandler getHandler(ItemTraderSettings.ItemHandlerSettings settings) {
        switch (settings) {
            case INPUT_ONLY: {
                return this.inputOnly;
            }
            case OUTPUT_ONLY: {
                return this.outputOnly;
            }
            case INPUT_AND_OUTPUT: {
                return this.inputAndOutput;
            }
        }
        return null;
    }

    private static class InputAndOutput
    extends TraderHandlerTemplate {
        protected InputAndOutput(IItemTrader trader) {
            super(trader);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack copyStack = stack.func_77946_l();
            ItemStack currentStack = this.getStorage().func_70301_a(slot);
            if (this.limitInputs() && !this.traderSells(copyStack)) {
                return copyStack;
            }
            if (currentStack.func_190926_b() || InventoryUtil.ItemMatches(copyStack, currentStack)) {
                int space = currentStack.func_190926_b() ? copyStack.func_77976_d() : currentStack.func_77976_d() - currentStack.func_190916_E();
                int fillAmount = MathUtil.clamp(copyStack.func_190916_E(), 0, space);
                if (fillAmount > 0) {
                    copyStack.func_190918_g(fillAmount);
                    if (!simulate) {
                        if (currentStack.func_190926_b()) {
                            ItemStack placeStack = stack.func_77946_l();
                            placeStack.func_190920_e(fillAmount);
                            this.getStorage().func_70299_a(slot, placeStack);
                        } else {
                            currentStack.func_190917_f(fillAmount);
                        }
                    }
                }
            }
            return copyStack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = this.getStorage().func_70301_a(slot);
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (this.limitOutputs() && !this.traderPurchases(stack)) {
                return ItemStack.field_190927_a;
            }
            int emptyAmount = MathUtil.clamp(amount, 0, Math.min(stack.func_190916_E(), stack.func_77976_d()));
            if (emptyAmount > 0) {
                ItemStack emptyStack = stack.func_77946_l();
                emptyStack.func_190920_e(emptyAmount);
                if (!simulate) {
                    stack.func_190918_g(emptyAmount);
                    if (stack.func_190926_b()) {
                        this.getStorage().func_70299_a(slot, ItemStack.field_190927_a);
                    }
                }
                return emptyStack;
            }
            return ItemStack.field_190927_a;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (this.limitInputs()) {
                return this.traderSells(stack);
            }
            return true;
        }
    }

    private static class OutputOnly
    extends TraderHandlerTemplate {
        protected OutputOnly(IItemTrader trader) {
            super(trader);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack.func_77946_l();
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = this.getStorage().func_70301_a(slot);
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (this.limitOutputs() && !this.traderPurchases(stack)) {
                return ItemStack.field_190927_a;
            }
            int emptyAmount = MathUtil.clamp(amount, 0, Math.min(stack.func_190916_E(), stack.func_77976_d()));
            if (emptyAmount > 0) {
                ItemStack emptyStack = stack.func_77946_l();
                emptyStack.func_190920_e(emptyAmount);
                if (!simulate) {
                    stack.func_190918_g(emptyAmount);
                    if (stack.func_190926_b()) {
                        this.getStorage().func_70299_a(slot, ItemStack.field_190927_a);
                    }
                }
                return emptyStack;
            }
            return ItemStack.field_190927_a;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }

    private static class InputOnly
    extends TraderHandlerTemplate {
        private InputOnly(IItemTrader trader) {
            super(trader);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack copyStack = stack.func_77946_l();
            ItemStack currentStack = this.getStorage().func_70301_a(slot);
            if (this.limitInputs() && !this.traderSells(copyStack)) {
                return copyStack;
            }
            if (currentStack.func_190926_b() || InventoryUtil.ItemMatches(copyStack, currentStack)) {
                int space = currentStack.func_190926_b() ? copyStack.func_77976_d() : currentStack.func_77976_d() - currentStack.func_190916_E();
                int fillAmount = MathUtil.clamp(copyStack.func_190916_E(), 0, space);
                if (fillAmount > 0) {
                    copyStack.func_190918_g(fillAmount);
                    if (!simulate) {
                        if (currentStack.func_190926_b()) {
                            ItemStack placeStack = stack.func_77946_l();
                            placeStack.func_190920_e(fillAmount);
                            this.getStorage().func_70299_a(slot, placeStack);
                        } else {
                            currentStack.func_190917_f(fillAmount);
                        }
                    }
                }
            }
            return copyStack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (this.limitInputs()) {
                return this.traderSells(stack);
            }
            return true;
        }
    }

    private static abstract class TraderHandlerTemplate
    implements IItemHandler {
        private final IItemTrader trader;

        protected TraderHandlerTemplate(IItemTrader trader) {
            this.trader = trader;
        }

        protected final IInventory getStorage() {
            return this.trader.getStorage();
        }

        protected final boolean limitInputs() {
            return this.trader.getItemSettings().limitInputsToSales();
        }

        protected final boolean limitOutputs() {
            return this.trader.getItemSettings().limitOutputsToPurchases();
        }

        protected final boolean traderSells(ItemStack stack) {
            for (ItemTradeData trade : this.trader.getAllTrades()) {
                if (!trade.isValid() || !trade.isSale() && !trade.isBarter() || !InventoryUtil.ItemMatches(trade.getSellItem(), stack)) continue;
                return true;
            }
            return false;
        }

        protected final boolean traderPurchases(ItemStack stack) {
            for (ItemTradeData trade : this.trader.getAllTrades()) {
                if (!trade.isValid() || !(trade.isPurchase() ? InventoryUtil.ItemMatches(trade.getSellItem(), stack) : trade.isBarter() && InventoryUtil.ItemMatches(trade.getBarterItem(), stack))) continue;
                return true;
            }
            return false;
        }

        public int getSlots() {
            return this.getStorage().func_70302_i_();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.getStorage().func_70301_a(slot);
        }

        public int getSlotLimit(int slot) {
            return this.getStorage().func_70301_a(slot).func_77976_d();
        }
    }
}

