/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.api.ILoggerSupport;
import io.github.lightman314.lightmanscurrency.api.ItemShopLogger;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.tileentity.ItemInterfaceTileEntity;
import io.github.lightman314.lightmanscurrency.trader.ITradeSource;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.ItemTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public interface IItemTrader
extends ITrader,
ItemInterfaceTileEntity.IItemHandlerTileEntity,
ITradeRuleHandler,
ITradeRuleHandler.ITradeRuleMessageHandler,
ILoggerSupport<ItemShopLogger>,
ITradeSource<ItemTradeData> {
    @Override
    public List<ItemTradeData> getAllTrades();

    public IInventory getStorage();

    public void markTradesDirty();

    public void markStorageDirty();

    public void openTradeMenu(PlayerEntity var1);

    public void openStorageMenu(PlayerEntity var1);

    public void openItemEditMenu(PlayerEntity var1, int var2);

    public ItemTraderSettings getItemSettings();

    public void markItemSettingsDirty();

    public ITradeRuleScreenHandler getRuleScreenHandler();

    public void sendTradeRuleUpdateMessage(int var1, ResourceLocation var2, CompoundNBT var3);

    public void sendSetTradeItemMessage(int var1, ItemStack var2, int var3);

    public void sendSetTradePriceMessage(int var1, CoinValue var2, String var3, ItemTradeData.ItemTradeType var4);

    default public TradeEvent.PreTradeEvent runPreTradeEvent(PlayerEntity player, int tradeIndex) {
        return this.runPreTradeEvent(PlayerReference.of(player), tradeIndex);
    }

    default public TradeEvent.PreTradeEvent runPreTradeEvent(PlayerReference player, int tradeIndex) {
        ItemTradeData trade = (ItemTradeData)this.getTrade(tradeIndex);
        TradeEvent.PreTradeEvent event = new TradeEvent.PreTradeEvent(player, trade, (Supplier<ITrader>)((Supplier)() -> this));
        trade.beforeTrade(event);
        if (this instanceof ITradeRuleHandler) {
            this.beforeTrade(event);
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    default public TradeEvent.TradeCostEvent runTradeCostEvent(PlayerEntity player, int tradeIndex) {
        return this.runTradeCostEvent(PlayerReference.of(player), tradeIndex);
    }

    default public TradeEvent.TradeCostEvent runTradeCostEvent(PlayerReference player, int tradeIndex) {
        ItemTradeData trade = (ItemTradeData)this.getTrade(tradeIndex);
        TradeEvent.TradeCostEvent event = new TradeEvent.TradeCostEvent(player, trade, (Supplier<ITrader>)((Supplier)() -> this));
        trade.tradeCost(event);
        if (this instanceof ITradeRuleHandler) {
            this.tradeCost(event);
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    default public void runPostTradeEvent(PlayerEntity player, int tradeIndex, CoinValue pricePaid) {
        this.runPostTradeEvent(PlayerReference.of(player), tradeIndex, pricePaid);
    }

    default public void runPostTradeEvent(PlayerReference player, int tradeIndex, CoinValue pricePaid) {
        ItemTradeData trade = (ItemTradeData)this.getTrade(tradeIndex);
        TradeEvent.PostTradeEvent event = new TradeEvent.PostTradeEvent(player, trade, (Supplier<ITrader>)((Supplier)() -> this), pricePaid);
        trade.afterTrade(event);
        if (event.isDirty()) {
            this.markTradesDirty();
            event.clean();
        }
        if (this instanceof ITradeRuleHandler) {
            this.afterTrade(event);
            if (event.isDirty()) {
                this.markRulesDirty();
                event.clean();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
    }
}

