/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader;

import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.tileentity.IPermissions;
import io.github.lightman314.lightmanscurrency.trader.settings.CoreTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;

public interface ITrader
extends IPermissions {
    public ITextComponent getName();

    public ITextComponent getTitle();

    public CoinValue getStoredMoney();

    public CoinValue getInternalStoredMoney();

    public void addStoredMoney(CoinValue var1);

    public void removeStoredMoney(CoinValue var1);

    public void clearStoredMoney();

    public int getTradeCount();

    public int getTradeCountLimit();

    public int getTradeStock(int var1);

    public CoreTraderSettings getCoreSettings();

    public void markCoreSettingsDirty();

    public List<Settings> getAdditionalSettings();

    default public Map<String, Integer> getAllyDefaultPermissions() {
        return Maps.newHashMap();
    }

    public void requestAddOrRemoveTrade(boolean var1);

    public void addTrade(PlayerEntity var1);

    public void removeTrade(PlayerEntity var1);

    public boolean isClient();

    default public boolean isServer() {
        return !this.isClient();
    }

    public void userOpen(PlayerEntity var1);

    public void userClose(PlayerEntity var1);

    public void sendOpenTraderMessage();

    public void sendOpenStorageMessage();

    public void sendClearLogMessage();

    @Override
    default public int getPermissionLevel(PlayerEntity player, String permission) {
        return this.getCoreSettings().getPermissionLevel(player, permission);
    }

    @Override
    default public int getPermissionLevel(PlayerReference player, String permission) {
        return this.getCoreSettings().getPermissionLevel(player, permission);
    }

    default public boolean canInteractRemotely() {
        return false;
    }
}

