/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.permissions;

import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class PermissionsList {
    private final HashMap<String, Integer> permissions = Maps.newHashMap();
    private final ITrader trader;
    private final String updateType;

    public PermissionsList(ITrader trader, String updateType) {
        this.trader = trader;
        this.updateType = updateType;
    }

    public PermissionsList(ITrader trader, String updateType, Map<String, Integer> permissions) {
        this(trader, updateType);
        permissions.forEach((permission, level) -> this.setLevel((String)permission, (int)level));
    }

    public int getLevel(String permission) {
        if (this.permissions.containsKey(permission)) {
            return this.permissions.get(permission);
        }
        return 0;
    }

    public CompoundNBT changeLevel(PlayerEntity requestor, String permission, int level) {
        if (!this.trader.hasPermission(requestor, "editPermissions")) {
            Settings.PermissionWarning(requestor, "edit permissions", "editPermissions");
            return null;
        }
        this.setLevel(permission, level);
        CompoundNBT updateInfo = Settings.initUpdateInfo(this.updateType);
        updateInfo.func_74778_a("permission", permission);
        updateInfo.func_74768_a("level", this.getLevel(permission));
        return updateInfo;
    }

    public boolean changeLevel(PlayerEntity requestor, CompoundNBT updateInfo) {
        if (!this.trader.hasPermission(requestor, "editPermissions")) {
            Settings.PermissionWarning(requestor, "edit permissions", "editPermissions");
            return false;
        }
        String permission = updateInfo.func_74779_i("permission");
        int level = updateInfo.func_74762_e("level");
        if (level == this.getLevel(permission)) {
            return false;
        }
        int oldLevel = this.getLevel(permission);
        this.setLevel(permission, level);
        this.trader.getCoreSettings().getLogger().LogSettingsChange(requestor, this.updateType + "." + permission, oldLevel, this.getLevel(permission));
        return true;
    }

    public void setLevel(String permission, int level) {
        if (level <= 0) {
            this.resetLevel(permission);
        } else {
            this.permissions.put(permission, level);
        }
    }

    private void resetLevel(String permission) {
        if (this.permissions.containsKey(permission)) {
            this.permissions.remove(permission);
        }
    }

    public void save(CompoundNBT compound, String tag) {
        ListNBT list = new ListNBT();
        this.permissions.forEach((permission, level) -> {
            CompoundNBT thisCompound = new CompoundNBT();
            thisCompound.func_74778_a("permission", permission);
            thisCompound.func_74768_a("level", level.intValue());
            list.add((Object)thisCompound);
        });
        compound.func_218657_a(tag, (INBT)list);
    }

    public static PermissionsList load(ITrader trader, String updateType, CompoundNBT compound, String tag) {
        PermissionsList result = new PermissionsList(trader, updateType);
        if (compound.func_150297_b(tag, 9)) {
            ListNBT list = compound.func_150295_c(tag, 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT thisCompound = list.func_150305_b(i);
                String permission = thisCompound.func_74779_i("permission");
                int level = thisCompound.func_74762_e("level");
                result.setLevel(permission, level);
            }
        }
        return result;
    }
}

