/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.settings;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.SettingsLogger;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.core.AllyPermissionsTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.core.AllyTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.core.LoggerTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.core.MainTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.core.OwnershipTab;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.permissions.PermissionsList;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.BooleanPermission;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CoreTraderSettings
extends Settings {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "trader_core");
    private static final String UPDATE_CUSTOM_NAME = "customName";
    private static final String UPDATE_ADD_ALLY = "addAlly";
    private static final String UPDATE_REMOVE_ALLY = "removeAlly";
    private static final String UPDATE_ALLY_PERMISSIONS = "allyPermissions";
    private static final String UPDATE_CREATIVE = "creative";
    private static final String UPDATE_OWNERSHIP = "transferOwnership";
    private static final String UPDATE_TEAM = "changeTeam";
    private static final String UPDATE_BANK_LINK = "bankLink";
    PlayerReference owner = null;
    String customOwnerName = "";
    Team.TeamReference team = null;
    List<PlayerReference> allies = Lists.newArrayList();
    PermissionsList allyPermissions = CoreTraderSettings.getAllyDefaultPermissions(this.trader);
    String customName = "";
    boolean isCreative = false;
    boolean bankAccountLinked = false;
    SettingsLogger logger = new SettingsLogger();

    public static PermissionsList getAllyDefaultPermissions(@Nonnull ITrader trader) {
        HashMap defaultPermissions = Maps.newHashMap();
        defaultPermissions.put("openStorage", 1);
        defaultPermissions.put("editTrades", 1);
        defaultPermissions.put("editTradeRules", 1);
        defaultPermissions.put("editSettings", 1);
        defaultPermissions.put("changeName", 1);
        try {
            trader.getAllyDefaultPermissions().forEach((key, value) -> defaultPermissions.put(key, value));
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error getting additional default ally permissions for trader type " + trader.getClass().getName(), e);
        }
        return new PermissionsList(trader, UPDATE_ALLY_PERMISSIONS, defaultPermissions);
    }

    public void setCustomOwnerName(String ownerName) {
        this.customOwnerName = ownerName;
    }

    public Team getTeam() {
        if (this.team != null) {
            return this.team.getTeam(this.trader.isClient());
        }
        return null;
    }

    public PermissionsList getAllyPermissions() {
        return this.allyPermissions;
    }

    public boolean hasCustomName() {
        return !this.customName.isEmpty();
    }

    public String getCustomName() {
        return this.customName;
    }

    public void forceCustomName(String customName) {
        this.customName = customName;
    }

    public CompoundNBT setCustomName(PlayerEntity requestor, String newName) {
        if (!this.hasPermission(requestor, "changeName")) {
            CoreTraderSettings.PermissionWarning(requestor, "change the traders name", "changeName");
            return null;
        }
        if (!this.customName.contentEquals(newName)) {
            String oldName = this.customName;
            this.customName = newName;
            this.logger.LogNameChange(requestor, oldName, this.customName);
            this.markDirty();
            CompoundNBT updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_CUSTOM_NAME);
            updateInfo.func_74778_a("NewName", this.customName);
            return updateInfo;
        }
        return null;
    }

    public boolean canLinkBankAccount() {
        Team t = this.getTeam();
        if (t != null) {
            return t.hasBankAccount();
        }
        return true;
    }

    public boolean isBankAccountLinked() {
        return this.bankAccountLinked;
    }

    public boolean hasBankAccount() {
        return this.getBankAccount() != null;
    }

    public BankAccount getBankAccount() {
        if (!this.bankAccountLinked) {
            return null;
        }
        Team t = this.getTeam();
        if (t != null) {
            return t.getBankAccount();
        }
        if (this.owner != null) {
            return BankAccount.GenerateReference(this.trader.isClient(), BankAccount.AccountType.Player, this.owner.id).get();
        }
        return null;
    }

    public CoreTraderSettings(ITrader trader, Settings.IMarkDirty marker, BiConsumer<ResourceLocation, CompoundNBT> sendToServer) {
        super(trader, marker, sendToServer, TYPE);
    }

    public PlayerReference getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        if (this.getTeam() != null) {
            return this.getTeam().getName();
        }
        if (this.owner != null) {
            return this.owner.lastKnownName();
        }
        return this.customOwnerName;
    }

    public void initializeOwner(PlayerReference owner) {
        if (this.owner == null) {
            this.owner = owner;
        } else {
            LightmansCurrency.LogWarning("Attempted to initialize the owner for a trader that is already owned.");
        }
    }

    public CompoundNBT setOwner(PlayerEntity requestor, String newOwnerName) {
        if (!this.hasPermission(requestor, UPDATE_OWNERSHIP)) {
            CoreTraderSettings.PermissionWarning(requestor, "transfer ownership", UPDATE_OWNERSHIP);
            return null;
        }
        if (this.owner == null) {
            Team oldTeam = this.getTeam();
            if (oldTeam != null) {
                this.team = null;
            }
            this.owner = PlayerReference.of(newOwnerName);
            if (this.owner != null && oldTeam != null) {
                this.logger.LogTeamChange(requestor, this.owner, oldTeam, null);
            }
            if (this.bankAccountLinked) {
                this.bankAccountLinked = false;
            }
            CompoundNBT updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_OWNERSHIP);
            updateInfo.func_74778_a("newOwner", newOwnerName);
            return updateInfo;
        }
        PlayerReference newOwner = PlayerReference.of(newOwnerName);
        if (!(newOwner == null || this.owner.is(newOwner) && this.team == null)) {
            Team oldTeam = this.getTeam();
            if (oldTeam != null) {
                this.team = null;
            }
            PlayerReference oldOwner = this.owner;
            this.owner = newOwner;
            if (oldTeam == null) {
                this.logger.LogOwnerChange(requestor, oldOwner, this.owner);
            } else {
                this.logger.LogTeamChange(requestor, this.owner, oldTeam, null);
            }
            if (this.bankAccountLinked) {
                this.bankAccountLinked = false;
            }
            CompoundNBT updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_OWNERSHIP);
            updateInfo.func_74778_a("newOwner", newOwnerName);
            return updateInfo;
        }
        return null;
    }

    public CompoundNBT setTeam(PlayerEntity requestor, @Nullable UUID newTeamID) {
        if (!this.hasPermission(requestor, UPDATE_OWNERSHIP)) {
            CoreTraderSettings.PermissionWarning(requestor, "transfer team ownership", UPDATE_OWNERSHIP);
            return null;
        }
        Team oldTeam = null;
        if (this.team != null) {
            if (this.team.getID().equals(newTeamID)) {
                return null;
            }
            oldTeam = this.getTeam();
        }
        this.team = Team.referenceOf(newTeamID);
        Team newTeam = this.getTeam();
        this.logger.LogTeamChange(requestor, this.owner, oldTeam, newTeam);
        if (this.bankAccountLinked) {
            this.bankAccountLinked = false;
        }
        CompoundNBT updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_TEAM);
        if (newTeamID != null) {
            updateInfo.func_186854_a("Team", newTeamID);
        }
        return updateInfo;
    }

    public List<PlayerReference> getAllies() {
        return this.allies;
    }

    public CompoundNBT addAlly(PlayerEntity requestor, String newAllyName) {
        if (!this.hasPermission(requestor, "addRemoveAllies")) {
            CoreTraderSettings.PermissionWarning(requestor, "add an ally", "addRemoveAllies");
            return null;
        }
        if (!PlayerReference.listContains(this.allies, newAllyName)) {
            PlayerReference newAlly = PlayerReference.of(newAllyName);
            if (newAlly != null) {
                this.allies.add(newAlly);
                this.logger.LogAllyChange(requestor, newAlly, true);
            }
            if (newAlly != null || requestor.field_70170_p.field_72995_K) {
                CompoundNBT updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_ADD_ALLY);
                updateInfo.func_74778_a("AllyName", newAllyName);
                return updateInfo;
            }
        }
        return null;
    }

    public CompoundNBT removeAlly(PlayerEntity requestor, String removedAllyName) {
        if (!this.hasPermission(requestor, "addRemoveAllies")) {
            CoreTraderSettings.PermissionWarning(requestor, "remove an ally", "addRemoveAllies");
            return null;
        }
        if (PlayerReference.listContains(this.allies, removedAllyName)) {
            PlayerReference removedAlly = null;
            for (int i = 0; i < this.allies.size() && removedAlly == null; ++i) {
                if (!this.allies.get(i).is(removedAllyName)) continue;
                removedAlly = this.allies.get(i);
                this.allies.remove(i);
            }
            if (removedAlly == null) {
                return null;
            }
            this.logger.LogAllyChange(requestor, removedAlly, false);
            CompoundNBT updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_REMOVE_ALLY);
            updateInfo.func_74778_a("AllyName", removedAllyName);
            return updateInfo;
        }
        return null;
    }

    public void updateNames(PlayerEntity player) {
        if (this.owner != null) {
            this.owner.tryUpdateName(player);
        }
        for (PlayerReference ally : this.allies) {
            ally.tryUpdateName(player);
        }
    }

    public boolean hasPermission(PlayerEntity player, String permission) {
        if (player == null) {
            return true;
        }
        return this.getPermissionLevel(player, permission) > 0;
    }

    public int getPermissionLevel(PlayerEntity player, String permission) {
        if (player == null || TradingOffice.isAdminPlayer(player)) {
            return Integer.MAX_VALUE;
        }
        return this.getPermissionLevel(PlayerReference.of(player), permission);
    }

    public int getPermissionLevel(PlayerReference player, String permission) {
        Team actualTeam;
        if (player == null) {
            return 0;
        }
        int level = 0;
        if (PlayerReference.listContains(this.allies, player.id)) {
            level = this.allyPermissions.getLevel(permission);
        }
        boolean foundTeam = false;
        if (this.team != null && (actualTeam = this.team.getTeam(this.trader.isClient())) != null) {
            foundTeam = true;
            if (actualTeam.isAdmin(player.id)) {
                return Integer.MAX_VALUE;
            }
            if (actualTeam.isMember(player.id)) {
                level = Math.max(level, this.allyPermissions.getLevel(permission));
            }
        }
        if (!foundTeam && this.owner != null && this.owner.is(player)) {
            return Integer.MAX_VALUE;
        }
        return level;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public CompoundNBT toggleCreative(PlayerEntity requestor) {
        if (!TradingOffice.isAdminPlayer(requestor)) {
            CoreTraderSettings.PermissionWarning(requestor, "toggle creative mode", "LC_ADMIN_MODE");
            return null;
        }
        this.isCreative = !this.isCreative;
        this.logger.LogCreativeToggle(requestor, this.isCreative);
        this.markDirty();
        CompoundNBT updateInfo = CoreTraderSettings.initUpdateInfo(UPDATE_CREATIVE);
        updateInfo.func_74757_a("isCreative", this.isCreative);
        return updateInfo;
    }

    public void forceCreative() {
        this.isCreative = true;
    }

    public CompoundNBT toggleBankAccountLink(PlayerEntity requestor) {
        boolean sendValue;
        if (!this.hasPermission(requestor, UPDATE_BANK_LINK)) {
            CoreTraderSettings.PermissionWarning(requestor, "toggle bank account link", UPDATE_BANK_LINK);
            return null;
        }
        boolean bl = sendValue = !this.bankAccountLinked;
        if (this.bankAccountLinked || this.canLinkBankAccount()) {
            boolean bl2 = this.bankAccountLinked = !this.bankAccountLinked;
            if (this.bankAccountLinked && this.getBankAccount() != null && this.trader.getInternalStoredMoney().getRawValue() > 0L) {
                CoinValue money = this.trader.getInternalStoredMoney();
                this.getBankAccount().depositCoins(money);
                this.getBankAccount().LogInteraction(this.trader, money, true);
                this.trader.clearStoredMoney();
            }
        }
        CompoundNBT result = CoreTraderSettings.initUpdateInfo(UPDATE_BANK_LINK);
        result.func_74757_a("IsLinked", sendValue);
        return result;
    }

    public SettingsLogger getLogger() {
        return this.logger;
    }

    @Override
    public void changeSetting(PlayerEntity requestor, CompoundNBT updateInfo) {
        CompoundNBT result;
        boolean newValue;
        if (this.isUpdateType(updateInfo, UPDATE_CUSTOM_NAME)) {
            String newName = updateInfo.func_74779_i("NewName");
            CompoundNBT result2 = this.setCustomName(requestor, newName);
            if (result2 != null) {
                this.markDirty();
            }
            LightmansCurrency.LogInfo("Custom Name changed to '" + newName + "' on the server.");
        } else if (this.isUpdateType(updateInfo, UPDATE_ADD_ALLY)) {
            String allyName = updateInfo.func_74779_i("AllyName");
            CompoundNBT result3 = this.addAlly(requestor, allyName);
            if (result3 != null) {
                this.markDirty();
            }
            LightmansCurrency.LogInfo("Attempted to add '" + allyName + "' as an ally.");
        } else if (this.isUpdateType(updateInfo, UPDATE_REMOVE_ALLY)) {
            String allyName = updateInfo.func_74779_i("AllyName");
            CompoundNBT result4 = this.removeAlly(requestor, allyName);
            if (result4 != null) {
                this.markDirty();
            }
            LightmansCurrency.LogInfo("Attempted to remove '" + allyName + "' from the ally list.");
        } else if (this.isUpdateType(updateInfo, UPDATE_CREATIVE)) {
            CompoundNBT result5;
            boolean nowCreative = updateInfo.func_74767_n("isCreative");
            if (nowCreative != this.isCreative && (result5 = this.toggleCreative(requestor)) != null) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_ALLY_PERMISSIONS)) {
            if (this.allyPermissions.changeLevel(requestor, updateInfo)) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_OWNERSHIP)) {
            String newOwnerName = updateInfo.func_74779_i("newOwner");
            CompoundNBT result6 = this.setOwner(requestor, newOwnerName);
            if (result6 != null) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_TEAM)) {
            CompoundNBT result7;
            UUID newTeamID = null;
            if (updateInfo.func_74764_b("Team")) {
                newTeamID = updateInfo.func_186857_a("Team");
            }
            if ((result7 = this.setTeam(requestor, newTeamID)) != null) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_BANK_LINK) && (newValue = updateInfo.func_74767_n("IsLinked")) != this.bankAccountLinked && (result = this.toggleBankAccountLink(requestor)) != null) {
            this.markDirty();
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT compound) {
        this.saveOwner(compound);
        this.saveTeam(compound);
        this.saveAllyList(compound);
        this.saveAllyPermissions(compound);
        this.saveCustomName(compound);
        this.saveCreative(compound);
        this.saveBankAccountLink(compound);
        this.saveLogger(compound);
        return compound;
    }

    public CompoundNBT saveOwner(CompoundNBT compound) {
        if (this.owner != null) {
            compound.func_218657_a("Owner", (INBT)this.owner.save());
        }
        if (!this.customOwnerName.isEmpty()) {
            compound.func_74778_a("CustomOwnerName", this.customOwnerName);
        }
        return compound;
    }

    public CompoundNBT saveTeam(CompoundNBT compound) {
        if (this.team != null) {
            compound.func_186854_a("Team", this.team.getID());
        } else {
            compound.func_74757_a("Team", false);
        }
        return compound;
    }

    public CompoundNBT saveAllyList(CompoundNBT compound) {
        PlayerReference.saveList(compound, this.allies, "Allies");
        return compound;
    }

    public CompoundNBT saveAllyPermissions(CompoundNBT compound) {
        this.allyPermissions.save(compound, "AllyPermissions");
        return compound;
    }

    public CompoundNBT saveCustomName(CompoundNBT compound) {
        compound.func_74778_a("CustomName", this.customName);
        return compound;
    }

    public CompoundNBT saveCreative(CompoundNBT compound) {
        compound.func_74757_a("Creative", this.isCreative);
        return compound;
    }

    public CompoundNBT saveBankAccountLink(CompoundNBT compound) {
        compound.func_74757_a("BankLink", this.bankAccountLinked);
        return compound;
    }

    public CompoundNBT saveLogger(CompoundNBT compound) {
        this.logger.write(compound);
        return compound;
    }

    public void loadFromOldUniversalData(CompoundNBT compound) {
        LightmansCurrency.LogInfo("Loading Core Trader Settings from old UniversalData compound.");
        UUID ownerID = null;
        String ownerName = "";
        if (compound.func_74764_b("OwnerID")) {
            ownerID = compound.func_186857_a("OwnerID");
        }
        if (compound.func_150297_b("OwnerName", 8)) {
            ownerName = compound.func_74779_i("OwnerName");
        }
        if (ownerID != null) {
            this.owner = PlayerReference.of(ownerID, ownerName);
        }
        if (compound.func_74764_b("Creative")) {
            this.isCreative = compound.func_74767_n("Creative");
        }
        if (compound.func_150297_b("Allies", 9)) {
            this.allies.clear();
            ListNBT allyList = compound.func_150295_c("Allies", 10);
            for (int i = 0; i < allyList.size(); ++i) {
                CompoundNBT thisAlly = allyList.func_150305_b(i);
                if (!thisAlly.func_150297_b("name", 8)) continue;
                this.addAlly(null, thisAlly.func_74779_i("name"));
            }
        }
        if (compound.func_150297_b("TraderName", 8)) {
            this.customName = compound.func_74779_i("TraderName");
        }
    }

    public void loadFromOldTraderData(CompoundNBT compound) {
        LightmansCurrency.LogInfo("Loading Core Trader Settings from old TileEntity compound.");
        UUID ownerID = null;
        String ownerName = "";
        if (compound.func_74764_b("OwnerID")) {
            ownerID = compound.func_186857_a("OwnerID");
        }
        if (compound.func_150297_b("OwnerName", 8)) {
            ownerName = compound.func_74779_i("OwnerName");
        }
        if (ownerID != null) {
            this.owner = PlayerReference.of(ownerID, ownerName);
        }
        if (compound.func_74764_b("Creative")) {
            this.isCreative = compound.func_74767_n("Creative");
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        if (compound.func_150297_b("Allies", 9)) {
            this.allies.clear();
            ListNBT allyList = compound.func_150295_c("Allies", 10);
            for (int i = 0; i < allyList.size(); ++i) {
                CompoundNBT thisAlly = allyList.func_150305_b(i);
                if (!thisAlly.func_150297_b("name", 8)) continue;
                this.addAlly(null, thisAlly.func_74779_i("name"));
            }
        }
    }

    @Override
    public void load(CompoundNBT compound) {
        if (compound.func_150297_b("Owner", 10)) {
            this.owner = PlayerReference.load(compound.func_74775_l("Owner"));
        }
        if (compound.func_150297_b("CustomOwnerName", 8)) {
            this.customOwnerName = compound.func_74779_i("CustomOwnerName");
        }
        if (compound.func_150297_b("Team", 1)) {
            this.team = null;
        } else if (compound.func_74764_b("Team")) {
            this.team = Team.referenceOf(compound.func_186857_a("Team"));
        }
        if (compound.func_150297_b("Allies", 9)) {
            this.allies = PlayerReference.loadList(compound, "Allies");
        }
        if (compound.func_150297_b("AllyPermissions", 9)) {
            this.allyPermissions = PermissionsList.load(this.trader, UPDATE_ALLY_PERMISSIONS, compound, "AllyPermissions");
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        if (compound.func_74764_b("Creative")) {
            this.isCreative = compound.func_74767_n("Creative");
        }
        if (compound.func_74764_b("BankLink")) {
            this.bankAccountLinked = compound.func_74767_n("BankLink");
        }
        this.logger.read(compound);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<SettingsTab> getSettingsTabs() {
        return Lists.newArrayList((Object[])new SettingsTab[]{MainTab.INSTANCE, AllyTab.INSTANCE, AllyPermissionsTab.INSTANCE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<SettingsTab> getBackEndSettingsTabs() {
        return Lists.newArrayList((Object[])new SettingsTab[]{LoggerTab.INSTANCE, OwnershipTab.INSTANCE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<PermissionOption> getPermissionOptions() {
        ArrayList options = Lists.newArrayList((Object[])new PermissionOption[]{BooleanPermission.of("openStorage"), BooleanPermission.of("changeName"), BooleanPermission.of("editTrades"), BooleanPermission.of("collectCoins"), BooleanPermission.of("storeCoins"), BooleanPermission.of("editTradeRules"), BooleanPermission.of("editSettings"), BooleanPermission.of("addRemoveAllies"), BooleanPermission.of("editPermissions"), BooleanPermission.of("clearLogs"), BooleanPermission.of("breakTrader"), BooleanPermission.of(UPDATE_OWNERSHIP)});
        return options;
    }
}

