/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.settings;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.settings.item.ItemInputTab;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.BooleanPermission;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.settings.directional.DirectionalSettings;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTraderSettings
extends Settings {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "item_trader");
    private static final String UPDATE_INPUT_SIDE = "updateInputSide";
    private static final String UPDATE_OUTPUT_SIDE = "updateOutputSide";
    private static final String UPDATE_INPUT_LIMIT = "updateInputLimit";
    private static final String UPDATE_OUTPUT_LIMIT = "updateOutputLimit";
    DirectionalSettings enabledInputSides = new DirectionalSettings();
    DirectionalSettings enabledOutputSides = new DirectionalSettings();
    boolean limitInputs = true;
    boolean limitOutputs = true;

    public ItemTraderSettings(ITrader trader, Settings.IMarkDirty marker, BiConsumer<ResourceLocation, CompoundNBT> sendToServer) {
        super(trader, marker, sendToServer, TYPE);
    }

    public DirectionalSettings getInputSides() {
        return this.enabledInputSides;
    }

    public DirectionalSettings getOutputSides() {
        return this.enabledOutputSides;
    }

    public boolean limitInputsToSales() {
        return this.limitInputs;
    }

    public boolean limitOutputsToPurchases() {
        return this.limitOutputs;
    }

    public ItemHandlerSettings getHandlerSetting(Direction side) {
        if (side == null) {
            return ItemHandlerSettings.DISABLED;
        }
        if (this.enabledInputSides.get(side)) {
            if (this.enabledOutputSides.get(side)) {
                return ItemHandlerSettings.INPUT_AND_OUTPUT;
            }
            return ItemHandlerSettings.INPUT_ONLY;
        }
        if (this.enabledOutputSides.get(side)) {
            return ItemHandlerSettings.OUTPUT_ONLY;
        }
        return ItemHandlerSettings.DISABLED;
    }

    public CompoundNBT toggleInputSide(PlayerEntity requestor, Direction side) {
        if (!this.trader.hasPermission(requestor, "changeExternalInputs")) {
            ItemTraderSettings.PermissionWarning(requestor, "toggle external input side", "changeExternalInputs");
            return null;
        }
        this.enabledInputSides.set(side, !this.enabledInputSides.get(side));
        boolean newValue = this.enabledInputSides.get(side);
        this.trader.getCoreSettings().logger.LogSettingsChange(requestor, "inputSide." + side.toString(), newValue);
        CompoundNBT updateInfo = ItemTraderSettings.initUpdateInfo(UPDATE_INPUT_SIDE);
        updateInfo.func_74768_a("side", side.func_176745_a());
        updateInfo.func_74757_a("enabled", newValue);
        return updateInfo;
    }

    public CompoundNBT toggleOutputSide(PlayerEntity requestor, Direction side) {
        if (!this.trader.hasPermission(requestor, "changeExternalInputs")) {
            ItemTraderSettings.PermissionWarning(requestor, "toggle external output side", "changeExternalInputs");
            return null;
        }
        this.enabledOutputSides.set(side, !this.enabledOutputSides.get(side));
        boolean newValue = this.enabledOutputSides.get(side);
        this.trader.getCoreSettings().logger.LogSettingsChange(requestor, "outputSide." + side.toString(), newValue);
        CompoundNBT updateInfo = ItemTraderSettings.initUpdateInfo(UPDATE_OUTPUT_SIDE);
        updateInfo.func_74768_a("side", side.func_176745_a());
        updateInfo.func_74757_a("enabled", newValue);
        return updateInfo;
    }

    public CompoundNBT toggleInputLimit(PlayerEntity requestor) {
        if (!this.trader.hasPermission(requestor, "changeExternalInputs")) {
            ItemTraderSettings.PermissionWarning(requestor, "toggle external output side", "changeExternalInputs");
            return null;
        }
        this.limitInputs = !this.limitInputs;
        this.trader.getCoreSettings().logger.LogSettingsChange(requestor, "inputLimit", this.limitInputs);
        CompoundNBT updateInfo = ItemTraderSettings.initUpdateInfo(UPDATE_INPUT_LIMIT);
        updateInfo.func_74757_a("limited", this.limitInputs);
        return updateInfo;
    }

    public CompoundNBT toggleOutputLimit(PlayerEntity requestor) {
        if (!this.trader.hasPermission(requestor, "changeExternalInputs")) {
            ItemTraderSettings.PermissionWarning(requestor, "toggle external output side", "changeExternalInputs");
            return null;
        }
        this.limitOutputs = !this.limitOutputs;
        this.trader.getCoreSettings().logger.LogSettingsChange(requestor, "outputLimit", this.limitOutputs);
        CompoundNBT updateInfo = ItemTraderSettings.initUpdateInfo(UPDATE_OUTPUT_LIMIT);
        updateInfo.func_74757_a("limited", this.limitOutputs);
        return updateInfo;
    }

    @Override
    public void changeSetting(PlayerEntity requestor, CompoundNBT updateInfo) {
        CompoundNBT result;
        boolean newValue;
        if (this.isUpdateType(updateInfo, UPDATE_INPUT_SIDE)) {
            CompoundNBT result2;
            Direction side = Direction.func_82600_a((int)updateInfo.func_74762_e("side"));
            boolean newValue2 = updateInfo.func_74767_n("enabled");
            if (newValue2 != this.enabledInputSides.get(side) && (result2 = this.toggleInputSide(requestor, side)) != null) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_OUTPUT_SIDE)) {
            CompoundNBT result3;
            Direction side = Direction.func_82600_a((int)updateInfo.func_74762_e("side"));
            boolean newValue3 = updateInfo.func_74767_n("enabled");
            if (newValue3 != this.enabledOutputSides.get(side) && (result3 = this.toggleOutputSide(requestor, side)) != null) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_INPUT_LIMIT)) {
            CompoundNBT result4;
            boolean newValue4 = updateInfo.func_74767_n("limited");
            if (newValue4 != this.limitInputs && (result4 = this.toggleInputLimit(requestor)) != null) {
                this.markDirty();
            }
        } else if (this.isUpdateType(updateInfo, UPDATE_OUTPUT_LIMIT) && (newValue = updateInfo.func_74767_n("limited")) != this.limitOutputs && (result = this.toggleOutputLimit(requestor)) != null) {
            this.markDirty();
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT compound) {
        compound.func_218657_a("InputSides", (INBT)this.enabledInputSides.save(new CompoundNBT()));
        compound.func_218657_a("OutputSides", (INBT)this.enabledOutputSides.save(new CompoundNBT()));
        compound.func_74757_a("LimitInputs", this.limitInputs);
        compound.func_74757_a("LimitOutputs", this.limitOutputs);
        return compound;
    }

    @Override
    public void load(CompoundNBT compound) {
        this.enabledInputSides.load(compound.func_74775_l("InputSides"));
        this.enabledOutputSides.load(compound.func_74775_l("OutputSides"));
        this.limitInputs = compound.func_74767_n("LimitInputs");
        this.limitOutputs = compound.func_74767_n("LimitOutputs");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<SettingsTab> getSettingsTabs() {
        return Lists.newArrayList((Object[])new SettingsTab[]{ItemInputTab.INSTANCE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<SettingsTab> getBackEndSettingsTabs() {
        return Lists.newArrayList();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<PermissionOption> getPermissionOptions() {
        return Lists.newArrayList((Object[])new PermissionOption[]{BooleanPermission.of("changeExternalInputs")});
    }

    public static enum ItemHandlerSettings {
        DISABLED,
        INPUT_ONLY,
        OUTPUT_ONLY,
        INPUT_AND_OUTPUT;

    }
}

