/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.settings;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;

public class PlayerReference {
    public final UUID id;
    private String name = "";

    public String lastKnownName() {
        return this.name;
    }

    private PlayerReference(UUID playerID, String name) {
        this.id = playerID;
        this.name = name;
    }

    public void tryUpdateName(PlayerEntity player) {
        if (this.is((Entity)player)) {
            this.name = player.func_146103_bH().getName();
        }
    }

    public boolean is(PlayerReference player) {
        if (player == null) {
            return false;
        }
        return this.is(player.id);
    }

    public boolean is(GameProfile profile) {
        return this.is(profile.getId());
    }

    public boolean is(UUID entityID) {
        if (entityID == null) {
            return false;
        }
        return entityID.equals(this.id);
    }

    public boolean is(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.func_110124_au().equals(this.id);
    }

    public boolean is(String name) {
        return this.name.toLowerCase().contentEquals(name.toLowerCase());
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public PlayerEntity getPlayer() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.func_184103_al().func_177451_a(this.id);
        }
        return null;
    }

    public CompoundNBT save() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_186854_a("id", this.id);
        compound.func_74778_a("name", this.name);
        return compound;
    }

    public JsonObject saveAsJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id.toString());
        json.addProperty("name", this.name);
        return json;
    }

    public static PlayerReference load(CompoundNBT compound) {
        try {
            UUID id = compound.func_186857_a("id");
            String name = compound.func_74779_i("name");
            return new PlayerReference(id, name);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error loading PlayerReference from tag.", e.getMessage());
            return null;
        }
    }

    public static PlayerReference load(JsonElement json) {
        try {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return PlayerReference.of(json.getAsString());
            }
            JsonObject j = json.getAsJsonObject();
            UUID id = UUID.fromString(j.get("id").getAsString());
            String name = j.get("name").getAsString();
            return new PlayerReference(id, name);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error loading PlayerReference from JsonObject", e);
            return null;
        }
    }

    public static void saveList(CompoundNBT compound, List<PlayerReference> playerList, String tag) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < playerList.size(); ++i) {
            CompoundNBT thisCompound = playerList.get(i).save();
            list.add((Object)thisCompound);
        }
        compound.func_218657_a(tag, (INBT)list);
    }

    public static List<PlayerReference> loadList(CompoundNBT compound, String tag) {
        ArrayList playerList = Lists.newArrayList();
        ListNBT list = compound.func_150295_c(tag, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT thisCompound = list.func_150305_b(i);
            PlayerReference player = PlayerReference.load(thisCompound);
            if (player == null) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public static PlayerReference of(UUID playerID, String name) {
        if (playerID == null) {
            return null;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return PlayerReference.of(server.func_152358_ax().func_152652_a(playerID));
        }
        return new PlayerReference(playerID, name);
    }

    public static PlayerReference of(GameProfile profile) {
        if (profile == null) {
            return null;
        }
        return new PlayerReference(profile.getId(), profile.getName());
    }

    public static PlayerReference of(Entity entity) {
        if (entity instanceof PlayerEntity) {
            return PlayerReference.of((PlayerEntity)entity);
        }
        return null;
    }

    public static PlayerReference of(PlayerEntity player) {
        return PlayerReference.of(player.func_146103_bH());
    }

    public static PlayerReference of(String playerName) {
        if (StringUtils.isBlank((CharSequence)playerName)) {
            return null;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return PlayerReference.of(server.func_152358_ax().func_152655_a(playerName));
        }
        return null;
    }

    public static boolean listContains(List<PlayerReference> list, UUID id) {
        for (PlayerReference player : list) {
            if (!player.is(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean listContains(List<PlayerReference> list, String name) {
        for (PlayerReference player : list) {
            if (!player.is(name)) continue;
            return true;
        }
        return false;
    }

    public static void removeFromList(List<PlayerReference> list, UUID id) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).is(id)) continue;
            list.remove(i);
            return;
        }
    }

    public static void removeFromList(List<PlayerReference> list, String name) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).is(name)) continue;
            list.remove(i);
            return;
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

