/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.settings;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.PermissionOption;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Settings {
    private final IMarkDirty dirtyMarker;
    private final BiConsumer<ResourceLocation, CompoundNBT> sendToServer;
    private final ResourceLocation type;
    protected final ITrader trader;

    public final ResourceLocation getType() {
        return this.type;
    }

    protected Settings(ITrader trader, IMarkDirty dirtyMarker, BiConsumer<ResourceLocation, CompoundNBT> sendToServer, ResourceLocation type) {
        this.dirtyMarker = dirtyMarker;
        this.sendToServer = sendToServer;
        this.type = type;
        this.trader = trader;
    }

    public final void markDirty() {
        this.dirtyMarker.markDirty();
    }

    public final void sendToServer(CompoundNBT updateInfo) {
        if (updateInfo != null) {
            this.sendToServer.accept(this.type, updateInfo);
        }
    }

    public abstract CompoundNBT save(CompoundNBT var1);

    public abstract void load(CompoundNBT var1);

    public abstract void changeSetting(PlayerEntity var1, CompoundNBT var2);

    public static final CompoundNBT initUpdateInfo(String updateType) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("UpdateType", updateType);
        return compound;
    }

    protected final boolean isUpdateType(CompoundNBT updateInfo, String updateType) {
        return Settings.checkUpdateType(updateInfo, updateType);
    }

    public static final boolean checkUpdateType(CompoundNBT updateInfo, String updateType) {
        if (updateInfo.func_150297_b("UpdateType", 8)) {
            return updateInfo.func_74779_i("UpdateType").contentEquals(updateType);
        }
        return false;
    }

    public static final void PermissionWarning(PlayerEntity player, String action, String permission) {
        Settings.PermissionWarning(player, action, permission, 0, 1);
    }

    public static final void PermissionWarning(PlayerEntity player, String action, String permission, int hasLevel, int requiredLevel) {
        LightmansCurrency.LogWarning(player.func_200200_C_().getString() + " attempted to " + action + " without the appropriate permission level.\nHas " + permission + " level " + hasLevel + ". Level " + requiredLevel + " required.");
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<SettingsTab> getSettingsTabs();

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<SettingsTab> getBackEndSettingsTabs();

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<PermissionOption> getPermissionOptions();

    public static interface IMarkDirty {
        public void markDirty();
    }
}

