/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.settings.directional;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;

public class DirectionalSettings {
    private final ImmutableList<Direction> ignoreSides;
    private final Map<Direction, Boolean> sideValues = Maps.newHashMap();

    public DirectionalSettings() {
        this((ImmutableList<Direction>)ImmutableList.of());
    }

    public DirectionalSettings(ImmutableList<Direction> ignoreSides) {
        this.ignoreSides = ignoreSides;
    }

    public boolean allows(Direction side) {
        return !this.ignoreSides.contains((Object)side);
    }

    public boolean get(Direction side) {
        if (this.ignoreSides.contains((Object)side)) {
            return false;
        }
        return this.sideValues.getOrDefault(side, false);
    }

    public void set(Direction side, boolean value) {
        if (this.ignoreSides.contains((Object)side)) {
            return;
        }
        this.sideValues.put(side, value);
    }

    public CompoundNBT save(CompoundNBT compound) {
        for (Direction side : Direction.values()) {
            if (this.ignoreSides.contains((Object)side)) continue;
            compound.func_74757_a(side.toString(), this.get(side));
        }
        return compound;
    }

    public void load(CompoundNBT compound) {
        this.sideValues.clear();
        for (Direction side : Direction.values()) {
            if (this.ignoreSides.contains((Object)side) || !compound.func_74764_b(side.toString())) continue;
            this.set(side, compound.func_74767_n(side.toString()));
        }
    }
}

