/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class ItemTradeData
extends TradeData {
    public static final int MAX_CUSTOMNAME_LENGTH = 30;
    ItemTradeRestriction restriction = ItemTradeRestriction.NONE;
    ItemStack sellItem = ItemStack.field_190927_a;
    ItemStack barterItem = ItemStack.field_190927_a;
    ItemTradeType tradeType = ItemTradeType.SALE;
    String customName = "";

    public static int MaxTradeTypeStringLength() {
        int length = 0;
        for (ItemTradeType value : ItemTradeType.values()) {
            int thisLength = value.name().length();
            if (thisLength <= length) continue;
            length = thisLength;
        }
        return length;
    }

    public ItemStack getSellItem() {
        return this.restriction.modifySellItem(this.sellItem.func_77946_l(), this);
    }

    public ItemStack getBarterItem() {
        return this.barterItem.func_77946_l();
    }

    public void setSellItem(ItemStack itemStack) {
        if (this.restriction.allowSellItem(itemStack) || itemStack.func_190926_b()) {
            this.sellItem = this.restriction.filterSellItem(itemStack).func_77946_l();
        }
    }

    public void setBarterItem(ItemStack itemStack) {
        this.barterItem = itemStack.func_77946_l();
    }

    public boolean hasCustomName() {
        return !this.customName.isEmpty();
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        switch (this.tradeType) {
            case SALE: {
                return TradeData.TradeDirection.SALE;
            }
            case PURCHASE: {
                return TradeData.TradeDirection.PURCHASE;
            }
        }
        return TradeData.TradeDirection.NONE;
    }

    public ItemTradeType getTradeType() {
        return this.tradeType;
    }

    public boolean isSale() {
        return this.tradeType == ItemTradeType.SALE;
    }

    public boolean isPurchase() {
        return this.tradeType == ItemTradeType.PURCHASE;
    }

    public boolean isBarter() {
        return this.tradeType == ItemTradeType.BARTER;
    }

    public void setTradeType(ItemTradeType tradeDirection) {
        this.tradeType = tradeDirection;
    }

    public int getSlotCount() {
        return this.tradeType == ItemTradeType.BARTER ? 2 : 1;
    }

    public ItemTradeRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(ItemTradeRestriction restriction) {
        this.restriction = restriction;
    }

    @Override
    public boolean isValid() {
        if (this.tradeType == ItemTradeType.BARTER) {
            return !this.sellItem.func_190926_b() && !this.barterItem.func_190926_b();
        }
        return super.isValid() && !this.sellItem.func_190926_b();
    }

    public boolean hasStock(IItemTrader trader) {
        if (this.sellItem.func_190926_b()) {
            return false;
        }
        return this.stockCount(trader) > 0;
    }

    public boolean hasSpace(IItemTrader trader) {
        switch (this.tradeType) {
            case PURCHASE: {
                return InventoryUtil.CanPutItemStack(trader.getStorage(), this.getSellItem());
            }
            case BARTER: {
                return InventoryUtil.CanPutItemStack(trader.getStorage(), this.getBarterItem());
            }
        }
        return true;
    }

    public int stockCount(IItemTrader trader) {
        if (this.sellItem.func_190926_b()) {
            return 0;
        }
        if (this.tradeType == ItemTradeType.PURCHASE) {
            if (this.cost.isFree()) {
                return 1;
            }
            if (this.cost.getRawValue() == 0L) {
                return 0;
            }
            long coinValue = trader.getStoredMoney().getRawValue();
            long price = this.cost.getRawValue();
            return (int)(coinValue / price);
        }
        if (this.tradeType == ItemTradeType.SALE || this.tradeType == ItemTradeType.BARTER) {
            return this.restriction.getSaleStock(this.sellItem, trader.getStorage());
        }
        return 0;
    }

    public void RemoveItemsFromStorage(IInventory storage) {
        this.restriction.removeItemsFromStorage(this.sellItem, storage);
    }

    @Override
    public CompoundNBT getAsNBT() {
        CompoundNBT tradeNBT = super.getAsNBT();
        CompoundNBT sellItemCompound = new CompoundNBT();
        this.sellItem.func_77955_b(sellItemCompound);
        tradeNBT.func_218657_a("SellItem", (INBT)sellItemCompound);
        CompoundNBT barterItemCompound = new CompoundNBT();
        this.barterItem.func_77955_b(barterItemCompound);
        tradeNBT.func_218657_a("BarterItem", (INBT)barterItemCompound);
        tradeNBT.func_74778_a("TradeDirection", this.tradeType.name());
        tradeNBT.func_74778_a("Restrictions", this.restriction.getRegistryName().toString());
        tradeNBT.func_74778_a("CustomName", this.customName);
        return tradeNBT;
    }

    public static CompoundNBT saveAllData(CompoundNBT nbt, List<ItemTradeData> data) {
        return ItemTradeData.saveAllData(nbt, data, "Trades");
    }

    public static CompoundNBT saveAllData(CompoundNBT nbt, List<ItemTradeData> data, String key) {
        ListNBT listNBT = new ListNBT();
        for (int i = 0; i < data.size(); ++i) {
            listNBT.add((Object)data.get(i).getAsNBT());
        }
        if (listNBT.size() > 0) {
            nbt.func_218657_a(key, (INBT)listNBT);
        }
        return nbt;
    }

    public static ItemTradeData loadData(CompoundNBT nbt) {
        ItemTradeData trade = new ItemTradeData();
        trade.loadFromNBT(nbt);
        return trade;
    }

    public static List<ItemTradeData> loadAllData(CompoundNBT nbt, int arraySize) {
        return ItemTradeData.loadAllData("Trades", nbt, arraySize);
    }

    public static List<ItemTradeData> loadAllData(String key, CompoundNBT nbt, int arraySize) {
        ListNBT listNBT = nbt.func_150295_c(key, 10);
        List<ItemTradeData> data = ItemTradeData.listOfSize(arraySize);
        for (int i = 0; i < listNBT.size() && i < arraySize; ++i) {
            data.get(i).loadFromNBT(listNBT.func_150305_b(i));
        }
        return data;
    }

    @Override
    public void loadFromNBT(CompoundNBT nbt) {
        super.loadFromNBT(nbt);
        this.sellItem = nbt.func_150297_b("SellItem", 10) ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("SellItem")) : ItemStack.func_199557_a((CompoundNBT)nbt);
        this.barterItem = nbt.func_150297_b("BarterItem", 10) ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("BarterItem")) : ItemStack.field_190927_a;
        this.tradeType = nbt.func_150297_b("TradeDirection", 8) ? ItemTradeData.loadTradeType(nbt.func_74779_i("TradeDirection")) : ItemTradeType.SALE;
        this.restriction = nbt.func_74764_b("Restrictions") ? ItemTradeRestriction.get(nbt.func_74779_i("Restrictions")) : ItemTradeRestriction.NONE;
        this.customName = nbt.func_74764_b("CustomName") ? nbt.func_74779_i("CustomName") : "";
    }

    public static ItemTradeType loadTradeType(String name) {
        ItemTradeType value = ItemTradeType.SALE;
        try {
            value = ItemTradeType.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            LightmansCurrency.LogError("Could not load '" + name + "' as a TradeDirection.");
        }
        return value;
    }

    public static List<ItemTradeData> listOfSize(int tradeCount) {
        ArrayList data = Lists.newArrayList();
        while (data.size() < tradeCount) {
            data.add(new ItemTradeData());
        }
        return data;
    }

    @Override
    public void markRulesDirty() {
    }

    @Override
    public TradeData.TradeComparisonResult compare(TradeData otherTrade) {
        TradeData.TradeComparisonResult result = new TradeData.TradeComparisonResult();
        if (otherTrade instanceof ItemTradeData) {
            ItemTradeData otherItemTrade = (ItemTradeData)otherTrade;
            result.setCompatible();
            result.addProductResult(TradeData.TradeComparisonResult.ProductComparisonResult.CompareItem(this.sellItem, otherItemTrade.sellItem));
            if (this.isBarter()) {
                result.addProductResult(TradeData.TradeComparisonResult.ProductComparisonResult.CompareItem(this.barterItem, otherItemTrade.barterItem));
            }
            result.setPriceResult(this.getCost().getRawValue() - otherItemTrade.getCost().getRawValue());
            result.setTypeResult(this.tradeType == otherItemTrade.tradeType);
        }
        return result;
    }

    @Override
    public boolean AcceptableDifferences(TradeData.TradeComparisonResult result) {
        if (!result.TypeMatches() || !result.isCompatible()) {
            return false;
        }
        if (result.getProductResultCount() < 1) {
            return false;
        }
        TradeData.TradeComparisonResult.ProductComparisonResult sellResult = result.getProductResult(0);
        if (sellResult.SameProductType() && sellResult.SameProductNBT()) {
            if (this.isSale() || this.isBarter() ? sellResult.ProductQuantityDifference() < 0 : this.isPurchase() && sellResult.ProductQuantityDifference() > 0) {
                return false;
            }
        } else {
            return false;
        }
        if (this.isBarter()) {
            if (result.getProductResultCount() < 2) {
                return false;
            }
            TradeData.TradeComparisonResult.ProductComparisonResult barterResult = result.getProductResult(1);
            if (barterResult.SameProductType() && barterResult.SameProductNBT()) {
                if (barterResult.ProductQuantityDifference() > 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.isSale() && result.isPriceExpensive()) {
            return false;
        }
        return !this.isPurchase() || !result.isPriceCheaper();
    }

    public static enum ItemTradeType {
        SALE,
        PURCHASE,
        BARTER;

    }
}

