/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata;

import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;

public abstract class TradeData
implements ITradeRuleHandler {
    public static final String DEFAULT_KEY = "Trades";
    protected CoinValue cost = new CoinValue(new CoinValue.CoinValuePair[0]);
    List<TradeRule> rules = new ArrayList<TradeRule>();

    public abstract TradeDirection getTradeDirection();

    public final boolean validCost() {
        return this.cost.isFree() || this.cost.getRawValue() > 0L;
    }

    public boolean isValid() {
        return this.validCost();
    }

    @Deprecated
    public boolean isFree() {
        return this.cost.isFree();
    }

    @Deprecated
    public void setFree(boolean free) {
        this.cost.setFree(free);
    }

    public CoinValue getCost() {
        return this.cost;
    }

    public void setCost(CoinValue value) {
        this.cost = value;
    }

    public CompoundNBT getAsNBT() {
        CompoundNBT tradeNBT = new CompoundNBT();
        this.cost.writeToNBT(tradeNBT, "Price");
        TradeRule.writeRules(tradeNBT, this.rules);
        return tradeNBT;
    }

    protected void loadFromNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("Price", 3)) {
            this.cost.readFromOldValue(nbt.func_74762_e("Price"));
        } else if (nbt.func_74764_b("Price")) {
            this.cost.readFromNBT(nbt, "Price");
        }
        if (nbt.func_74764_b("IsFree")) {
            this.cost.setFree(nbt.func_74767_n("IsFree"));
        }
        this.rules.clear();
        this.rules = TradeRule.readRules(nbt);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        this.rules.forEach(rule -> rule.beforeTrade(event));
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        this.rules.forEach(rule -> rule.tradeCost(event));
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.rules.forEach(rule -> rule.afterTrade(event));
    }

    public void addRule(TradeRule newRule) {
        if (newRule == null) {
            return;
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            if (newRule.type != this.rules.get((int)i).type) continue;
            return;
        }
        this.rules.add(newRule);
    }

    @Override
    public List<TradeRule> getRules() {
        return this.rules;
    }

    public void setRules(List<TradeRule> rules) {
        this.rules = rules;
    }

    public void removeRule(TradeRule rule) {
        if (this.rules.contains(rule)) {
            this.rules.remove(rule);
        }
    }

    @Override
    public void clearRules() {
        this.rules.clear();
    }

    @Override
    public void markRulesDirty() {
    }

    public abstract TradeComparisonResult compare(TradeData var1);

    public abstract boolean AcceptableDifferences(TradeComparisonResult var1);

    public static class TradeComparisonResult {
        private boolean compatible = false;
        private List<ProductComparisonResult> tradeProductResults = new ArrayList<ProductComparisonResult>();
        private long priceChangeDirection = 0L;
        private boolean tradeTypeMatches = true;

        public boolean isCompatible() {
            return this.compatible;
        }

        public boolean ProductMatches() {
            for (ProductComparisonResult result : this.tradeProductResults) {
                if (result.Identical()) continue;
                return false;
            }
            return true;
        }

        public ProductComparisonResult getProductResult(int index) {
            if (index < 0 || index >= this.tradeProductResults.size()) {
                return null;
            }
            return this.tradeProductResults.get(index);
        }

        public int getProductResultCount() {
            return this.tradeProductResults.size();
        }

        public boolean PriceMatches() {
            return this.priceChangeDirection == 0L;
        }

        public boolean isPriceCheaper() {
            return this.priceChangeDirection < 0L;
        }

        public boolean isPriceExpensive() {
            return this.priceChangeDirection > 0L;
        }

        public boolean TypeMatches() {
            return this.tradeTypeMatches;
        }

        public boolean Identical() {
            return this.compatible && this.ProductMatches() && this.PriceMatches() && this.TypeMatches();
        }

        public void addProductResult(ProductComparisonResult result) {
            this.tradeProductResults.add(result);
        }

        public void addProductResult(boolean sameProduct, boolean sameNBT, int quantityDifference) {
            this.tradeProductResults.add(new ProductComparisonResult(sameProduct, sameNBT, quantityDifference));
        }

        public void setPriceResult(long priceChangeDirection) {
            this.priceChangeDirection = priceChangeDirection;
        }

        public void setTypeResult(boolean typeMatches) {
            this.tradeTypeMatches = typeMatches;
        }

        public void setCompatible() {
            this.compatible = true;
        }

        public static class ProductComparisonResult {
            private final boolean sameProduct;
            private final boolean sameNBT;
            private final int quantityDifference;

            public boolean Identical() {
                return this.SameProductType() && this.SameProductNBT() && this.SameProductQuantity();
            }

            public boolean SameProductType() {
                return this.sameProduct;
            }

            public boolean SameProductNBT() {
                return this.sameNBT;
            }

            public boolean SameProductQuantity() {
                return this.quantityDifference == 0;
            }

            public int ProductQuantityDifference() {
                return this.quantityDifference;
            }

            private ProductComparisonResult(boolean sameProduct, boolean sameNBT, int quantityDifference) {
                this.sameProduct = sameProduct;
                this.sameNBT = sameNBT;
                this.quantityDifference = quantityDifference;
            }

            public static ProductComparisonResult CompareItem(ItemStack original, ItemStack query) {
                boolean isItemEqual;
                boolean bl = isItemEqual = original.func_77973_b() == query.func_77973_b();
                boolean isTagEqual = original.func_77978_p() != null ? original.func_77978_p().equals((Object)query.func_77978_p()) : query.func_77978_p() == null;
                int quantityDifference = original.func_190916_E() - query.func_190916_E();
                return new ProductComparisonResult(isItemEqual, isTagEqual, quantityDifference);
            }

            public static ProductComparisonResult CompareFluid(FluidStack original, FluidStack query) {
                boolean isFluidEqual;
                boolean bl = isFluidEqual = original.getFluid() == query.getFluid();
                boolean isTagEqual = original.getTag() != null ? original.getTag().equals((Object)query.getTag()) : query.getTag() == null;
                int quantityDifference = original.getAmount() - query.getAmount();
                return new ProductComparisonResult(isFluidEqual, isTagEqual, quantityDifference);
            }

            public static ProductComparisonResult CompareEnergy(int original, int query) {
                return new ProductComparisonResult(true, true, original - query);
            }
        }
    }

    public static enum TradeDirection {
        SALE,
        PURCHASE,
        NONE;

    }
}

