/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata;

import com.google.common.base.Supplier;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TradeRule {
    public static final String DEFAULT_TAG = "TradeRules";
    public final ResourceLocation type;
    static final Map<String, Supplier<TradeRule>> registeredDeserializers = new HashMap<String, Supplier<TradeRule>>();

    public final ITextComponent getName() {
        return new TranslationTextComponent("traderule." + this.type.func_110624_b() + "." + this.type.func_110623_a());
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
    }

    public void tradeCost(TradeEvent.TradeCostEvent event) {
    }

    public void afterTrade(TradeEvent.PostTradeEvent event) {
    }

    protected TradeRule(ResourceLocation type) {
        this.type = type;
    }

    public CompoundNBT getNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("type", this.type.toString());
        return this.write(compound);
    }

    protected abstract CompoundNBT write(CompoundNBT var1);

    public abstract void readNBT(CompoundNBT var1);

    public abstract JsonObject saveToJson(JsonObject var1);

    public abstract void loadFromJson(JsonObject var1);

    public abstract CompoundNBT savePersistentData();

    public abstract void loadPersistentData(CompoundNBT var1);

    public abstract IconData getButtonIcon();

    public abstract void handleUpdateMessage(CompoundNBT var1);

    public static CompoundNBT writeRules(CompoundNBT compound, List<TradeRule> rules) {
        return TradeRule.writeRules(compound, rules, DEFAULT_TAG);
    }

    public static CompoundNBT writeRules(CompoundNBT compound, List<TradeRule> rules, String tag) {
        ListNBT ruleData = new ListNBT();
        for (int i = 0; i < rules.size(); ++i) {
            CompoundNBT thisRuleData = rules.get(i).getNBT();
            if (thisRuleData == null) continue;
            ruleData.add((Object)thisRuleData);
        }
        compound.func_218657_a(tag, (INBT)ruleData);
        return compound;
    }

    public static boolean writePersistentData(CompoundNBT compound, List<TradeRule> rules, String tag) {
        ListNBT ruleData = new ListNBT();
        for (int i = 0; i < rules.size(); ++i) {
            CompoundNBT thisRuleData = rules.get(i).savePersistentData();
            if (thisRuleData == null) continue;
            thisRuleData.func_74778_a("type", rules.get((int)i).type.toString());
            ruleData.add((Object)thisRuleData);
        }
        if (ruleData.size() <= 0) {
            return false;
        }
        compound.func_218657_a(tag, (INBT)ruleData);
        return true;
    }

    public static JsonArray saveRulesToJson(List<TradeRule> rules) {
        JsonArray ruleData = new JsonArray();
        for (int i = 0; i < rules.size(); ++i) {
            JsonObject thisRuleData = rules.get(i).saveToJson(new JsonObject());
            if (thisRuleData == null) continue;
            thisRuleData.addProperty("type", rules.get((int)i).type.toString());
            ruleData.add((JsonElement)thisRuleData);
        }
        return ruleData;
    }

    public static List<TradeRule> readRules(CompoundNBT compound) {
        return TradeRule.readRules(compound, DEFAULT_TAG);
    }

    public static List<TradeRule> readRules(CompoundNBT compound, String tag) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        if (compound.func_150297_b(tag, 9)) {
            ListNBT ruleData = compound.func_150295_c(tag, 10);
            for (int i = 0; i < ruleData.size(); ++i) {
                CompoundNBT thisRuleData = ruleData.func_150305_b(i);
                TradeRule thisRule = TradeRule.Deserialize(thisRuleData);
                if (thisRule == null) continue;
                rules.add(thisRule);
            }
        }
        return rules;
    }

    public static void readPersistentData(CompoundNBT compound, List<TradeRule> tradeRules, String tag) {
        if (compound.func_150297_b(tag, 9)) {
            ListNBT ruleData = compound.func_150295_c(tag, 10);
            for (int i = 0; i < ruleData.size(); ++i) {
                CompoundNBT thisRuleData = ruleData.func_150305_b(i);
                boolean query = true;
                for (int r = 0; query && r < tradeRules.size(); ++r) {
                    if (!tradeRules.get((int)r).type.toString().contentEquals(thisRuleData.func_74779_i("type"))) continue;
                    tradeRules.get(r).loadPersistentData(thisRuleData);
                }
            }
        }
    }

    public static List<TradeRule> Parse(JsonArray tradeRuleData) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        for (int i = 0; i < tradeRuleData.size(); ++i) {
            try {
                JsonObject thisRuleData = tradeRuleData.get(i).getAsJsonObject();
                TradeRule thisRule = TradeRule.Deserialize(thisRuleData);
                rules.add(thisRule);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading Trade Rule at index " + i + ".", t);
            }
        }
        return rules;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract GUIHandler createHandler(TradeRuleScreen var1, Supplier<TradeRule> var2);

    public static void RegisterDeserializer(ResourceLocation type, Supplier<TradeRule> deserializer) {
        TradeRule.RegisterDeserializer(type, deserializer, false);
    }

    public static void RegisterDeserializer(ResourceLocation type, Supplier<TradeRule> deserializer, boolean suppressDebugMessage) {
        TradeRule.RegisterDeserializer(type.toString(), deserializer, suppressDebugMessage);
    }

    public static void RegisterDeserializer(String type, Supplier<TradeRule> deserializer, boolean suppressDebugMessage) {
        if (registeredDeserializers.containsKey(type)) {
            LightmansCurrency.LogWarning("A trade rule deserializer of type '" + type + "' has already been registered.");
            return;
        }
        registeredDeserializers.put(type, deserializer);
        if (!suppressDebugMessage) {
            LightmansCurrency.LogInfo("Registered trade rule deserializer of type " + type);
        }
    }

    public static TradeRule CreateRule(ResourceLocation ruleType) {
        String thisType = ruleType.toString();
        AtomicReference data = new AtomicReference();
        registeredDeserializers.forEach((type, deserializer) -> {
            if (thisType.equals(type)) {
                TradeRule rule = (TradeRule)deserializer.get();
                data.set(rule);
            }
        });
        if (data.get() != null) {
            return (TradeRule)data.get();
        }
        LightmansCurrency.LogError("Could not find a deserializer of type '" + ruleType + "'. Unable to load the Trade Rule.");
        return null;
    }

    public static TradeRule Deserialize(CompoundNBT compound) {
        String thisType = compound.func_74779_i("type");
        AtomicReference data = new AtomicReference();
        registeredDeserializers.forEach((type, deserializer) -> {
            if (thisType.equals(type)) {
                TradeRule rule = (TradeRule)deserializer.get();
                rule.readNBT(compound);
                data.set(rule);
            }
        });
        if (data.get() != null) {
            return (TradeRule)data.get();
        }
        LightmansCurrency.LogError("Could not find a deserializer of type '" + thisType + "'. Unable to load the Trade Rule.");
        return null;
    }

    public static TradeRule Deserialize(JsonObject json) throws Exception {
        String thisType = json.get("type").getAsString();
        AtomicReference data = new AtomicReference();
        registeredDeserializers.forEach((type, deserializer) -> {
            if (thisType.equals(type)) {
                TradeRule rule = (TradeRule)deserializer.get();
                rule.loadFromJson(json);
                data.set(rule);
            }
        });
        if (data.get() == null) {
            throw new Exception("Could not find a deserializer of type '" + thisType + "'.");
        }
        return (TradeRule)data.get();
    }

    public static TradeRule getRule(ResourceLocation type, List<TradeRule> rules) {
        for (TradeRule rule : rules) {
            if (!rule.type.equals((Object)type)) continue;
            return rule;
        }
        return null;
    }

    public static final CompoundNBT CreateRuleMessage() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("Create", true);
        return tag;
    }

    public static final CompoundNBT RemoveRuleMessage() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("Remove", true);
        return tag;
    }

    public static final boolean isCreateMessage(CompoundNBT tag) {
        return tag.func_74764_b("Create") && tag.func_74767_n("Create");
    }

    public static final boolean isRemoveMessage(CompoundNBT tag) {
        return tag.func_74764_b("Remove") && tag.func_74767_n("Remove");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class GUIHandler {
        protected final TradeRuleScreen screen;
        private final Supplier<TradeRule> rule;

        protected final TradeRule getRuleRaw() {
            return (TradeRule)this.rule.get();
        }

        protected GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            this.screen = screen;
            this.rule = rule;
        }

        public abstract void initTab();

        public abstract void renderTab(MatrixStack var1, int var2, int var3, float var4);

        public abstract void onTabClose();

        public void onScreenTick() {
        }

        public <T extends Button> T addButton(T button) {
            return this.screen.addCustomButton(button);
        }

        public <T extends IGuiEventListener> T addListener(T listener) {
            return this.screen.addCustomListener(listener);
        }
    }
}

