/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EquipmentRestriction
extends ItemTradeRestriction {
    private final EquipmentSlotType equipmentType;

    public EquipmentRestriction(EquipmentSlotType type) {
        this(type, "");
    }

    public EquipmentRestriction(EquipmentSlotType type, String classicType) {
        super(classicType);
        this.equipmentType = type;
    }

    public EquipmentSlotType getEquipmentSlot() {
        return this.equipmentType;
    }

    @Override
    public boolean allowSellItem(ItemStack itemStack) {
        return itemStack.canEquip(this.equipmentType, null);
    }

    @Override
    public boolean allowItemSelectItem(ItemStack itemStack) {
        return itemStack.canEquip(this.equipmentType, null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        switch (this.equipmentType) {
            case HEAD: {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226616_d_);
            }
            case CHEST: {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226617_e_);
            }
            case LEGS: {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226618_f_);
            }
            case FEET: {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226619_g_);
            }
        }
        return null;
    }
}

