/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.containers.slots.TicketSlot;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TicketKioskRestriction
extends ItemTradeRestriction {
    public TicketKioskRestriction() {
    }

    public TicketKioskRestriction(String classicType) {
        super(classicType);
    }

    @Override
    public ItemStack modifySellItem(ItemStack sellItem, ItemTradeData trade) {
        if (sellItem.func_77973_b() instanceof TicketItem && trade.hasCustomName()) {
            sellItem.func_200302_a((ITextComponent)new StringTextComponent(trade.getCustomName()));
        }
        return sellItem;
    }

    @Override
    public boolean allowSellItem(ItemStack itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return true;
        }
        return itemStack.func_77973_b().getTags().contains(TicketItem.TICKET_MATERIAL_TAG) && itemStack.func_77973_b() != ModItems.TICKET;
    }

    @Override
    public ItemStack filterSellItem(ItemStack itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return TicketItem.CreateTicket(TicketItem.GetTicketID(itemStack), 1);
        }
        if (itemStack.func_77973_b().getTags().contains(TicketItem.TICKET_MATERIAL_TAG) && itemStack.func_77973_b() != ModItems.TICKET) {
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean allowItemSelectItem(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return item.getTags().contains(TicketItem.TICKET_MATERIAL_TAG) && item != ModItems.TICKET && item != ModItems.TICKET_MASTER;
    }

    @Override
    public int getSaleStock(ItemStack sellItem, IInventory traderStorage) {
        if (sellItem.func_77973_b() == ModItems.TICKET) {
            return InventoryUtil.GetItemTagCount(traderStorage, TicketItem.TICKET_MATERIAL_TAG, ModItems.TICKET_MASTER) / sellItem.func_190916_E();
        }
        return super.getSaleStock(sellItem, traderStorage);
    }

    @Override
    public void removeItemsFromStorage(ItemStack sellItem, IInventory traderStorage) {
        if (sellItem.func_77973_b() == ModItems.TICKET) {
            if (!InventoryUtil.RemoveItemCount(traderStorage, sellItem)) {
                InventoryUtil.RemoveItemTagCount(traderStorage, TicketItem.TICKET_MATERIAL_TAG, sellItem.func_190916_E(), ModItems.TICKET_MASTER);
            }
        } else {
            super.removeItemsFromStorage(sellItem, traderStorage);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)TicketSlot.EMPTY_TICKET_SLOT);
    }
}

