/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

public interface ITradeRuleHandler {
    public void beforeTrade(TradeEvent.PreTradeEvent var1);

    public void tradeCost(TradeEvent.TradeCostEvent var1);

    public void afterTrade(TradeEvent.PostTradeEvent var1);

    public List<TradeRule> getRules();

    public void clearRules();

    default public void updateRule(ResourceLocation type, CompoundNBT updateInfo) {
        TradeRule rule = TradeRule.getRule(type, this.getRules());
        if (rule == null && TradeRule.isCreateMessage(updateInfo)) {
            TradeRule newRule = TradeRule.CreateRule(type);
            if (newRule == null) {
                return;
            }
            this.getRules().add(newRule);
        }
        if (rule != null) {
            if (TradeRule.isRemoveMessage(updateInfo)) {
                this.getRules().remove(rule);
            } else {
                rule.handleUpdateMessage(updateInfo);
            }
        }
    }

    public void markRulesDirty();

    public static <T extends ITradeRuleHandler> void savePersistentRuleData(CompoundNBT data, @Nullable ITradeRuleHandler trader, @Nullable List<T> trades) {
        if (trader != null && trader.getRules().size() > 0) {
            TradeRule.writePersistentData(data, trader.getRules(), "TraderRuleData");
        }
        if (trades != null) {
            ListNBT tradeData = new ListNBT();
            for (int i = 0; i < trades.size(); ++i) {
                CompoundNBT ruleData;
                ITradeRuleHandler trade = (ITradeRuleHandler)trades.get(i);
                if (trade.getRules().size() <= 0 || !TradeRule.writePersistentData(ruleData = new CompoundNBT(), trade.getRules(), "Data")) continue;
                ruleData.func_74768_a("index", i);
                tradeData.add((Object)ruleData);
            }
            if (tradeData.size() > 0) {
                data.func_218657_a("TradeRuleData", (INBT)tradeData);
            }
        }
    }

    public static void readPersistentRuleData(CompoundNBT data, @Nullable ITradeRuleHandler trader, @Nullable List<? extends ITradeRuleHandler> trades) {
        if (trader != null) {
            TradeRule.readPersistentData(data, trader.getRules(), "TraderRuleData");
        }
        if (trades != null && data.func_150297_b("TradeRuleData", 9)) {
            ListNBT tradeData = data.func_150295_c("TradeRuleData", 10);
            for (int i = 0; i < tradeData.size(); ++i) {
                CompoundNBT ruleData = tradeData.func_150305_b(i);
                int index = ruleData.func_74762_e("index");
                if (index < 0 || index >= trades.size()) continue;
                TradeRule.readPersistentData(ruleData, trades.get(index).getRules(), "Data");
            }
        }
    }

    public static interface ITradeRuleMessageHandler {
        public void receiveTradeRuleMessage(PlayerEntity var1, int var2, ResourceLocation var3, CompoundNBT var4);
    }
}

