/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerBlacklist
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "blacklist");
    List<PlayerReference> bannedPlayers = new ArrayList<PlayerReference>();

    public PlayerBlacklist() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.isBlacklisted(event.getPlayerReference())) {
            event.denyTrade((ITextComponent)new TranslationTextComponent("traderule.lightmanscurrency.blacklist.denial"));
        }
    }

    public boolean isBlacklisted(PlayerReference player) {
        for (int i = 0; i < this.bannedPlayers.size(); ++i) {
            if (!this.bannedPlayers.get(i).is(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        ListNBT playerNameList = new ListNBT();
        for (int i = 0; i < this.bannedPlayers.size(); ++i) {
            playerNameList.add((Object)this.bannedPlayers.get(i).save());
        }
        compound.func_218657_a("BannedPlayers", (INBT)playerNameList);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        JsonArray blacklist = new JsonArray();
        for (int i = 0; i < this.bannedPlayers.size(); ++i) {
            blacklist.add((JsonElement)this.bannedPlayers.get(i).saveAsJson());
        }
        json.add("BannedPlayers", (JsonElement)blacklist);
        return json;
    }

    @Override
    public void readNBT(CompoundNBT compound) {
        int i;
        if (compound.func_150297_b("BannedPlayers", 9)) {
            this.bannedPlayers.clear();
            ListNBT playerList = compound.func_150295_c("BannedPlayers", 10);
            for (i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.func_150305_b(i));
                if (reference == null) continue;
                this.bannedPlayers.add(reference);
            }
        }
        if (compound.func_150297_b("BannedPlayersNames", 9)) {
            this.bannedPlayers.clear();
            ListNBT playerNameList = compound.func_150295_c("BannedPlayersNames", 10);
            for (i = 0; i < playerNameList.size(); ++i) {
                PlayerReference reference;
                CompoundNBT thisCompound = playerNameList.func_150305_b(i);
                if (!thisCompound.func_150297_b("name", 8) || (reference = PlayerReference.of(thisCompound.func_74779_i("name"))) == null || this.isBlacklisted(reference)) continue;
                this.bannedPlayers.add(reference);
            }
        }
    }

    @Override
    public void handleUpdateMessage(CompoundNBT updateInfo) {
        boolean add = updateInfo.func_74767_n("Add");
        String name = updateInfo.func_74779_i("Name");
        PlayerReference player = PlayerReference.of(name);
        if (player == null) {
            return;
        }
        if (add && !this.isBlacklisted(player)) {
            this.bannedPlayers.add(player);
        } else if (!add && this.isBlacklisted(player)) {
            PlayerReference.removeFromList(this.bannedPlayers, name);
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("BannedPlayers")) {
            this.bannedPlayers.clear();
            JsonArray blacklist = json.get("BannedPlayers").getAsJsonArray();
            for (int i = 0; i < blacklist.size(); ++i) {
                PlayerReference reference = PlayerReference.load((JsonElement)blacklist.get(i).getAsJsonObject());
                if (reference == null || this.isBlacklisted(reference)) continue;
                this.bannedPlayers.add(reference);
            }
        }
    }

    @Override
    public CompoundNBT savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(CompoundNBT data) {
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_BLACKLIST;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        TextFieldWidget nameInput;
        Button buttonAddPlayer;
        Button buttonRemovePlayer;
        ScrollTextDisplay playerDisplay;

        protected final PlayerBlacklist getBlacklistRule() {
            if (this.getRuleRaw() instanceof PlayerBlacklist) {
                return (PlayerBlacklist)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            FontRenderer fontRenderer = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 9;
            ((Object)((Object)this.screen)).getClass();
            this.nameInput = new TextFieldWidget(fontRenderer, n, n2, 176 - 20, 20, (ITextComponent)new StringTextComponent(""));
            this.screen.addCustomListener(this.nameInput);
            this.buttonAddPlayer = this.screen.addCustomButton(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 30, 78, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.blacklist.add"), this::PressBlacklistButton));
            int n3 = this.screen.guiLeft();
            ((Object)((Object)this.screen)).getClass();
            this.buttonRemovePlayer = this.screen.addCustomButton(new Button(n3 + 176 - 88, this.screen.guiTop() + 30, 78, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.blacklist.remove"), this::PressForgiveButton));
            int n4 = this.screen.guiLeft() + 7;
            int n5 = this.screen.guiTop() + 55;
            ((Object)((Object)this.screen)).getClass();
            this.playerDisplay = this.addListener(new ScrollTextDisplay(n4, n5, 176 - 14, 114, this.screen.getFont(), (Supplier<List<ITextComponent>>)((Supplier)this::getBlacklistedPlayers)));
            this.playerDisplay.setColumnCount(2);
        }

        private List<ITextComponent> getBlacklistedPlayers() {
            ArrayList playerList = Lists.newArrayList();
            if (this.getBlacklistRule() == null) {
                return playerList;
            }
            for (PlayerReference player : this.getBlacklistRule().bannedPlayers) {
                playerList.add(new StringTextComponent(player.lastKnownName()));
            }
            return playerList;
        }

        @Override
        public void renderTab(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.nameInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.playerDisplay.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onTabClose() {
            this.screen.removeListener((IGuiEventListener)this.nameInput);
            this.screen.removeButton(this.buttonAddPlayer);
            this.screen.removeButton(this.buttonRemovePlayer);
            this.screen.removeListener((IGuiEventListener)this.playerDisplay);
        }

        void PressBlacklistButton(Button button) {
            String name = this.nameInput.func_146179_b();
            if (name != "") {
                this.nameInput.func_146180_a("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && !this.getBlacklistRule().isBlacklisted(reference)) {
                    this.getBlacklistRule().bannedPlayers.add(reference);
                }
                CompoundNBT updateInfo = new CompoundNBT();
                updateInfo.func_74757_a("Add", true);
                updateInfo.func_74778_a("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }

        void PressForgiveButton(Button button) {
            String name = this.nameInput.func_146179_b();
            if (name != "") {
                this.nameInput.func_146180_a("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && this.getBlacklistRule().isBlacklisted(reference)) {
                    boolean notFound = true;
                    for (int i = 0; notFound && i < this.getBlacklistRule().bannedPlayers.size(); ++i) {
                        if (!this.getBlacklistRule().bannedPlayers.get(i).is(reference)) continue;
                        notFound = false;
                        this.getBlacklistRule().bannedPlayers.remove(i);
                    }
                }
                CompoundNBT updateInfo = new CompoundNBT();
                updateInfo.func_74757_a("Add", false);
                updateInfo.func_74778_a("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }
    }
}

