/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerDiscounts
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "discount_list");
    List<PlayerReference> playerList = new ArrayList<PlayerReference>();
    int discount = 10;

    public int getDiscountPercent() {
        return this.discount;
    }

    public void setDiscountPercent(int percent) {
        this.discount = MathUtil.clamp(percent, 0, 100);
    }

    private double getDiscountMult() {
        return 1.0 - (double)this.discount / 100.0;
    }

    private double getIncreaseMult() {
        return 1.0 + (double)this.discount / 100.0;
    }

    public PlayerDiscounts() {
        super(TYPE);
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.isOnList(event.getPlayerReference())) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.applyCostMultiplier(this.getDiscountMult());
                    break;
                }
                case PURCHASE: {
                    event.applyCostMultiplier(this.getIncreaseMult());
                    break;
                }
            }
        }
    }

    public boolean isOnList(PlayerReference player) {
        for (int i = 0; i < this.playerList.size(); ++i) {
            if (!this.playerList.get(i).is(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected CompoundNBT write(CompoundNBT compound) {
        ListNBT playerNameList = new ListNBT();
        for (int i = 0; i < this.playerList.size(); ++i) {
            playerNameList.add((Object)this.playerList.get(i).save());
        }
        compound.func_218657_a("Players", (INBT)playerNameList);
        compound.func_74768_a("discount", this.discount);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        JsonArray playerList = new JsonArray();
        for (int i = 0; i < this.playerList.size(); ++i) {
            playerList.add((JsonElement)this.playerList.get(i).saveAsJson());
        }
        json.add("Players", (JsonElement)playerList);
        json.addProperty("discounrd", (Number)this.discount);
        return json;
    }

    @Override
    public void readNBT(CompoundNBT compound) {
        if (compound.func_150297_b("Players", 9)) {
            this.playerList.clear();
            ListNBT playerNameList = compound.func_150295_c("Players", 10);
            for (int i = 0; i < playerNameList.size(); ++i) {
                CompoundNBT thisCompound = playerNameList.func_150305_b(i);
                PlayerReference reference = PlayerReference.load(thisCompound);
                if (reference != null) {
                    this.playerList.add(reference);
                    continue;
                }
                if (!thisCompound.func_150297_b("name", 8) || (reference = PlayerReference.of(thisCompound.func_74779_i("name"))) == null || this.isOnList(reference)) continue;
                this.playerList.add(reference);
            }
        }
        if (compound.func_150297_b("discount", 3)) {
            this.discount = compound.func_74762_e("discount");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Players")) {
            this.playerList.clear();
            JsonArray playerList = json.get("Players").getAsJsonArray();
            for (int i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.get(i));
                if (reference == null || this.isOnList(reference)) continue;
                this.playerList.add(reference);
            }
        }
        if (json.has("discount")) {
            this.discount = json.get("discount").getAsInt();
        }
    }

    @Override
    public void handleUpdateMessage(CompoundNBT updateInfo) {
        if (updateInfo.func_74764_b("Discount")) {
            this.discount = updateInfo.func_74762_e("Discount");
        } else {
            boolean add = updateInfo.func_74767_n("Add");
            String name = updateInfo.func_74779_i("Name");
            PlayerReference player = PlayerReference.of(name);
            if (add && !this.isOnList(player)) {
                this.playerList.add(player);
            } else if (!add && this.isOnList(player)) {
                PlayerReference.removeFromList(this.playerList, name);
            }
        }
    }

    @Override
    public CompoundNBT savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(CompoundNBT data) {
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_DISCOUNT_LIST;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        TextFieldWidget nameInput;
        TextFieldWidget discountInput;
        Button buttonAddPlayer;
        Button buttonRemovePlayer;
        Button buttonSetDiscount;
        ScrollTextDisplay playerList;

        protected final PlayerDiscounts getRule() {
            if (this.getRuleRaw() instanceof PlayerDiscounts) {
                return (PlayerDiscounts)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            FontRenderer fontRenderer = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 34;
            ((Object)((Object)this.screen)).getClass();
            this.nameInput = this.screen.addCustomListener(new TextFieldWidget(fontRenderer, n, n2, 176 - 20, 20, (ITextComponent)new StringTextComponent("")));
            this.buttonAddPlayer = this.screen.addCustomButton(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 55, 78, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.discount.add"), this::PressAddButton));
            int n3 = this.screen.guiLeft();
            ((Object)((Object)this.screen)).getClass();
            this.buttonRemovePlayer = this.screen.addCustomButton(new Button(n3 + 176 - 88, this.screen.guiTop() + 55, 78, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.discount.remove"), this::PressForgetButton));
            this.discountInput = this.addListener(new TextFieldWidget(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 9, 20, 20, (ITextComponent)new StringTextComponent("")));
            this.discountInput.func_146203_f(2);
            this.discountInput.func_146180_a(Integer.toString(this.getRule().discount));
            this.buttonSetDiscount = this.addButton(new Button(this.screen.guiLeft() + 110, this.screen.guiTop() + 10, 50, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.discount.set"), this::PressSetDiscountButton));
            int n4 = this.screen.guiLeft() + 7;
            int n5 = this.screen.guiTop() + 78;
            ((Object)((Object)this.screen)).getClass();
            this.playerList = this.addListener(new ScrollTextDisplay(n4, n5, 176 - 14, 91, this.screen.getFont(), (Supplier<List<ITextComponent>>)((Supplier)this::getPlayerList)));
            this.playerList.setColumnCount(2);
        }

        private List<ITextComponent> getPlayerList() {
            ArrayList playerList = Lists.newArrayList();
            if (this.getRule() == null) {
                return playerList;
            }
            for (PlayerReference player : this.getRule().playerList) {
                playerList.add(new StringTextComponent(player.lastKnownName()));
            }
            return playerList;
        }

        @Override
        public void renderTab(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.getRule() == null) {
                return;
            }
            this.nameInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.discountInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.playerList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.screen.getFont().func_238421_b_(matrixStack, new TranslationTextComponent("gui.lightmanscurrency.discount.tooltip").getString(), (float)(this.discountInput.field_230690_l_ + this.discountInput.func_230998_h_() + 4), (float)(this.discountInput.field_230691_m_ + 3), 0xFFFFFF);
        }

        @Override
        public void onScreenTick() {
            this.discountInput.func_146178_a();
            this.nameInput.func_146178_a();
            TextInputUtil.whitelistInteger(this.discountInput, 0L, 99L);
        }

        @Override
        public void onTabClose() {
            this.screen.removeListener((IGuiEventListener)this.nameInput);
            this.screen.removeButton(this.buttonAddPlayer);
            this.screen.removeButton(this.buttonRemovePlayer);
            this.screen.removeListener((IGuiEventListener)this.discountInput);
            this.screen.removeButton(this.buttonSetDiscount);
            this.screen.removeListener((IGuiEventListener)this.playerList);
        }

        void PressAddButton(Button button) {
            String name = this.nameInput.func_146179_b();
            if (name != "") {
                this.nameInput.func_146180_a("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && !this.getRule().isOnList(reference)) {
                    this.getRule().playerList.add(reference);
                }
                CompoundNBT updateInfo = new CompoundNBT();
                updateInfo.func_74757_a("Add", true);
                updateInfo.func_74778_a("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }

        void PressForgetButton(Button button) {
            String name = this.nameInput.func_146179_b();
            if (name != "") {
                this.nameInput.func_146180_a("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && this.getRule().isOnList(reference)) {
                    boolean notFound = true;
                    for (int i = 0; notFound && i < this.getRule().playerList.size(); ++i) {
                        if (!this.getRule().playerList.get(i).is(reference)) continue;
                        notFound = false;
                        this.getRule().playerList.remove(i);
                    }
                }
                CompoundNBT updateInfo = new CompoundNBT();
                updateInfo.func_74757_a("Add", false);
                updateInfo.func_74778_a("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }

        void PressSetDiscountButton(Button button) {
            int discount;
            this.getRule().discount = discount = TextInputUtil.getIntegerValue(this.discountInput, 1);
            CompoundNBT updateInfo = new CompoundNBT();
            updateInfo.func_74768_a("Discount", discount);
            this.screen.updateServer(TYPE, updateInfo);
        }
    }
}

