/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerTradeLimit
extends TradeRule {
    public static final ResourceLocation OLD_TYPE = new ResourceLocation("lightmanscurrency", "tradelimit");
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "player_trade_limit");
    private int limit = 1;
    private long timeLimit = 0L;
    Map<UUID, List<Long>> memory = new HashMap<UUID, List<Long>>();

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = newLimit;
    }

    private boolean enforceTimeLimit() {
        return this.timeLimit > 0L;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int newValue) {
        this.timeLimit = newValue;
    }

    public void resetMemory() {
        this.memory.clear();
    }

    public PlayerTradeLimit() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        int tradeCount = this.getTradeCount(event.getPlayerReference().id);
        if (tradeCount >= this.limit) {
            if (this.enforceTimeLimit()) {
                event.denyTrade((ITextComponent)new TranslationTextComponent("traderule.lightmanscurrency.tradelimit.denial.timed", new Object[]{tradeCount, new TimeUtil.TimeData(this.getTimeLimit()).toString()}));
            } else {
                event.denyTrade((ITextComponent)new TranslationTextComponent("traderule.lightmanscurrency.tradelimit.denial", new Object[]{tradeCount}));
            }
            event.denyTrade((ITextComponent)new TranslationTextComponent("traderule.lightmanscurrency.tradelimit.denial.limit", new Object[]{this.limit}));
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.addEvent(event.getPlayerReference().id, TimeUtil.getCurrentTime());
        this.clearExpiredData();
        event.markDirty();
    }

    private void addEvent(UUID player, Long time) {
        List<Long> eventTimes = new ArrayList<Long>();
        if (this.memory.containsKey(player)) {
            eventTimes = this.memory.get(player);
        }
        eventTimes.add(time);
        this.memory.put(player, eventTimes);
    }

    private void clearExpiredData() {
        if (!this.enforceTimeLimit()) {
            return;
        }
        ArrayList emptyEntries = new ArrayList();
        this.memory.forEach((id, eventTimes) -> {
            for (int i = 0; i < eventTimes.size(); ++i) {
                if (TimeUtil.compareTime(this.timeLimit, (Long)eventTimes.get(i))) continue;
                eventTimes.remove(i);
                --i;
            }
            if (eventTimes.size() <= 0) {
                emptyEntries.add(id);
            }
        });
        emptyEntries.forEach(id -> this.memory.remove(id));
    }

    private int getTradeCount(UUID playerID) {
        int count = 0;
        if (this.memory.containsKey(playerID)) {
            List<Long> eventTimes = this.memory.get(playerID);
            if (!this.enforceTimeLimit()) {
                return eventTimes.size();
            }
            for (int i = 0; i < eventTimes.size(); ++i) {
                if (!TimeUtil.compareTime(this.timeLimit, eventTimes.get(i))) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a("Limit", this.limit);
        ListNBT memoryList = new ListNBT();
        this.memory.forEach((id, eventTimes) -> {
            CompoundNBT thisMemory = new CompoundNBT();
            thisMemory.func_186854_a("id", id);
            thisMemory.func_202168_c("times", eventTimes);
            memoryList.add((Object)thisMemory);
        });
        compound.func_218657_a("Memory", (INBT)memoryList);
        compound.func_74772_a("ForgetTime", this.timeLimit);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Limit", (Number)this.limit);
        if (this.enforceTimeLimit()) {
            json.addProperty("ForgetTime", (Number)this.timeLimit);
        }
        return json;
    }

    @Override
    public void readNBT(CompoundNBT compound) {
        if (compound.func_150297_b("Limit", 3)) {
            this.limit = compound.func_74762_e("Limit");
        }
        if (compound.func_150297_b("Memory", 9)) {
            this.memory.clear();
            ListNBT memoryList = compound.func_150295_c("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundNBT thisMemory = memoryList.func_150305_b(i);
                UUID id = null;
                ArrayList<Long> eventTimes = new ArrayList<Long>();
                if (thisMemory.func_74764_b("id")) {
                    id = thisMemory.func_186857_a("id");
                }
                if (thisMemory.func_150297_b("count", 3)) {
                    int count = thisMemory.func_74762_e("count");
                    for (int z = 0; z < count; ++z) {
                        eventTimes.add(0L);
                    }
                }
                if (thisMemory.func_150297_b("times", 12)) {
                    for (long time : thisMemory.func_197645_o("times")) {
                        eventTimes.add(time);
                    }
                }
                this.memory.put(id, eventTimes);
            }
        }
        if (compound.func_150297_b("ForgetTime", 4)) {
            this.timeLimit = compound.func_74763_f("ForgetTime");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Limit")) {
            this.limit = json.get("Limit").getAsInt();
        }
        if (json.has("ForgetTime")) {
            this.timeLimit = json.get("ForgetTime").getAsLong();
        }
    }

    @Override
    public void handleUpdateMessage(CompoundNBT updateInfo) {
        if (updateInfo.func_74764_b("Limit")) {
            this.limit = updateInfo.func_74762_e("Limit");
        } else if (updateInfo.func_74764_b("TimeLimit")) {
            this.timeLimit = updateInfo.func_74763_f("TimeLimit");
        } else if (updateInfo.func_74764_b("ClearMemory")) {
            this.resetMemory();
        }
    }

    @Override
    public CompoundNBT savePersistentData() {
        CompoundNBT data = new CompoundNBT();
        ListNBT memoryList = new ListNBT();
        this.memory.forEach((id, eventTimes) -> {
            CompoundNBT thisMemory = new CompoundNBT();
            thisMemory.func_186854_a("id", id);
            thisMemory.func_202168_c("times", eventTimes);
            memoryList.add((Object)thisMemory);
        });
        data.func_218657_a("Memory", (INBT)memoryList);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundNBT data) {
        if (data.func_150297_b("Memory", 9)) {
            this.memory.clear();
            ListNBT memoryList = data.func_150295_c("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundNBT thisMemory = memoryList.func_150305_b(i);
                UUID id = null;
                ArrayList<Long> eventTimes = new ArrayList<Long>();
                if (thisMemory.func_74764_b("id")) {
                    id = thisMemory.func_186857_a("id");
                }
                if (thisMemory.func_150297_b("count", 3)) {
                    int count = thisMemory.func_74762_e("count");
                    for (int z = 0; z < count; ++z) {
                        eventTimes.add(0L);
                    }
                }
                if (thisMemory.func_150297_b("times", 12)) {
                    for (long time : thisMemory.func_197645_o("times")) {
                        eventTimes.add(time);
                    }
                }
                this.memory.put(id, eventTimes);
            }
        }
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_COUNT_PLAYER;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler
    implements TimeWidget.ITimeInput {
        TextFieldWidget limitInput;
        Button buttonSetLimit;
        Button buttonClearMemory;
        TimeWidget timeInput;

        private final PlayerTradeLimit getRule() {
            if (this.getRuleRaw() instanceof PlayerTradeLimit) {
                return (PlayerTradeLimit)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            this.limitInput = new TextFieldWidget(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 19, 30, 20, (ITextComponent)new StringTextComponent(""));
            this.limitInput.func_146203_f(3);
            this.limitInput.func_146180_a(Integer.toString(this.getRule().limit));
            this.addListener(this.limitInput);
            this.buttonSetLimit = this.addButton(new Button(this.screen.guiLeft() + 41, this.screen.guiTop() + 19, 40, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.playerlimit.setlimit"), this::PressSetLimitButton));
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 50;
            ((Object)((Object)this.screen)).getClass();
            this.buttonClearMemory = this.addButton(new Button(n, n2, 176 - 20, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.playerlimit.clearmemory"), this::PressClearMemoryButton));
            this.timeInput = this.addListener(new TimeWidget(this.screen.guiLeft(), this.screen.guiTop() + 80, this.screen.getFont(), this.getRule().timeLimit, this, this, (ITextComponent)new TranslationTextComponent("gui.widget.lightmanscurrency.playerlimit.noduration")));
        }

        @Override
        public void renderTab(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.limitInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.timeInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.screen.getFont().func_238421_b_(matrixStack, new TranslationTextComponent("gui.button.lightmanscurrency.playerlimit.info", new Object[]{this.getRule().limit}).getString(), (float)(this.screen.guiLeft() + 10), (float)(this.screen.guiTop() + 9), 0xFFFFFF);
            if (this.buttonClearMemory.func_231047_b_((double)mouseX, (double)mouseY)) {
                this.screen.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.playerlimit.clearmemory.tooltip"), mouseX, mouseY);
            }
        }

        @Override
        public void onTabClose() {
            this.screen.removeListener((IGuiEventListener)this.limitInput);
            this.screen.removeButton(this.buttonSetLimit);
            this.screen.removeButton(this.buttonClearMemory);
            this.timeInput.getButtons().forEach(button -> this.screen.removeButton((Button)button));
            this.timeInput.getListeners().forEach(listener -> this.screen.removeListener((IGuiEventListener)listener));
            this.screen.removeListener((IGuiEventListener)this.timeInput);
        }

        @Override
        public void onScreenTick() {
            this.limitInput.func_146178_a();
            this.timeInput.tick();
            TextInputUtil.whitelistInteger(this.limitInput, 1L, 100L);
        }

        void PressSetLimitButton(Button button) {
            int limit = MathUtil.clamp(TextInputUtil.getIntegerValue(this.limitInput), 1, 100);
            this.getRule().limit = limit;
            CompoundNBT updateInfo = new CompoundNBT();
            updateInfo.func_74768_a("Limit", limit);
            this.screen.updateServer(TYPE, updateInfo);
        }

        void PressClearMemoryButton(Button button) {
            this.getRule().memory.clear();
            CompoundNBT updateInfo = new CompoundNBT();
            updateInfo.func_74757_a("ClearMemory", true);
            this.screen.updateServer(TYPE, updateInfo);
        }

        @Override
        public void onTimeSet(long newTime) {
            long timeLimit = MathUtil.clamp(newTime, 0L, Long.MAX_VALUE);
            this.getRule().timeLimit = timeLimit;
            CompoundNBT updateInfo = new CompoundNBT();
            updateInfo.func_74772_a("TimeLimit", timeLimit);
            this.screen.updateServer(TYPE, updateInfo);
        }
    }
}

