/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerWhitelist
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "whitelist");
    List<PlayerReference> whitelistedPlayers = new ArrayList<PlayerReference>();

    public PlayerWhitelist() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (!this.isWhitelisted(event.getPlayerReference())) {
            event.denyTrade((ITextComponent)new TranslationTextComponent("traderule.lightmanscurrency.whitelist.denial"));
        }
    }

    public boolean isWhitelisted(PlayerReference player) {
        for (int i = 0; i < this.whitelistedPlayers.size(); ++i) {
            if (!this.whitelistedPlayers.get(i).is(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        ListNBT playerNameList = new ListNBT();
        for (int i = 0; i < this.whitelistedPlayers.size(); ++i) {
            playerNameList.add((Object)this.whitelistedPlayers.get(i).save());
        }
        compound.func_218657_a("WhitelistedPlayers", (INBT)playerNameList);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        JsonArray whitelist = new JsonArray();
        for (int i = 0; i < this.whitelistedPlayers.size(); ++i) {
            whitelist.add((JsonElement)this.whitelistedPlayers.get(i).saveAsJson());
        }
        json.add("WhitelistedPlayers", (JsonElement)whitelist);
        return json;
    }

    @Override
    public void readNBT(CompoundNBT compound) {
        int i;
        if (compound.func_150297_b("WhitelistedPlayers", 9)) {
            this.whitelistedPlayers.clear();
            ListNBT playerList = compound.func_150295_c("WhitelistedPlayers", 10);
            for (i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.func_150305_b(i));
                if (reference == null) continue;
                this.whitelistedPlayers.add(reference);
            }
        }
        if (compound.func_150297_b("WhitelistedPlayersNames", 9)) {
            this.whitelistedPlayers.clear();
            ListNBT playerNameList = compound.func_150295_c("WhitelistedPlayersNames", 10);
            for (i = 0; i < playerNameList.size(); ++i) {
                PlayerReference reference;
                CompoundNBT thisCompound = playerNameList.func_150305_b(i);
                if (!thisCompound.func_150297_b("name", 8) || (reference = PlayerReference.of(thisCompound.func_74779_i("name"))) == null || this.isWhitelisted(reference)) continue;
                this.whitelistedPlayers.add(reference);
            }
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("WhitelistedPlayers")) {
            this.whitelistedPlayers.clear();
            JsonArray whitelist = json.get("WhitelistedPlayers").getAsJsonArray();
            for (int i = 0; i < whitelist.size(); ++i) {
                PlayerReference reference = PlayerReference.load((JsonElement)whitelist.get(i).getAsJsonObject());
                if (reference == null || this.isWhitelisted(reference)) continue;
                this.whitelistedPlayers.add(reference);
            }
        }
    }

    @Override
    public void handleUpdateMessage(CompoundNBT updateInfo) {
        boolean add = updateInfo.func_74767_n("Add");
        String name = updateInfo.func_74779_i("Name");
        PlayerReference player = PlayerReference.of(name);
        if (player == null) {
            return;
        }
        if (add && !this.isWhitelisted(player)) {
            this.whitelistedPlayers.add(player);
        } else if (!add && this.isWhitelisted(player)) {
            PlayerReference.removeFromList(this.whitelistedPlayers, name);
        }
    }

    @Override
    public CompoundNBT savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(CompoundNBT data) {
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_WHITELIST;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        TextFieldWidget nameInput;
        Button buttonAddPlayer;
        Button buttonRemovePlayer;
        ScrollTextDisplay playerDisplay;

        protected final PlayerWhitelist getWhitelistRule() {
            if (this.getRuleRaw() instanceof PlayerWhitelist) {
                return (PlayerWhitelist)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            FontRenderer fontRenderer = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 9;
            ((Object)((Object)this.screen)).getClass();
            this.nameInput = new TextFieldWidget(fontRenderer, n, n2, 176 - 20, 20, (ITextComponent)new StringTextComponent(""));
            this.screen.addCustomListener(this.nameInput);
            this.buttonAddPlayer = this.screen.addCustomButton(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 30, 78, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.whitelist.add"), this::PressWhitelistButton));
            int n3 = this.screen.guiLeft();
            ((Object)((Object)this.screen)).getClass();
            this.buttonRemovePlayer = this.screen.addCustomButton(new Button(n3 + 176 - 88, this.screen.guiTop() + 30, 78, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.whitelist.remove"), this::PressForgetButton));
            int n4 = this.screen.guiLeft() + 7;
            int n5 = this.screen.guiTop() + 55;
            ((Object)((Object)this.screen)).getClass();
            this.playerDisplay = this.addListener(new ScrollTextDisplay(n4, n5, 176 - 14, 114, this.screen.getFont(), (Supplier<List<ITextComponent>>)((Supplier)this::getWhitelistedPlayers)));
            this.playerDisplay.setColumnCount(2);
        }

        private List<ITextComponent> getWhitelistedPlayers() {
            ArrayList playerList = Lists.newArrayList();
            if (this.getWhitelistRule() == null) {
                return playerList;
            }
            for (PlayerReference player : this.getWhitelistRule().whitelistedPlayers) {
                playerList.add(new StringTextComponent(player.lastKnownName()));
            }
            return playerList;
        }

        @Override
        public void renderTab(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.getWhitelistRule() == null) {
                return;
            }
            this.nameInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.playerDisplay.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onTabClose() {
            this.screen.removeListener((IGuiEventListener)this.nameInput);
            this.screen.removeButton(this.buttonAddPlayer);
            this.screen.removeButton(this.buttonRemovePlayer);
            this.screen.removeListener((IGuiEventListener)this.playerDisplay);
        }

        void PressWhitelistButton(Button button) {
            String name = this.nameInput.func_146179_b();
            if (name != "") {
                this.nameInput.func_146180_a("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && !this.getWhitelistRule().isWhitelisted(reference)) {
                    this.getWhitelistRule().whitelistedPlayers.add(reference);
                }
                CompoundNBT updateInfo = new CompoundNBT();
                updateInfo.func_74757_a("Add", true);
                updateInfo.func_74778_a("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }

        void PressForgetButton(Button button) {
            String name = this.nameInput.func_146179_b();
            if (name != "") {
                this.nameInput.func_146180_a("");
                PlayerReference reference = PlayerReference.of(name);
                if (reference != null && this.getWhitelistRule().isWhitelisted(reference)) {
                    boolean notFound = true;
                    for (int i = 0; notFound && i < this.getWhitelistRule().whitelistedPlayers.size(); ++i) {
                        if (!this.getWhitelistRule().whitelistedPlayers.get(i).is(reference)) continue;
                        notFound = false;
                        this.getWhitelistRule().whitelistedPlayers.remove(i);
                    }
                }
                CompoundNBT updateInfo = new CompoundNBT();
                updateInfo.func_74757_a("Add", false);
                updateInfo.func_74778_a("Name", name);
                this.screen.updateServer(TYPE, updateInfo);
            }
        }
    }
}

