/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TimedSale
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "timed_sale");
    long startTime = 0L;
    long duration = 0L;
    int discount = 10;

    boolean isActive() {
        return this.startTime != 0L;
    }

    public int getDiscountPercent() {
        return this.discount;
    }

    public void setDiscountPercent(int percent) {
        this.discount = MathUtil.clamp(percent, 0, 100);
    }

    private double getDiscountMult() {
        return 1.0 - (double)this.discount / 100.0;
    }

    private double getIncreaseMult() {
        return 1.0 + (double)this.discount / 100.0;
    }

    public TimedSale() {
        super(TYPE);
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.isActive() && TimeUtil.compareTime(this.duration, this.startTime)) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.applyCostMultiplier(this.getDiscountMult());
                    break;
                }
                case PURCHASE: {
                    event.applyCostMultiplier(this.getIncreaseMult());
                    break;
                }
            }
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        if (this.confirmStillActive()) {
            event.markDirty();
        }
    }

    private boolean confirmStillActive() {
        if (!this.isActive()) {
            return false;
        }
        if (!TimeUtil.compareTime(this.duration, this.startTime)) {
            this.startTime = 0L;
            return true;
        }
        return false;
    }

    @Override
    protected CompoundNBT write(CompoundNBT compound) {
        compound.func_74772_a("startTime", this.startTime);
        compound.func_74772_a("duration", this.duration);
        compound.func_74768_a("discount", this.discount);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("duration", (Number)this.duration);
        json.addProperty("discount", (Number)this.discount);
        return json;
    }

    @Override
    public void readNBT(CompoundNBT compound) {
        if (compound.func_150297_b("startTime", 4)) {
            this.startTime = compound.func_74763_f("startTime");
        }
        if (compound.func_150297_b("duration", 4)) {
            this.duration = compound.func_74763_f("duration");
        }
        if (compound.func_150297_b("discount", 3)) {
            this.discount = compound.func_74762_e("discount");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("duration")) {
            this.duration = json.get("duration").getAsLong();
        }
        if (json.has("discount")) {
            this.discount = MathUtil.clamp(this.discount, 0, 100);
        }
    }

    @Override
    public void handleUpdateMessage(CompoundNBT updateInfo) {
        if (updateInfo.func_74764_b("Discount")) {
            this.discount = updateInfo.func_74762_e("Discount");
        } else if (updateInfo.func_74764_b("Duration")) {
            this.duration = updateInfo.func_74763_f("Duration");
        } else if (updateInfo.func_74764_b("StartSale")) {
            if (this.isActive() == updateInfo.func_74767_n("StartSale")) {
                return;
            }
            this.startTime = this.isActive() ? 0L : TimeUtil.getCurrentTime();
        }
    }

    @Override
    public CompoundNBT savePersistentData() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74772_a("startTime", this.startTime);
        return compound;
    }

    @Override
    public void loadPersistentData(CompoundNBT data) {
        if (data.func_150297_b("startTime", 4)) {
            this.startTime = data.func_74763_f("startTime");
        }
    }

    public TimeUtil.TimeData getTimeRemaining() {
        if (!this.isActive()) {
            return new TimeUtil.TimeData(0L);
        }
        return new TimeUtil.TimeData(this.startTime + this.duration - TimeUtil.getCurrentTime());
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_TIMED_SALE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler
    implements TimeWidget.ITimeInput {
        TextFieldWidget discountInput;
        Button buttonSetDiscount;
        Button buttonStartSale;
        TimeWidget durationInput;

        protected final TimedSale getRule() {
            if (this.getRuleRaw() instanceof TimedSale) {
                return (TimedSale)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            this.discountInput = this.addListener(new TextFieldWidget(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 9, 20, 20, (ITextComponent)new StringTextComponent("")));
            this.discountInput.func_146203_f(2);
            this.discountInput.func_146180_a(Integer.toString(this.getRule().discount));
            this.buttonSetDiscount = this.addButton(new Button(this.screen.guiLeft() + 110, this.screen.guiTop() + 10, 50, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.discount.set"), this::PressSetDiscountButton));
            this.buttonStartSale = this.addButton(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 45, 156, 20, this.getButtonText(), this::PressStartButton));
            this.durationInput = this.addListener(new TimeWidget(this.screen.guiLeft(), this.screen.guiTop() + 75, this.screen.getFont(), this.getRule().duration, this, this, (ITextComponent)new TranslationTextComponent("gui.widget.lightmanscurrency.timed_sale.noduration")));
        }

        @Override
        public void renderTab(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.getRule() == null) {
                return;
            }
            this.discountInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.screen.getFont().func_238421_b_(matrixStack, new TranslationTextComponent("gui.lightmanscurrency.discount.tooltip").getString(), (float)(this.discountInput.field_230690_l_ + this.discountInput.func_230998_h_() + 4), (float)(this.discountInput.field_230691_m_ + 3), 0xFFFFFF);
            this.durationInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            TranslationTextComponent infoText = new TranslationTextComponent("gui.button.lightmanscurrency.timed_sale.info.inactive", new Object[]{new TimeUtil.TimeData(this.getRule().duration).toString()});
            if (this.getRule().isActive()) {
                infoText = new TranslationTextComponent("gui.button.lightmanscurrency.timed_sale.info.active", new Object[]{this.getRule().getTimeRemaining().toString()});
            }
            this.screen.getFont().func_238421_b_(matrixStack, infoText.getString(), (float)(this.screen.guiLeft() + 10), (float)(this.screen.guiTop() + 35), 0xFFFFFF);
            if (this.buttonStartSale.func_231047_b_((double)mouseX, (double)mouseY)) {
                this.screen.func_238652_a_(matrixStack, this.getButtonTooltip(), mouseX, mouseY);
            }
        }

        @Override
        public void onScreenTick() {
            this.buttonStartSale.func_238482_a_(this.getButtonText());
            this.buttonStartSale.field_230693_o_ = this.getRule().isActive() || this.getRule().duration > 0L;
            TextInputUtil.whitelistInteger(this.discountInput, 0L, 99L);
            this.durationInput.tick();
            this.discountInput.func_146178_a();
        }

        private ITextComponent getButtonText() {
            return new TranslationTextComponent("gui.button.lightmanscurrency.timed_sale." + (this.getRule().isActive() ? "stop" : "start"));
        }

        private ITextComponent getButtonTooltip() {
            return new TranslationTextComponent("gui.button.lightmanscurrency.timed_sale." + (this.getRule().isActive() ? "stop" : "start") + ".tooltip");
        }

        @Override
        public void onTabClose() {
            this.screen.removeListener((IGuiEventListener)this.discountInput);
            this.screen.removeButton(this.buttonSetDiscount);
            this.screen.removeButton(this.buttonStartSale);
            this.durationInput.getButtons().forEach(button -> this.screen.removeButton((Button)button));
            this.durationInput.getListeners().forEach(listener -> this.screen.removeListener((IGuiEventListener)listener));
            this.screen.removeListener((IGuiEventListener)this.durationInput);
        }

        void PressSetDiscountButton(Button button) {
            int discount;
            this.getRule().discount = discount = TextInputUtil.getIntegerValue(this.discountInput, 1);
            CompoundNBT updateInfo = new CompoundNBT();
            updateInfo.func_74768_a("Discount", discount);
            this.screen.updateServer(TYPE, updateInfo);
        }

        void PressStartButton(Button button) {
            boolean setActive = !this.getRule().isActive();
            this.getRule().startTime = this.getRule().isActive() ? 0L : TimeUtil.getCurrentTime();
            CompoundNBT updateInfo = new CompoundNBT();
            updateInfo.func_74757_a("StartSale", setActive);
            this.screen.updateServer(TYPE, updateInfo);
        }

        @Override
        public void onTimeSet(long newTime) {
            this.getRule().duration = newTime;
            CompoundNBT updateInfo = new CompoundNBT();
            updateInfo.func_74772_a("Duration", newTime);
            this.screen.updateServer(TYPE, updateInfo);
        }
    }
}

