/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TradeLimit
extends TradeRule {
    public static final ResourceLocation OLD_TYPE = new ResourceLocation("lightmanscurrency", "tradelimit2");
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "trade_limit");
    private int limit = 1;
    int count = 0;

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = newLimit;
    }

    public void resetCount() {
        this.count = 0;
    }

    public TradeLimit() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.count >= this.limit) {
            event.denyTrade((ITextComponent)new TranslationTextComponent("traderule.lightmanscurrency.tradelimit2.denial", new Object[]{this.count}));
            event.denyTrade((ITextComponent)new TranslationTextComponent("traderule.lightmanscurrency.tradelimit.denial.limit", new Object[]{this.limit}));
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        ++this.count;
        event.markDirty();
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a("Limit", this.limit);
        compound.func_74768_a("Count", this.count);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Limit", (Number)this.limit);
        return json;
    }

    @Override
    public void readNBT(CompoundNBT compound) {
        if (compound.func_150297_b("Limit", 3)) {
            this.limit = compound.func_74762_e("Limit");
        }
        if (compound.func_150297_b("Count", 3)) {
            this.count = compound.func_74762_e("Count");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Limit")) {
            this.limit = json.get("Limit").getAsInt();
        }
    }

    @Override
    public void handleUpdateMessage(CompoundNBT updateInfo) {
        if (updateInfo.func_74764_b("Limit")) {
            this.limit = updateInfo.func_74762_e("Limit");
        } else if (updateInfo.func_74764_b("ClearMemory")) {
            this.count = 0;
        }
    }

    @Override
    public CompoundNBT savePersistentData() {
        CompoundNBT data = new CompoundNBT();
        data.func_74768_a("Count", this.count);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundNBT data) {
        if (data.func_150297_b("Count", 3)) {
            this.count = data.func_74762_e("Count");
        }
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_COUNT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        TextFieldWidget limitInput;
        Button buttonSetLimit;
        Button buttonClearMemory;

        private final TradeLimit getRule() {
            if (this.getRuleRaw() instanceof TradeLimit) {
                return (TradeLimit)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            this.limitInput = this.addListener(new TextFieldWidget(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 19, 30, 20, (ITextComponent)new StringTextComponent("")));
            this.limitInput.func_146203_f(3);
            this.limitInput.func_146180_a(Integer.toString(this.getRule().limit));
            this.buttonSetLimit = this.addButton(new Button(this.screen.guiLeft() + 41, this.screen.guiTop() + 19, 40, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.playerlimit.setlimit"), this::PressSetLimitButton));
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 50;
            ((Object)((Object)this.screen)).getClass();
            this.buttonClearMemory = this.addButton(new Button(n, n2, 176 - 20, 20, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.playerlimit.clearmemory"), this::PressClearMemoryButton));
        }

        @Override
        public void renderTab(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.limitInput.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.screen.getFont().func_238421_b_(matrixStack, new TranslationTextComponent("gui.button.lightmanscurrency.playerlimit.info", new Object[]{this.getRule().limit}).getString(), (float)(this.screen.guiLeft() + 10), (float)(this.screen.guiTop() + 9), 0xFFFFFF);
            if (this.buttonClearMemory.func_231047_b_((double)mouseX, (double)mouseY)) {
                this.screen.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.button.lightmanscurrency.playerlimit.clearmemory.tooltip"), mouseX, mouseY);
            }
        }

        @Override
        public void onTabClose() {
            this.screen.removeListener((IGuiEventListener)this.limitInput);
            this.screen.removeButton(this.buttonSetLimit);
            this.screen.removeButton(this.buttonClearMemory);
        }

        @Override
        public void onScreenTick() {
            this.limitInput.func_146178_a();
            TextInputUtil.whitelistInteger(this.limitInput, 1L, 100L);
        }

        void PressSetLimitButton(Button button) {
            int limit = MathUtil.clamp(TextInputUtil.getIntegerValue(this.limitInput), 1, 100);
            this.getRule().limit = limit;
            CompoundNBT updateInfo = new CompoundNBT();
            updateInfo.func_74768_a("Limit", limit);
            this.screen.updateServer(TYPE, updateInfo);
        }

        void PressClearMemoryButton(Button button) {
            this.getRule().resetCount();
            CompoundNBT updateInfo = new CompoundNBT();
            updateInfo.func_74757_a("ClearMemory", true);
            this.screen.updateServer(TYPE, updateInfo);
        }
    }
}

