/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FileUtil {
    public static Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    public static JsonObject convertItemStack(ItemStack item) {
        JsonObject json = new JsonObject();
        json.addProperty("id", item.func_77973_b().getRegistryName().toString());
        json.addProperty("Count", (Number)item.func_190916_E());
        if (item.func_77942_o()) {
            String tag = item.func_77978_p().func_150285_a_();
            json.addProperty("tag", tag);
        }
        return json;
    }

    public static ItemStack parseItemStack(JsonObject json) throws Exception {
        String id = json.get("id").getAsString();
        int count = json.get("Count").getAsInt();
        ItemStack result = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id)), count);
        try {
            if (json.has("tag")) {
                JsonElement tag = json.get("tag");
                if (tag.isJsonPrimitive() && tag.getAsJsonPrimitive().isString()) {
                    CompoundNBT compound = JsonToNBT.func_180713_a((String)tag.getAsString());
                    result.func_77982_d(compound);
                } else {
                    CompoundNBT compound = JsonToNBT.func_180713_a((String)GSON.toJson(tag));
                    result.func_77982_d(compound);
                }
            }
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error parsing tag data.", e);
        }
        return result;
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        FileWriter fw = new FileWriter(file);
        BufferedWriter bw = new BufferedWriter(fw);
        PrintWriter writer = new PrintWriter(bw);
        writer.print(string);
        writer.close();
    }
}

