/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.util.ItemStackHelper;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InventoryUtil {
    public static Inventory buildInventory(List<ItemStack> list) {
        Inventory inventory = new Inventory(list.size());
        for (int i = 0; i < list.size(); ++i) {
            inventory.func_70299_a(i, list.get(i).func_77946_l());
        }
        return inventory;
    }

    public static IInventory buildInventory(ItemStack stack) {
        Inventory inventory = new Inventory(1);
        inventory.func_70299_a(0, stack);
        return inventory;
    }

    public static IInventory copyInventory(IInventory inventory) {
        Inventory copy = new Inventory(inventory.func_70302_i_());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            copy.func_70299_a(i, inventory.func_70301_a(i).func_77946_l());
        }
        return copy;
    }

    public static NonNullList<ItemStack> buildList(IInventory inventory) {
        NonNullList list = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            list.set(i, (Object)inventory.func_70301_a(i).func_77946_l());
        }
        return list;
    }

    public static int GetItemCount(IInventory inventory, Item item) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_77973_b() != item) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static int GetItemCount(IInventory inventory, ItemStack item) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static boolean RemoveItemCount(IInventory inventory, Item item, int count) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_77973_b() != item) continue;
            if (stack.func_190916_E() > count) {
                stack.func_190918_g(count);
                return true;
            }
            count -= stack.func_190916_E();
            inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
        return count <= 0;
    }

    public static boolean RemoveItemCount(IInventory inventory, ItemStack item) {
        if (InventoryUtil.GetItemCount(inventory, item) < item.func_190916_E()) {
            return false;
        }
        int count = item.func_190916_E();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            int amountToTake = MathUtil.clamp(count, 0, stack.func_190916_E());
            count -= amountToTake;
            if (amountToTake == stack.func_190916_E()) {
                inventory.func_70299_a(i, ItemStack.field_190927_a);
                continue;
            }
            stack.func_190918_g(amountToTake);
        }
        return true;
    }

    public static int GetItemTagCount(IInventory inventory, ResourceLocation itemTag, Item ... blacklistItems) {
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!stack.func_77973_b().getTags().contains(itemTag) || blacklist.contains(stack.func_77973_b())) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static boolean RemoveItemTagCount(IInventory inventory, ResourceLocation itemTag, int count, Item ... blacklistItems) {
        if (InventoryUtil.GetItemTagCount(inventory, itemTag, blacklistItems) < count) {
            return false;
        }
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!stack.func_77973_b().getTags().contains(itemTag) || blacklist.contains(stack.func_77973_b())) continue;
            int amountToTake = MathUtil.clamp(count, 0, stack.func_190916_E());
            count -= amountToTake;
            if (amountToTake == stack.func_190916_E()) {
                inventory.func_70299_a(i, ItemStack.field_190927_a);
                continue;
            }
            stack.func_190918_g(amountToTake);
        }
        return true;
    }

    public static boolean PutItemStack(IInventory inventory, ItemStack stack) {
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        int amountToMerge = stack.func_190916_E();
        Item mergeItem = stack.func_77973_b();
        ArrayList<Pair> mergeOrders = new ArrayList<Pair>();
        for (i = 0; i < inventory.func_70302_i_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.func_70301_a(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.func_190916_E() == inventoryStack.func_77976_d()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.func_77976_d() - inventoryStack.func_190916_E());
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.func_70302_i_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.func_70301_a(i);
            if (!inventoryStack.func_190926_b()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.func_77976_d());
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        if (amountToMerge > 0) {
            return false;
        }
        mergeOrders.forEach(order -> {
            ItemStack itemStack = inventory.func_70301_a(((Integer)order.getFirst()).intValue());
            if (itemStack.func_190926_b()) {
                ItemStack newStack = new ItemStack((IItemProvider)mergeItem, ((Integer)order.getSecond()).intValue());
                if (stack.func_77942_o()) {
                    newStack.func_77982_d(stack.func_77978_p().func_74737_b());
                }
                inventory.func_70299_a(((Integer)order.getFirst()).intValue(), newStack);
            } else {
                itemStack.func_190920_e(itemStack.func_190916_E() + (Integer)order.getSecond());
            }
        });
        return true;
    }

    public static ItemStack TryPutItemStack(IInventory inventory, ItemStack stack) {
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        int amountToMerge = stack.func_190916_E();
        Item mergeItem = stack.func_77973_b();
        for (i = 0; i < inventory.func_70302_i_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.func_70301_a(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.func_190916_E() == inventoryStack.func_77976_d()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.func_77976_d() - inventoryStack.func_190916_E());
            inventoryStack.func_190917_f(amountToPlace);
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.func_70302_i_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.func_70301_a(i);
            if (!inventoryStack.func_190926_b()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.func_77976_d());
            ItemStack newStack = new ItemStack((IItemProvider)mergeItem, amountToPlace);
            if (stack.func_77942_o()) {
                newStack.func_77982_d(stack.func_77978_p().func_74737_b());
            }
            inventory.func_70299_a(i, newStack);
            amountToMerge -= amountToPlace;
        }
        if (amountToMerge > 0) {
            return new ItemStack((IItemProvider)mergeItem, amountToMerge);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean CanPutItemStack(IInventory inventory, ItemStack stack) {
        int amountToPlace;
        ItemStack inventoryStack;
        int i;
        int amountToMerge = stack.func_190916_E();
        for (i = 0; i < inventory.func_70302_i_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.func_70301_a(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.func_190916_E() == inventoryStack.func_77976_d()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.func_77976_d() - inventoryStack.func_190916_E());
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.func_70302_i_() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.func_70301_a(i);
            if (!inventoryStack.func_190926_b()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.func_77976_d());
            amountToMerge -= amountToPlace;
        }
        return amountToMerge <= 0;
    }

    public static void MergeStacks(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int amountWanted;
            ItemStack thisStack = inventory.func_70301_a(i);
            if (thisStack.func_190926_b() || (amountWanted = thisStack.func_77976_d() - thisStack.func_190916_E()) <= 0) continue;
            for (int j = i + 1; j < inventory.func_70302_i_(); ++j) {
                ItemStack nextStack = inventory.func_70301_a(j);
                if (nextStack.func_190926_b() || nextStack.func_77973_b() != thisStack.func_77973_b() || !ItemStackHelper.TagEquals(thisStack, nextStack)) continue;
                while (amountWanted > 0 && !nextStack.func_190926_b()) {
                    nextStack.func_190920_e(nextStack.func_190916_E() - 1);
                    thisStack.func_190920_e(thisStack.func_190916_E() + 1);
                    --amountWanted;
                }
            }
        }
    }

    public static IInventory loadAllItems(String key, CompoundNBT compound, int inventorySize) {
        NonNullList tempInventory = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
        ItemStackHelper.loadAllItems(key, compound, (NonNullList<ItemStack>)tempInventory);
        return InventoryUtil.buildInventory((List<ItemStack>)tempInventory);
    }

    public static void saveAllItems(String key, CompoundNBT compound, IInventory inventory) {
        ItemStackHelper.saveAllItems(key, compound, InventoryUtil.buildList(inventory));
    }

    public static void dumpContents(World world, BlockPos pos, IInventory inventory) {
        if (world.field_72995_K) {
            return;
        }
        InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)inventory);
    }

    public static void dumpContents(World world, BlockPos pos, List<ItemStack> inventory) {
        if (world.field_72995_K) {
            return;
        }
        InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)InventoryUtil.buildInventory(inventory));
    }

    public static boolean ItemMatches(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() == stack2.func_77973_b()) {
            return ItemStackHelper.TagEquals(stack1, stack2);
        }
        return false;
    }
}

