/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.util.MathUtil;

public class TimeUtil {
    public static long getCurrentTime() {
        return System.currentTimeMillis() + LightmansCurrency.PROXY.getTimeDesync();
    }

    public static boolean compareTime(long duration, long compareTime) {
        long ignoreTime = TimeUtil.getCurrentTime() - duration;
        return compareTime >= ignoreTime;
    }

    public static long getDuration(long hours, long minutes, long seconds) {
        hours = MathUtil.clamp(hours, 0L, Long.MAX_VALUE);
        minutes = MathUtil.clamp(minutes, 0L, 59L);
        seconds = MathUtil.clamp(seconds, 0L, 59L);
        return (seconds += 60L * (minutes += 60L * hours)) * 1000L;
    }

    public static TimeData separateDuration(long duration) {
        long seconds = duration / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        return new TimeData(hours, minutes %= 60L, seconds %= 60L);
    }

    public static class TimeData {
        public final long hours;
        public final long minutes;
        public final long seconds;
        public final long miliseconds;

        public TimeData(long hours, long minutes, long seconds) {
            hours = MathUtil.clamp(hours, 0L, Long.MAX_VALUE);
            minutes = MathUtil.clamp(minutes, 0L, 59L);
            seconds = MathUtil.clamp(seconds, 0L, 59L);
            this.hours = hours;
            this.minutes = minutes;
            this.seconds = seconds;
            this.miliseconds = TimeUtil.getDuration(hours, minutes, seconds);
        }

        public TimeData(long milliseconds) {
            this.miliseconds = MathUtil.clamp(milliseconds, 0L, Long.MAX_VALUE);
            TimeData time = TimeUtil.separateDuration(this.miliseconds);
            this.hours = time.hours;
            this.minutes = time.minutes;
            this.seconds = time.seconds;
        }

        public String toString() {
            String text = "";
            if (this.hours > 0L) {
                text = text + Long.toString(this.hours) + "h ";
            }
            if (this.minutes > 0L) {
                text = text + Long.toString(this.minutes) + "m ";
            }
            if (text == "" || this.seconds > 0L) {
                text = text + Long.toString(this.seconds) + "s";
            }
            return text;
        }
    }
}

