/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import io.github.lightman314.lightmanscurrency.BlockItemPair;
import io.github.lightman314.lightmanscurrency.IItemSet;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BlockItemSet<T>
implements IItemSet<T> {
    Map<T, BlockItemPair> set = new HashMap<T, BlockItemPair>();

    public List<BlockItemPair> getAll() {
        ArrayList<BlockItemPair> values = new ArrayList<BlockItemPair>();
        this.set.forEach((key, blockItemPair) -> values.add((BlockItemPair)blockItemPair));
        return values;
    }

    @Override
    public List<Item> getAllItems() {
        ArrayList<Item> values = new ArrayList<Item>();
        this.set.forEach((key, blockItemPair) -> values.add(blockItemPair.item));
        return values;
    }

    public BlockItemPair get(T key) {
        if (this.set.containsKey(key)) {
            return this.set.get(key);
        }
        return null;
    }

    public Block getBlock(T key) {
        BlockItemPair pair = this.get(key);
        if (pair != null) {
            return pair.block;
        }
        return Blocks.f_50016_;
    }

    @Override
    public Item getItem(T key) {
        BlockItemPair pair = this.get(key);
        if (pair != null) {
            return pair.item;
        }
        return Items.f_41852_;
    }

    public void add(T key, BlockItemPair block) {
        if (this.set.containsKey(key)) {
            LightmansCurrency.LogWarning("BlockItemSet already contains an entry for " + key.toString() + ".");
            return;
        }
        this.set.put(key, block);
    }
}

