/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomCreativeTab
extends CreativeModeTab {
    private final ItemSorter itemSorter;
    Supplier<ItemLike> iconItem;

    public CustomCreativeTab(String label, Supplier<ItemLike> iconItem) {
        super(label);
        this.iconItem = iconItem;
        this.itemSorter = new ItemSorter();
    }

    public ItemStack m_6976_() {
        if (this.iconItem != null) {
            return new ItemStack(this.iconItem.get());
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6151_(NonNullList<ItemStack> items) {
        super.m_6151_(items);
        Collections.sort(items, this.itemSorter);
    }

    public void addToSortingList(List<ItemLike> extras) {
        this.itemSorter.addToSortingList(extras);
    }

    public void initSortingList(List<ItemLike> defaultList) {
        this.itemSorter.initSortingList(defaultList);
    }

    private static class ItemSorter
    implements Comparator<ItemStack> {
        private List<ItemLike> sortList = null;

        public void initSortingList(List<ItemLike> sortList) {
            if (this.sortList == null) {
                this.sortList = sortList;
            } else {
                List<ItemLike> copyList = this.sortList;
                this.sortList = sortList;
                for (int i = 0; i < copyList.size(); ++i) {
                    this.sortList.add(copyList.get(i));
                }
            }
        }

        public void addToSortingList(List<ItemLike> extras) {
            if (this.sortList == null) {
                LightmansCurrency.LogWarning("Sorting list has not been initialized. Adding temporarily, until the official init arrives.");
                this.sortList = extras;
            }
            for (int i = 0; i < extras.size(); ++i) {
                this.sortList.add(extras.get(i));
            }
            LightmansCurrency.LogInfo("Added " + extras.size() + " items to the creative tab sorting list.");
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            Item item1 = o1.m_41720_();
            Item item2 = o2.m_41720_();
            if (this.sortList == null) {
                LightmansCurrency.LogWarning("No sortlist defined for this CurrencyGroup.");
                return 0;
            }
            if (this.sortList.contains(item1) && !this.sortList.contains(item2)) {
                return -1;
            }
            if (!this.sortList.contains(item1) && this.sortList.contains(item2)) {
                return 1;
            }
            if (this.sortListContains(item1) && this.sortListContains(item2)) {
                int index2;
                int index1 = this.indexOf(item1);
                if (index1 < (index2 = this.indexOf(item2))) {
                    return -1;
                }
                if (index1 > index2) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }

        private boolean sortListContains(Item item) {
            return this.indexOf(item) >= 0;
        }

        private int indexOf(Item item) {
            for (int i = 0; i < this.sortList.size(); ++i) {
                if (item != this.sortList.get(i).m_5456_()) continue;
                return i;
            }
            return -1;
        }
    }
}

