/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.CustomCreativeTab;
import io.github.lightman314.lightmanscurrency.Reference;
import io.github.lightman314.lightmanscurrency.client.ClientModEvents;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.ItemTraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.integration.Curios;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.config.MessageSyncConfig;
import io.github.lightman314.lightmanscurrency.network.message.time.MessageSyncClientTime;
import io.github.lightman314.lightmanscurrency.proxy.ClientProxy;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerBlacklist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TimedSale;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="lightmanscurrency")
public class LightmansCurrency {
    public static final String MODID = "lightmanscurrency";
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static boolean curiosLoaded = false;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomCreativeTab COIN_GROUP = new CustomCreativeTab("lightmanscurrency.coins", () -> ModBlocks.COINPILE_GOLD);
    public static final CustomCreativeTab MACHINE_GROUP = new CustomCreativeTab("lightmanscurrency.machines", () -> ModBlocks.MACHINE_ATM);
    public static final CustomCreativeTab TRADING_GROUP = new CustomCreativeTab("lightmanscurrency.trading", () -> ModBlocks.DISPLAY_CASE);

    public LightmansCurrency() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEnqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new RegisterClientModEvents());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        curiosLoaded = ModList.get().isLoaded("curios");
    }

    public static boolean isCuriosLoaded() {
        return curiosLoaded;
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        LightmansCurrencyPacketHandler.init();
        MoneyUtil.init();
        TradingOffice.RegisterDataType(UniversalItemTraderData.TYPE, (Supplier<? extends UniversalTraderData>)((Supplier)() -> new UniversalItemTraderData()));
        ModGameRules.registerRules();
        WalletCapability.register();
        TradeRule.RegisterDeserializer(PlayerWhitelist.TYPE, (Supplier<TradeRule>)((Supplier)() -> new PlayerWhitelist()));
        TradeRule.RegisterDeserializer(PlayerBlacklist.TYPE, (Supplier<TradeRule>)((Supplier)() -> new PlayerBlacklist()));
        TradeRule.RegisterDeserializer(PlayerTradeLimit.TYPE, (Supplier<TradeRule>)((Supplier)() -> new PlayerTradeLimit()));
        TradeRule.RegisterDeserializer(PlayerDiscounts.TYPE, (Supplier<TradeRule>)((Supplier)() -> new PlayerDiscounts()));
        TradeRule.RegisterDeserializer(TimedSale.TYPE, (Supplier<TradeRule>)((Supplier)() -> new TimedSale()));
        TraderSearchFilter.addFilter(new ItemTraderSearchFilter());
        COIN_GROUP.initSortingList(Arrays.asList(new ItemLike[]{ModItems.COIN_COPPER, ModItems.COIN_IRON, ModItems.COIN_GOLD, ModItems.COIN_EMERALD, ModItems.COIN_DIAMOND, ModItems.COIN_NETHERITE, ModBlocks.COINPILE_COPPER.item, ModBlocks.COINPILE_IRON.item, ModBlocks.COINPILE_GOLD.item, ModBlocks.COINPILE_EMERALD.item, ModBlocks.COINPILE_DIAMOND, ModBlocks.COINPILE_NETHERITE.item, ModBlocks.COINBLOCK_COPPER.item, ModBlocks.COINBLOCK_IRON.item, ModBlocks.COINBLOCK_GOLD.item, ModBlocks.COINBLOCK_EMERALD.item, ModBlocks.COINBLOCK_DIAMOND.item, ModBlocks.COINBLOCK_NETHERITE.item, ModItems.TRADING_CORE, ModItems.TICKET, ModItems.TICKET_MASTER, ModItems.WALLET_COPPER, ModItems.WALLET_IRON, ModItems.WALLET_GOLD, ModItems.WALLET_EMERALD, ModItems.WALLET_DIAMOND, ModItems.WALLET_NETHERITE}));
        MACHINE_GROUP.initSortingList(Arrays.asList(ModBlocks.MACHINE_ATM, ModBlocks.MACHINE_MINT, ModBlocks.CASH_REGISTER, ModItems.PORTABLE_TERMINAL, ModBlocks.TERMINAL, ModBlocks.PAYGATE, ModBlocks.TICKET_MACHINE));
        TRADING_GROUP.initSortingList(Arrays.asList(ModBlocks.SHELF.getItem(Reference.WoodType.OAK), ModBlocks.SHELF.getItem(Reference.WoodType.BIRCH), ModBlocks.SHELF.getItem(Reference.WoodType.SPRUCE), ModBlocks.SHELF.getItem(Reference.WoodType.JUNGLE), ModBlocks.SHELF.getItem(Reference.WoodType.ACACIA), ModBlocks.SHELF.getItem(Reference.WoodType.DARK_OAK), ModBlocks.SHELF.getItem(Reference.WoodType.CRIMSON), ModBlocks.SHELF.getItem(Reference.WoodType.WARPED), ModBlocks.DISPLAY_CASE, ModBlocks.ARMOR_DISPLAY, ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.OAK), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.BIRCH), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.SPRUCE), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.JUNGLE), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.ACACIA), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.DARK_OAK), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.CRIMSON), ModBlocks.CARD_DISPLAY.getItem(Reference.WoodType.WARPED), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.WHITE), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.ORANGE), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.MAGENTA), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.LIGHTBLUE), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.YELLOW), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.LIME), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.PINK), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.GRAY), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.LIGHTGRAY), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.CYAN), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.PURPLE), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.BLUE), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.BROWN), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.GREEN), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.RED), ModBlocks.VENDING_MACHINE1.getItem(Reference.Colors.BLACK), ModBlocks.FREEZER, ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.WHITE), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.ORANGE), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.MAGENTA), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.LIGHTBLUE), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.YELLOW), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.LIME), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.PINK), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.GRAY), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.LIGHTGRAY), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.CYAN), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.PURPLE), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.BLUE), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.BROWN), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.GREEN), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.RED), ModBlocks.VENDING_MACHINE2.getItem(Reference.Colors.BLACK), ModBlocks.TICKET_KIOSK, ModBlocks.ITEM_TRADER_SERVER_SMALL, ModBlocks.ITEM_TRADER_SERVER_MEDIUM, ModBlocks.ITEM_TRADER_SERVER_LARGE, ModBlocks.ITEM_TRADER_SERVER_EXTRA_LARGE));
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        if (!curiosLoaded) {
            return;
        }
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        PROXY.setupClient();
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getModId().equals(MODID) && event.getConfig().getSpec() == Config.commonSpec) {
            Config.syncConfig();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PacketDistributor.PacketTarget target = LightmansCurrencyPacketHandler.getTarget(event.getPlayer());
        LightmansCurrency.LogDebug("Player has logged in to the server. Sending config syncronization message.");
        LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageSyncConfig(Config.getSyncData()));
        LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageSyncClientTime());
        LightmansCurrencyPacketHandler.instance.send(target, (Object)TradingOffice.getAdminSyncMessage());
    }

    public static ItemStack getWalletStack(Player player) {
        AtomicReference<ItemStack> wallet = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        if (curiosLoaded) {
            wallet.set(Curios.getWalletStack(player));
        } else {
            WalletCapability.getWalletHandler((Entity)player).ifPresent(walletHandler -> wallet.set(walletHandler.getWallet()));
        }
        return wallet.get();
    }

    public static void LogDebug(String message) {
        LOGGER.debug(message);
    }

    public static void LogInfo(String message) {
        if ((Integer)Config.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message);
        } else {
            LOGGER.info(message);
        }
    }

    public static void LogWarning(String message) {
        if ((Integer)Config.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message);
        } else {
            LOGGER.warn(message);
        }
    }

    public static void LogError(String message, Object ... objects) {
        if ((Integer)Config.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message, objects);
        } else {
            LOGGER.error(message, objects);
        }
    }

    public static void LogError(String message) {
        if ((Integer)Config.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message);
        } else {
            LOGGER.error(message);
        }
    }

    private static class RegisterClientModEvents
    implements DistExecutor.SafeRunnable {
        private static final long serialVersionUID = -7312388538529889615L;

        private RegisterClientModEvents() {
        }

        public void run() {
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ClientModEvents());
        }
    }
}

