/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CashRegisterBlockEntity
extends BlockEntity {
    List<BlockPos> positions = new ArrayList<BlockPos>();

    public CashRegisterBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.CASH_REGISTER, pos, state);
    }

    public void loadDataFromItems(CompoundTag itemTag) {
        if (itemTag == null) {
            return;
        }
        this.readPositions(itemTag);
    }

    public void OpenContainer(Player player) {
        this.OpenContainer(-1, 0, 1, player);
    }

    public void OpenContainer(int oldIndex, int newIndex, int direction, Player player) {
        direction = direction == 0 ? 1 : MathUtil.clamp(direction, -1, 1);
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.positions.size() <= 0) {
            LightmansCurrency.LogInfo("Cash Register has no Trader Positions stored. Unable to open container.");
            return;
        }
        if (newIndex < 0) {
            newIndex = this.positions.size() - 1;
        } else if (newIndex >= this.positions.size()) {
            newIndex = 0;
        }
        if (newIndex == oldIndex) {
            LightmansCurrency.LogInfo("Trader Index is the same as the original index.");
            return;
        }
        TraderBlockEntity tileEntity = this.getTrader(newIndex);
        if (tileEntity != null) {
            tileEntity.openCashRegisterTradeMenu(player, this);
            return;
        }
        if (oldIndex < 0) {
            oldIndex = newIndex;
        }
        this.OpenContainer(oldIndex, newIndex + direction, direction, player);
    }

    public void OpenEditorScreen() {
    }

    public TraderBlockEntity getTrader(int index) {
        if (index < 0 || index >= this.positions.size()) {
            return null;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.positions.get(index));
        if (tileEntity instanceof TraderBlockEntity) {
            return (TraderBlockEntity)tileEntity;
        }
        return null;
    }

    public int getTraderIndex(TraderBlockEntity tileEntity) {
        for (int i = 0; i < this.positions.size(); ++i) {
            if (!this.positions.get(i).equals((Object)tileEntity.m_58899_())) continue;
            return i;
        }
        return -1;
    }

    public int getPairedTraderSize() {
        return this.positions.size();
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        ListTag storageList = new ListTag();
        for (int i = 0; i < this.positions.size(); ++i) {
            CompoundTag thisEntry = new CompoundTag();
            BlockPos thisPos = this.positions.get(i);
            thisEntry.m_128405_("x", thisPos.m_123341_());
            thisEntry.m_128405_("y", thisPos.m_123342_());
            thisEntry.m_128405_("z", thisPos.m_123343_());
            storageList.add((Object)thisEntry);
        }
        if (storageList.size() > 0) {
            compound.m_128365_("TraderPos", (Tag)storageList);
        }
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.readPositions(compound);
        super.m_142466_(compound);
    }

    private void readPositions(CompoundTag compound) {
        if (compound.m_128441_("TraderPos")) {
            this.positions = new ArrayList<BlockPos>();
            ListTag storageList = compound.m_128437_("TraderPos", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundTag thisEntry = storageList.m_128728_(i);
                if (!thisEntry.m_128441_("x") || !thisEntry.m_128441_("y") || !thisEntry.m_128441_("z")) continue;
                BlockPos thisPos = new BlockPos(thisEntry.m_128451_("x"), thisEntry.m_128451_("y"), thisEntry.m_128451_("z"));
                this.positions.add(thisPos);
            }
        }
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), 0, this.m_6945_(new CompoundTag()));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.m_142466_(compound);
    }
}

