/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.MessageRequestNBT;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class CoinJarBlockEntity
extends TickableBlockEntity {
    public static int COIN_LIMIT = 64;
    List<ItemStack> storage = new ArrayList<ItemStack>();
    private boolean firstTick = true;

    public List<ItemStack> getStorage() {
        return this.storage;
    }

    public CoinJarBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.COIN_JAR, pos, state);
    }

    public boolean addCoin(ItemStack coin) {
        if (this.getCurrentCount() >= COIN_LIMIT) {
            return false;
        }
        if (!MoneyUtil.isCoin(coin, false)) {
            return false;
        }
        boolean foundStack = false;
        for (int i = 0; i < this.storage.size() && !foundStack; ++i) {
            if (!InventoryUtil.ItemMatches(coin, this.storage.get(i)) || this.storage.get(i).m_41613_() >= this.storage.get(i).m_41741_()) continue;
            this.storage.get(i).m_41769_(1);
            foundStack = true;
        }
        if (!foundStack) {
            ItemStack newCoin = coin.m_41777_();
            newCoin.m_41764_(1);
            this.storage.add(newCoin);
        }
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeStorage(new CompoundTag());
            TileEntityUtil.sendUpdatePacket(this, super.m_6945_(compound));
        }
        return true;
    }

    protected int getCurrentCount() {
        int count = 0;
        for (int i = 0; i < this.storage.size(); ++i) {
            count += this.storage.get(i).m_41613_();
        }
        return count;
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        this.writeStorage(compound);
        return super.m_6945_(compound);
    }

    protected CompoundTag writeStorage(CompoundTag compound) {
        ListTag storageList = new ListTag();
        for (int i = 0; i < this.storage.size(); ++i) {
            storageList.add((Object)this.storage.get(i).m_41739_(new CompoundTag()));
        }
        compound.m_128365_("Coins", (Tag)storageList);
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("Coins")) {
            this.storage = new ArrayList<ItemStack>();
            ListTag storageList = compound.m_128437_("Coins", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundTag thisItem = storageList.m_128728_(i);
                this.storage.add(ItemStack.m_41712_((CompoundTag)thisItem));
            }
        }
        super.m_142466_(compound);
    }

    @Override
    public void clientTick() {
        if (this.firstTick) {
            this.firstTick = false;
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRequestNBT(this));
        }
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), 0, this.m_6945_(new CompoundTag()));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.m_142466_(compound);
    }

    public void writeItemTag(ItemStack item) {
        CompoundTag compound = item.m_41784_();
        compound.m_128365_("JarData", (Tag)this.writeStorage(new CompoundTag()));
    }

    public void readItemTag(ItemStack item) {
        CompoundTag jarData;
        CompoundTag compound;
        if (item.m_41782_() && (compound = item.m_41783_()).m_128425_("JarData", 10) && (jarData = compound.m_128469_("JarData")).m_128441_("Coins")) {
            this.storage = new ArrayList<ItemStack>();
            ListTag storageList = jarData.m_128437_("Coins", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundTag thisItem = storageList.m_128728_(i);
                this.storage.add(ItemStack.m_41712_((CompoundTag)thisItem));
            }
        }
    }
}

