/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.templates;

import io.github.lightman314.lightmanscurrency.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.blocks.templates.interfaces.ITallBlock;
import io.github.lightman314.lightmanscurrency.blocks.util.LazyShapes;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TallRotatableBlock
extends RotatableBlock
implements ITallBlock {
    protected static final BooleanProperty ISBOTTOM = BlockStateProperties.f_61427_;
    private final BiFunction<Direction, Boolean, VoxelShape> shape;

    protected TallRotatableBlock(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.TALL_BOX_SHAPE_T);
    }

    protected TallRotatableBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        this(properties, LazyShapes.lazyTallSingleShape(shape));
    }

    protected TallRotatableBlock(BlockBehaviour.Properties properties, BiFunction<Direction, Boolean, VoxelShape> shape) {
        super(properties);
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape.apply(this.getFacing(state), this.getIsBottom(state));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ISBOTTOM});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true));
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        if (level.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_50016_) {
            level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
        } else {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
            if (player instanceof Player) {
                ItemStack giveStack = stack.m_41777_();
                giveStack.m_41764_(1);
                ((Player)player).m_150109_().m_36054_(giveStack);
            }
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && ((Boolean)stateIn.m_61143_((Property)ISBOTTOM)).booleanValue() || facing == Direction.DOWN && !((Boolean)stateIn.m_61143_((Property)ISBOTTOM)).booleanValue()) {
            if (facingState.m_60713_((Block)this)) {
                return stateIn;
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public boolean getIsBottom(BlockState state) {
        return (Boolean)state.m_61143_((Property)ISBOTTOM);
    }
}

