/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.traderblocks;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.templates.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.blocks.util.LazyShapes;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShelfBlock
extends TraderBlockRotatable
implements IItemTraderBlock {
    public static final int TRADECOUNT = 1;
    private static final VoxelShape SHAPE_NORTH = ShelfBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    private static final VoxelShape SHAPE_SOUTH = ShelfBlock.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = ShelfBlock.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = ShelfBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties, LazyShapes.lazyDirectionalShape(SHAPE_NORTH, SHAPE_EAST, SHAPE_SOUTH, SHAPE_WEST));
    }

    @Override
    public BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new ItemTraderBlockEntity(pos, state, 1);
    }

    @Override
    public BlockEntityType<?> traderType() {
        return ModBlockEntities.ITEM_TRADER;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isBlock) {
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>(1);
        Direction facing = this.getFacing(state);
        Vector3f forward = IRotatableBlock.getForwardVect(facing);
        Vector3f right = IRotatableBlock.getRightVect(facing);
        Vector3f up = Vector3f.f_122225_;
        Vector3f offset = IRotatableBlock.getOffsetVect(facing);
        if (tradeSlot == 0) {
            float distance;
            Vector3f firstPosition = MathUtil.VectorAdd(offset, MathUtil.VectorMult(right, 0.5f), MathUtil.VectorMult(forward, 0.90625f), MathUtil.VectorMult(up, 0.5625f));
            posList.add(firstPosition);
            float f = distance = isBlock ? -3.2f : -1.0f;
            while (distance >= -3.0f) {
                posList.add(MathUtil.VectorAdd(firstPosition, MathUtil.VectorMult(forward, distance / 16.0f)));
                distance -= isBlock ? 3.2f : 1.0f;
            }
        }
        return posList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, BlockState state, boolean isBlock) {
        ArrayList<Quaternion> rotation = new ArrayList<Quaternion>();
        int facing = this.getFacing(state).m_122416_();
        rotation.add(Vector3f.f_122225_.m_122240_((float)facing * -90.0f));
        return rotation;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vector3f GetStackRenderScale(int tradeSlot, BlockState state, boolean isBlock) {
        return new Vector3f(0.875f, 0.875f, 0.875f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return 1;
    }
}

