/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemTraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ItemTradeButton;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.ItemTraderUtil;
import io.github.lightman314.lightmanscurrency.menus.ItemTraderMenuCR;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.cashregister.MessageCRNextTrader;
import io.github.lightman314.lightmanscurrency.network.message.cashregister.MessageCRSkipTo;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageExecuteTrade;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ItemTraderScreenCR
extends AbstractContainerScreen<ItemTraderMenuCR> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/trader.png");
    public static final int TRADEBUTTON_SPACER = 4;
    public static final int TRADEBUTTON_VERTICALITY = 22;
    public static final int TRADEBUTTON_HORIZ_SPACER = 6;
    public static final int TRADEBUTTON_HORIZONTAL = 85;
    Button buttonCollectMoney;
    Button buttonLeft;
    Button buttonRight;
    EditBox pageInput;
    Button buttonSkipToPage;
    protected List<ItemTradeButton> tradeButtons = new ArrayList<ItemTradeButton>();

    public ItemTraderScreenCR(ItemTraderMenuCR container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97727_ = 133 + ItemTraderUtil.getTradeDisplayHeight(((ItemTraderMenuCR)this.f_97732_).tileEntity);
        this.f_97726_ = ItemTraderUtil.getWidth(((ItemTraderMenuCR)this.f_97732_).tileEntity);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        ItemTraderScreen.drawTraderBackground(poseStack, (Screen)this, this.f_97732_, this.f_96541_, this.f_97726_, this.f_97727_, ((ItemTraderMenuCR)this.f_97732_).tileEntity);
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        ItemTraderScreen.drawTraderForeground(matrix, this.f_96547_, ((ItemTraderMenuCR)this.f_97732_).tileEntity, this.f_97727_, (Component)new TranslatableComponent("gui.lightmanscurrency.trading.title", new Object[]{((ItemTraderMenuCR)this.f_97732_).tileEntity.getName(), new TranslatableComponent("gui.lightmanscurrency.trading.list", new Object[]{((ItemTraderMenuCR)this.f_97732_).getThisIndex() + 1, ((ItemTraderMenuCR)this.f_97732_).getTotalCount()})}), this.f_169604_, (Component)new TranslatableComponent("tooltip.lightmanscurrency.credit", new Object[]{MoneyUtil.getStringOfValue(((ItemTraderMenuCR)this.f_97732_).GetCoinValue())}));
    }

    protected void m_7856_() {
        super.m_7856_();
        int tradeOffset = ItemTraderUtil.getTradeDisplayOffset(((ItemTraderMenuCR)this.f_97732_).tileEntity);
        if (((ItemTraderMenuCR)this.f_97732_).cashRegister.getPairedTraderSize() > 1) {
            this.buttonLeft = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + tradeOffset - 20, this.f_97736_, this::PressArrowButton, GUI_TEXTURE, 176, 16));
            this.buttonRight = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + this.f_97726_ - tradeOffset, this.f_97736_, this::PressArrowButton, GUI_TEXTURE, 192, 16));
            this.pageInput = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_97735_ + 50, this.f_97736_ - 19, this.f_97726_ - 120, 18, (Component)new TextComponent("")));
            this.pageInput.m_94199_(9);
            this.pageInput.m_94144_(String.valueOf(((ItemTraderMenuCR)this.f_97732_).getThisIndex() + 1));
            this.buttonSkipToPage = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + this.f_97726_ - 68, this.f_97736_ - 20, this::PressPageSkipButton, GUI_TEXTURE, 192, 16));
            this.buttonSkipToPage.f_93623_ = false;
        }
        if (((ItemTraderMenuCR)this.f_97732_).isOwner()) {
            this.buttonCollectMoney = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ - 20 + tradeOffset, this.f_97736_ + 20, this::PressCollectionButton, GUI_TEXTURE, 192, 0));
            this.buttonCollectMoney.f_93623_ = false;
        }
        this.initTradeButtons();
    }

    protected void initTradeButtons() {
        int tradeCount = ((ItemTraderMenuCR)this.f_97732_).getTradeCount();
        for (int i = 0; i < tradeCount; ++i) {
            this.tradeButtons.add((ItemTradeButton)this.m_142416_((GuiEventListener)new ItemTradeButton(this.f_97735_ + ItemTraderUtil.getButtonPosX(((ItemTraderMenuCR)this.f_97732_).tileEntity, i), this.f_97736_ + ItemTraderUtil.getButtonPosY(((ItemTraderMenuCR)this.f_97732_).tileEntity, i), this::PressTradeButton, i, (Screen)this, this.f_96547_, (Supplier<IItemTrader>)((Supplier)() -> ((ItemTraderMenuCR)this.f_97732_).tileEntity), (Supplier<Long>)((Supplier)((ItemTraderMenuCR)this.f_97732_)::GetCoinValue), (Supplier<Container>)((Supplier)((ItemTraderMenuCR)this.f_97732_)::GetItemInventory))));
        }
    }

    public static int tradeWindowWidth(int tradeCount) {
        return 0;
    }

    public void m_181908_() {
        ((ItemTraderMenuCR)this.f_97732_).tick();
        if (this.buttonCollectMoney != null) {
            boolean bl = this.buttonCollectMoney.f_93623_ = ((ItemTraderMenuCR)this.f_97732_).tileEntity.getStoredMoney().getRawValue() > 0L;
            if (!this.buttonCollectMoney.f_93623_) {
                boolean bl2 = this.buttonCollectMoney.f_93624_ = !((ItemTraderMenuCR)this.f_97732_).tileEntity.isCreative();
            }
        }
        if (this.buttonSkipToPage != null) {
            this.buttonSkipToPage.f_93623_ = this.getPageInput() >= 0 && this.getPageInput() < ((ItemTraderMenuCR)this.f_97732_).getTotalCount() && this.getPageInput() != ((ItemTraderMenuCR)this.f_97732_).getThisIndex();
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        if (this.pageInput != null) {
            this.pageInput.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.buttonCollectMoney != null && this.buttonCollectMoney.f_93623_ && this.buttonCollectMoney.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.collectcoins", new Object[]{((ItemTraderMenuCR)this.f_97732_).tileEntity.getStoredMoney().getString()}), mouseX, mouseY);
        }
        for (int i = 0; i < this.tradeButtons.size(); ++i) {
            this.tradeButtons.get(i).tryRenderTooltip(matrixStack, (Screen)this, ((ItemTraderMenuCR)this.f_97732_).tileEntity, false, mouseX, mouseY);
        }
    }

    private void PressTradeButton(Button button) {
        int tradeIndex = 0;
        if (this.tradeButtons.contains(button)) {
            tradeIndex = this.tradeButtons.indexOf(button);
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageExecuteTrade(tradeIndex));
    }

    private void PressCollectionButton(Button button) {
        if (((ItemTraderMenuCR)this.f_97732_).isOwner()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCollectCoins());
        } else {
            LightmansCurrency.LogWarning("Non-owner attempted to collect the stored money.");
        }
    }

    private void PressArrowButton(Button button) {
        int direction = 1;
        if (button == this.buttonLeft) {
            direction = -1;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCRNextTrader(direction));
    }

    private void PressPageSkipButton(Button button) {
        int page = this.getPageInput();
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCRSkipTo(page));
    }

    private int getPageInput() {
        if (this.pageInput != null) {
            return TextInputUtil.getIntegerValue(this.pageInput) - 1;
        }
        return 0;
    }
}

