/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.menus.PaygateMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.paygate.MessageActivatePaygate;
import io.github.lightman314.lightmanscurrency.network.message.paygate.MessageSetPaygateTicket;
import io.github.lightman314.lightmanscurrency.network.message.paygate.MessageUpdatePaygateData;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageCollectCoins;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PaygateScreen
extends AbstractContainerScreen<PaygateMenu>
implements CoinValueInput.ICoinValueInput {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/paygate.png");
    private static final int GUI_HEIGHT = 151;
    CoinValueInput priceInput;
    EditBox durationInput;
    private IconButton buttonCollectMoney;
    private IconButton buttonPay;
    private IconButton buttonSetTicket;

    public PaygateScreen(PaygateMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97727_ = ((PaygateMenu)this.f_97732_).isOwner() ? 220 : 151;
        this.f_97726_ = 176;
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (((PaygateMenu)this.f_97732_).isOwner()) {
            this.m_93228_(poseStack, this.f_97735_, this.f_97736_ + ((PaygateMenu)this.f_97732_).priceInputOffset, 0, 0, this.f_97726_, this.f_97727_ - ((PaygateMenu)this.f_97732_).priceInputOffset);
        } else {
            this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        }
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, this.f_96539_, 8.0f, 6.0f + (float)((PaygateMenu)this.f_97732_).priceInputOffset, 0x404040);
        this.f_96547_.m_92889_(poseStack, this.f_169604_, 8.0f, (float)(this.f_97727_ - 94), 0x404040);
        this.f_96547_.m_92883_(poseStack, new TranslatableComponent("tooltip.lightmanscurrency.paygate.price", new Object[]{((PaygateMenu)this.f_97732_).tileEntity.getPrice().getString()}).getString(), 8.0f, 16.0f + (float)((PaygateMenu)this.f_97732_).priceInputOffset, 0);
        this.f_96547_.m_92883_(poseStack, new TranslatableComponent("tooltip.lightmanscurrency.paygate.duration", new Object[]{((PaygateMenu)this.f_97732_).tileEntity.getDuration()}).getString(), 8.0f, 25.0f + (float)((PaygateMenu)this.f_97732_).priceInputOffset, 0);
        this.f_96547_.m_92883_(poseStack, new TranslatableComponent("tooltip.lightmanscurrency.credit", new Object[]{MoneyUtil.getStringOfValue(((PaygateMenu)this.f_97732_).GetCoinValue())}).getString(), 80.0f, (float)this.f_97727_ - 124.0f, 0x404040);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (((PaygateMenu)this.f_97732_).isOwner()) {
            this.priceInput = (CoinValueInput)this.m_142416_((GuiEventListener)new CoinValueInput(this.f_97736_, (Component)new TranslatableComponent("gui.lightmanscurrency.changeprice"), ((PaygateMenu)this.f_97732_).tileEntity.getPrice(), this));
            this.priceInput.init();
            this.durationInput = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_97735_ + 8, this.f_97736_ + 35 + ((PaygateMenu)this.f_97732_).priceInputOffset, 30, 18, (Component)new TextComponent("")));
            this.durationInput.m_94144_(String.valueOf(((PaygateMenu)this.f_97732_).tileEntity.getDuration()));
            this.durationInput.m_94199_(3);
            this.buttonCollectMoney = (IconButton)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ - 20, this.f_97736_ + ((PaygateMenu)this.f_97732_).priceInputOffset, this::PressCollectionButton, GUI_TEXTURE, this.f_97726_ + 16, 0));
            this.buttonCollectMoney.f_93623_ = false;
            this.buttonSetTicket = (IconButton)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 40, this.f_97736_ + 34 + ((PaygateMenu)this.f_97732_).priceInputOffset, this::PressTicketButton, GUI_TEXTURE, this.f_97726_ + 32, 0));
            this.buttonSetTicket.f_93624_ = false;
        }
        this.buttonPay = (IconButton)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + 149, this.f_97736_ + 6 + ((PaygateMenu)this.f_97732_).priceInputOffset, this::PressActivateButton, GUI_TEXTURE, this.f_97726_, 0));
        this.buttonPay.f_93623_ = false;
        this.m_96624_();
    }

    public void m_181908_() {
        if (this.priceInput != null) {
            this.priceInput.tick();
        }
        if (this.durationInput != null) {
            this.durationInput.m_94120_();
            int duration = this.getDuration();
            if (duration != ((PaygateMenu)this.f_97732_).tileEntity.getDuration()) {
                LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdatePaygateData(((PaygateMenu)this.f_97732_).tileEntity.m_58899_(), this.priceInput.getCoinValue().copy(), duration));
                ((PaygateMenu)this.f_97732_).tileEntity.setDuration(duration);
                if (this.durationInput.m_94155_() != "") {
                    this.durationInput.m_94144_(String.valueOf(((PaygateMenu)this.f_97732_).tileEntity.getDuration()));
                }
            }
        }
        if (this.buttonCollectMoney != null) {
            boolean bl = this.buttonCollectMoney.f_93623_ = ((PaygateMenu)this.f_97732_).tileEntity.getStoredMoney().getRawValue() > 0L;
        }
        if (this.buttonSetTicket != null) {
            this.buttonSetTicket.f_93624_ = ((PaygateMenu)this.f_97732_).HasMasterTicket() && !((PaygateMenu)this.f_97732_).tileEntity.validTicket(((PaygateMenu)this.f_97732_).GetTicketID());
        }
        this.buttonPay.f_93623_ = ((PaygateMenu)this.f_97732_).CanActivate();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        if (this.priceInput != null) {
            this.priceInput.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.durationInput != null) {
            this.durationInput.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.m_7025_(matrixStack, mouseX, mouseY);
        if (this.buttonPay != null && this.buttonPay.f_93623_ && this.buttonPay.m_5953_(mouseX, mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.paybutton"), mouseX, mouseY);
        } else if (this.buttonCollectMoney != null && this.buttonCollectMoney.f_93623_ && this.buttonCollectMoney.m_5953_(mouseX, mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.collectcoins", new Object[]{((PaygateMenu)this.f_97732_).tileEntity.getStoredMoney().getString()}), mouseX, mouseY);
        } else if (this.buttonSetTicket != null && this.buttonSetTicket.f_93624_ && this.buttonSetTicket.m_5953_(mouseX, mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.paygate.setticket", new Object[]{((PaygateMenu)this.f_97732_).tileEntity.getStoredMoney()}), mouseX, mouseY);
        }
    }

    private void PressActivateButton(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageActivatePaygate());
    }

    private void PressCollectionButton(Button button) {
        if (((PaygateMenu)this.f_97732_).isOwner()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCollectCoins());
        }
    }

    private void PressTicketButton(Button button) {
        if (((PaygateMenu)this.f_97732_).isOwner()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetPaygateTicket(((PaygateMenu)this.f_97732_).tileEntity.m_58899_(), ((PaygateMenu)this.f_97732_).GetTicketID()));
        }
    }

    private int getDuration() {
        return MathUtil.clamp(TextInputUtil.getIntegerValue(this.durationInput), 1, 200);
    }

    @Override
    public <T extends GuiEventListener & Widget> T addCustomWidget(T widget) {
        return (T)this.m_142416_(widget);
    }

    @Override
    public int getWidth() {
        return this.f_96543_;
    }

    @Override
    public void OnCoinValueChanged(CoinValueInput input) {
        ((PaygateMenu)this.f_97732_).tileEntity.setPrice(input.getCoinValue());
        int duration = this.getDuration();
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdatePaygateData(((PaygateMenu)this.f_97732_).tileEntity.m_58899_(), this.priceInput.getCoinValue().copy(), duration));
    }

    @Override
    public Font getFont() {
        return this.f_96547_;
    }
}

