/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemTraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ItemTradeButton;
import io.github.lightman314.lightmanscurrency.common.ItemTraderUtil;
import io.github.lightman314.lightmanscurrency.menus.UniversalItemTraderMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageExecuteTrade;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageOpenStorage2;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class UniversalItemTraderScreen
extends AbstractContainerScreen<UniversalItemTraderMenu> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/trader.png");
    Button buttonShowStorage;
    Button buttonCollectMoney;
    Button buttonBack;
    protected List<ItemTradeButton> tradeButtons = new ArrayList<ItemTradeButton>();

    public UniversalItemTraderScreen(UniversalItemTraderMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97727_ = 133 + ItemTraderUtil.getTradeDisplayHeight(((UniversalItemTraderMenu)this.f_97732_).getData());
        this.f_97726_ = ItemTraderUtil.getWidth(((UniversalItemTraderMenu)this.f_97732_).getData());
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        ItemTraderScreen.drawTraderBackground(poseStack, (Screen)this, this.f_97732_, this.f_96541_, this.f_97726_, this.f_97727_, ((UniversalItemTraderMenu)this.f_97732_).getData());
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        ItemTraderScreen.drawTraderForeground(matrix, this.f_96547_, ((UniversalItemTraderMenu)this.f_97732_).getData(), this.f_97727_, ((UniversalItemTraderMenu)this.f_97732_).getData().getTitle(), this.f_169604_, (Component)new TranslatableComponent("tooltip.lightmanscurrency.credit", new Object[]{MoneyUtil.getStringOfValue(((UniversalItemTraderMenu)this.f_97732_).GetCoinValue())}));
    }

    protected void m_7856_() {
        super.m_7856_();
        int tradeOffset = ItemTraderUtil.getTradeDisplayOffset(((UniversalItemTraderMenu)this.f_97732_).getData());
        int inventoryOffset = ItemTraderUtil.getInventoryDisplayOffset(((UniversalItemTraderMenu)this.f_97732_).getData());
        this.buttonBack = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ - 20 + inventoryOffset, this.f_97736_ + this.f_97727_ - 20, this::PressBackButton, GUI_TEXTURE, 208, 0));
        if (((UniversalItemTraderMenu)this.f_97732_).hasPermissions()) {
            this.buttonShowStorage = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ - 20 + tradeOffset, this.f_97736_, this::PressStorageButton, GUI_TEXTURE, 176, 0));
            if (((UniversalItemTraderMenu)this.f_97732_).isOwner()) {
                this.buttonCollectMoney = (Button)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ - 20 + tradeOffset, this.f_97736_ + 20, this::PressCollectionButton, GUI_TEXTURE, 192, 0));
                this.buttonCollectMoney.f_93623_ = false;
            }
        }
        this.initTradeButtons();
    }

    protected void initTradeButtons() {
        int tradeCount = ((UniversalItemTraderMenu)this.f_97732_).getTradeCount();
        for (int i = 0; i < tradeCount; ++i) {
            this.tradeButtons.add((ItemTradeButton)this.m_142416_((GuiEventListener)new ItemTradeButton(this.f_97735_ + ItemTraderUtil.getButtonPosX(((UniversalItemTraderMenu)this.f_97732_).getData(), i), this.f_97736_ + ItemTraderUtil.getButtonPosY(((UniversalItemTraderMenu)this.f_97732_).getData(), i), this::PressTradeButton, i, (Screen)this, this.f_96547_, (Supplier<IItemTrader>)((Supplier)() -> ((UniversalItemTraderMenu)this.f_97732_).getData()), (Supplier<Long>)((Supplier)((UniversalItemTraderMenu)this.f_97732_)::GetCoinValue), (Supplier<Container>)((Supplier)((UniversalItemTraderMenu)this.f_97732_)::GetItemInventory))));
        }
    }

    public void m_181908_() {
        ((UniversalItemTraderMenu)this.f_97732_).tick();
        if (this.buttonCollectMoney != null) {
            boolean bl = this.buttonCollectMoney.f_93623_ = ((UniversalItemTraderMenu)this.f_97732_).getData().getStoredMoney().getRawValue() > 0L;
            if (!this.buttonCollectMoney.f_93623_) {
                this.buttonCollectMoney.f_93624_ = !((UniversalItemTraderMenu)this.f_97732_).getData().isCreative();
            }
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        if (this.buttonShowStorage != null && this.buttonShowStorage.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.openstorage"), mouseX, mouseY);
        } else if (this.buttonCollectMoney != null && this.buttonCollectMoney.f_93623_ && this.buttonCollectMoney.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.collectcoins", new Object[]{((UniversalItemTraderMenu)this.f_97732_).getData().getStoredMoney().getString()}), mouseX, mouseY);
        } else if (this.buttonBack != null && this.buttonBack.f_93623_ && this.buttonBack.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(matrixStack, (Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.universaltrader.back"), mouseX, mouseY);
        }
        for (int i = 0; i < this.tradeButtons.size(); ++i) {
            this.tradeButtons.get(i).tryRenderTooltip(matrixStack, (Screen)this, ((UniversalItemTraderMenu)this.f_97732_).getData(), false, mouseX, mouseY);
        }
    }

    private void PressStorageButton(Button button) {
        if (((UniversalItemTraderMenu)this.f_97732_).hasPermissions()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage2(((UniversalItemTraderMenu)this.f_97732_).getData().getTraderID()));
        } else {
            LightmansCurrency.LogInfo("Non-owner attempted to open the Trader's Storage.");
        }
    }

    private void PressCollectionButton(Button button) {
        if (((UniversalItemTraderMenu)this.f_97732_).isOwner()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCollectCoins());
        } else {
            LightmansCurrency.LogInfo("Non-owner attempted to collect the stored money.");
        }
    }

    private void PressTradeButton(Button button) {
        int tradeIndex = 0;
        if (this.tradeButtons.contains(button)) {
            tradeIndex = this.tradeButtons.indexOf(button);
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageExecuteTrade(tradeIndex));
    }

    private void PressBackButton(Button button) {
        this.f_96541_.m_91152_((Screen)new TradingTerminalScreen(((UniversalItemTraderMenu)this.f_97732_).player));
    }
}

