/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.blockentity.FreezerTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class FreezerTraderBlockEntityRenderer
implements BlockEntityRenderer<FreezerTraderBlockEntity> {
    public static final Item doorItem = ModItems.FREEZER_DOOR;

    public FreezerTraderBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FreezerTraderBlockEntity tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int lightLevel, int id) {
        for (int tradeSlot = 0; tradeSlot < tileEntity.getTradeCount() && tradeSlot < tileEntity.maxRenderIndex(); ++tradeSlot) {
            ItemTradeData trade = tileEntity.getTrade(tradeSlot);
            if (trade.getSellItem().m_41619_()) continue;
            ItemStack stack = trade.getSellItem();
            boolean isBlock = stack.m_41720_() instanceof BlockItem;
            if (isBlock && ((List)Config.CLIENT.renderBlocksAsItems.get()).contains(stack.m_41720_().getRegistryName().toString())) {
                isBlock = false;
            }
            List<Vector3f> positions = tileEntity.GetStackRenderPos(tradeSlot, isBlock);
            List<Quaternion> rotation = tileEntity.GetStackRenderRot(tradeSlot, partialTicks, isBlock);
            Vector3f scale = tileEntity.GetStackRenderScale(tradeSlot, isBlock);
            for (int pos = 0; pos < positions.size() && pos < tileEntity.getTradeStock(tradeSlot) && pos < ItemTraderBlockEntityRenderer.positionLimit(); ++pos) {
                poseStack.m_85836_();
                Vector3f position = positions.get(pos);
                poseStack.m_85837_((double)position.m_122239_(), (double)position.m_122260_(), (double)position.m_122269_());
                for (Quaternion rot : rotation) {
                    poseStack.m_85845_(rot);
                }
                poseStack.m_85841_(scale.m_122239_(), scale.m_122260_(), scale.m_122269_());
                Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, poseStack, bufferSource, id);
                poseStack.m_85849_();
            }
        }
        poseStack.m_85836_();
        Vector3f corner = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f right = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
        Block freezerBlock = tileEntity.m_58900_().m_60734_();
        Direction facing = Direction.SOUTH;
        if (freezerBlock instanceof IRotatableBlock) {
            IRotatableBlock block = (IRotatableBlock)freezerBlock;
            facing = block.getFacing(tileEntity.m_58900_());
            corner = IRotatableBlock.getOffsetVect(facing);
            right = IRotatableBlock.getRightVect(facing);
            forward = IRotatableBlock.getForwardVect(facing);
        }
        Vector3f hinge = MathUtil.VectorAdd(corner, MathUtil.VectorMult(right, 0.96875f), MathUtil.VectorMult(forward, 0.21875f));
        Quaternion rotation = Vector3f.f_122225_.m_122240_((float)facing.m_122416_() * -90.0f + 90.0f * tileEntity.getDoorAngle(partialTicks));
        poseStack.m_85837_((double)hinge.m_122239_(), (double)hinge.m_122260_(), (double)hinge.m_122269_());
        poseStack.m_85845_(rotation);
        ItemStack stack = new ItemStack((ItemLike)doorItem);
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, poseStack, bufferSource, id);
        poseStack.m_85849_();
    }
}

