/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.client.gui.components.EditBox;

public class TextInputUtil {
    private static final String INTEGER_WHITELIST = "0123456789";
    private static final String FLOAT_WHITELIST = "0123456789.";

    public static boolean isInteger(EditBox textInput) {
        if (textInput == null) {
            return false;
        }
        return TextInputUtil.isInteger(textInput.m_94155_());
    }

    public static boolean isInteger(String text) {
        if (text == null) {
            return false;
        }
        try {
            int n = Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static int getIntegerValue(EditBox textInput) {
        return TextInputUtil.getIntegerValue(textInput, 0);
    }

    public static int getIntegerValue(EditBox textInput, int defaultValue) {
        if (TextInputUtil.isInteger(textInput)) {
            return Integer.parseInt(textInput.m_94155_());
        }
        return defaultValue;
    }

    public static boolean isLong(EditBox textInput) {
        return TextInputUtil.isLong(textInput.m_94155_());
    }

    public static boolean isLong(String text) {
        if (text == null) {
            return false;
        }
        try {
            long l = Long.parseLong(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static long getLongValue(EditBox textInput) {
        return TextInputUtil.getLongValue(textInput, 0);
    }

    public static long getLongValue(EditBox textInput, int defaultValue) {
        if (TextInputUtil.isLong(textInput)) {
            return Long.parseLong(textInput.m_94155_());
        }
        return defaultValue;
    }

    public static void whitelistInteger(EditBox textInput) {
        TextInputUtil.whitelistText(textInput, INTEGER_WHITELIST);
    }

    public static void whitelistInteger(EditBox textInput, long minValue, long maxValue) {
        long currentValue;
        TextInputUtil.whitelistText(textInput, INTEGER_WHITELIST);
        if (textInput.m_94155_().length() > 0 && ((currentValue = TextInputUtil.getLongValue(textInput)) < minValue || currentValue > maxValue)) {
            currentValue = MathUtil.clamp(currentValue, minValue, maxValue);
            textInput.m_94144_(Long.toString(currentValue));
        }
    }

    public static void whitelistFloat(EditBox textInput) {
        TextInputUtil.whitelistText(textInput, FLOAT_WHITELIST);
    }

    public static void whitelistText(EditBox textInput, String allowedChars) {
        StringBuilder newText = new StringBuilder(textInput.m_94155_());
        for (int i = 0; i < newText.length(); ++i) {
            boolean allowed = false;
            for (int x = 0; x < allowedChars.length() && !allowed; ++x) {
                if (allowedChars.charAt(x) != newText.charAt(i)) continue;
                allowed = true;
            }
            if (allowed) continue;
            newText.deleteCharAt(i);
        }
        textInput.m_94144_(newText.toString());
    }
}

