/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.UniversalTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.events.UniversalTraderEvent;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.command.MessageSyncAdminList;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageInitializeClientTraders;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageRemoveClientTrader;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageUpdateClientData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="lightmanscurrency")
public class TradingOffice
extends SavedData {
    private static final Map<ResourceLocation, Supplier<? extends UniversalTraderData>> registeredDeserializers = Maps.newHashMap();
    private static final String DATA_NAME = "lightmanscurrency_trading_office";
    private static List<UUID> adminPlayers = new ArrayList<UUID>();
    private Map<UUID, UniversalTraderData> universalTraderMap = new HashMap<UUID, UniversalTraderData>();

    public TradingOffice() {
    }

    public TradingOffice(CompoundTag tag) {
        this.load(tag);
    }

    public static final void RegisterDataType(ResourceLocation key, Supplier<? extends UniversalTraderData> source) {
        if (registeredDeserializers.containsKey(key)) {
            LightmansCurrency.LogError("A universal trader type of key " + key + " has already been registered.");
            return;
        }
        registeredDeserializers.put(key, source);
    }

    public static UniversalTraderData Deserialize(CompoundTag compound) {
        ResourceLocation thisType = new ResourceLocation(compound.m_128461_("type"));
        if (registeredDeserializers.containsKey(thisType)) {
            UniversalTraderData data = (UniversalTraderData)registeredDeserializers.get(thisType).get();
            data.read(compound);
            return data;
        }
        return null;
    }

    public void load(CompoundTag compound) {
        this.universalTraderMap.clear();
        if (compound.m_128425_("UniversalTraders", 9)) {
            ListTag universalTraderDataList = compound.m_128437_("UniversalTraders", 10);
            universalTraderDataList.forEach(nbt -> {
                CompoundTag traderNBT = (CompoundTag)nbt;
                UniversalTraderData data = TradingOffice.Deserialize(traderNBT);
                if (data != null) {
                    this.universalTraderMap.put(data.getTraderID(), data);
                }
            });
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag universalTraderDataList = new ListTag();
        this.universalTraderMap.forEach((traderID, traderData) -> {
            if (traderData != null) {
                CompoundTag traderNBT = traderData.write(new CompoundTag());
                traderNBT.m_128362_("ID", traderID);
                universalTraderDataList.add((Object)traderNBT);
            }
        });
        compound.m_128365_("UniversalTraders", (Tag)universalTraderDataList);
        return compound;
    }

    public static UniversalTraderData getData(UUID traderID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            if (office.universalTraderMap.containsKey(traderID)) {
                return office.universalTraderMap.get(traderID);
            }
        }
        return null;
    }

    public static List<UniversalTraderData> getTraders() {
        TradingOffice office = TradingOffice.get(ServerLifecycleHooks.getCurrentServer());
        return office.universalTraderMap.values().stream().collect(Collectors.toList());
    }

    public static List<UniversalTraderData> filterTraders(String searchFilter, List<UniversalTraderData> traders) {
        if (searchFilter.isEmpty()) {
            return traders;
        }
        Stream<UniversalTraderData> stream = traders.stream().filter(entry -> {
            String searchText = searchFilter.toLowerCase().trim();
            if (entry.getName().getString().toLowerCase().contains(searchText)) {
                return true;
            }
            if (entry.getOwnerName().toLowerCase().contains(searchText)) {
                return true;
            }
            return TraderSearchFilter.checkFilters(entry, searchText);
        });
        return stream.collect(Collectors.toList());
    }

    public static List<UniversalTraderData> getTraders(String searchFilter) {
        return TradingOffice.filterTraders(searchFilter, TradingOffice.getTraders());
    }

    public static void MarkDirty(UUID traderID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).m_77762_();
            UniversalTraderData data = TradingOffice.getData(traderID);
            if (data != null) {
                CompoundTag compound = data.write(new CompoundTag());
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientData(compound));
            }
        }
    }

    public static void MarkDirty(UUID traderID, CompoundTag updateMessage) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).m_77762_();
            UniversalTraderData data = TradingOffice.getData(traderID);
            if (data != null) {
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientData(updateMessage));
            }
        }
    }

    public static void registerTrader(UUID traderID, UniversalTraderData data, Player owner) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            if (office.universalTraderMap.containsKey(traderID)) {
                LightmansCurrency.LogError("Attempted to register a universal trader with id '" + traderID + "', but one is already present.");
                return;
            }
            LightmansCurrency.LogInfo("Successfully registered the universal trader with id '" + traderID + "'!");
            office.universalTraderMap.put(traderID, data);
            office.m_77762_();
            CompoundTag compound = data.write(new CompoundTag());
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientData(compound));
            MinecraftForge.EVENT_BUS.post((Event)new UniversalTraderEvent.UniversalTradeCreateEvent(traderID, owner));
        }
    }

    public static void removeTrader(UUID traderID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        TradingOffice office = TradingOffice.get(server);
        if (office.universalTraderMap.containsKey(traderID)) {
            UniversalTraderData removedData = office.universalTraderMap.get(traderID);
            office.universalTraderMap.remove(traderID);
            office.m_77762_();
            LightmansCurrency.LogInfo("Successfully removed the universal trader with id '" + traderID + "'!");
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageRemoveClientTrader(traderID));
            MinecraftForge.EVENT_BUS.post((Event)new UniversalTraderEvent.UniversalTradeRemoveEvent(traderID, removedData));
        }
    }

    private static TradingOffice get(MinecraftServer server) {
        ServerLevel world = server.m_129880_(Level.f_46428_);
        return (TradingOffice)world.m_8895_().m_164861_(compound -> new TradingOffice((CompoundTag)compound), () -> new TradingOffice(), DATA_NAME);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            CompoundTag compound = new CompoundTag();
            ListTag traderList = new ListTag();
            office.universalTraderMap.forEach((id, trader) -> traderList.add((Object)trader.write(new CompoundTag())));
            compound.m_128365_("Traders", (Tag)traderList);
            LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(event.getPlayer()), (Object)new MessageInitializeClientTraders(compound));
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.m_129921_() % 1200 == 0) {
            TradingOffice office = TradingOffice.get(server);
            office.universalTraderMap.values().removeIf(traderData -> {
                BlockPos pos = traderData.getPos();
                ServerLevel world = server.m_129880_(traderData.getWorld());
                if (world.m_46749_(pos)) {
                    BlockEntity tileEntity = world.m_7702_(pos);
                    if (tileEntity instanceof UniversalTraderBlockEntity) {
                        UniversalTraderBlockEntity traderEntity = (UniversalTraderBlockEntity)tileEntity;
                        return traderEntity.getTraderID() == null || !traderEntity.getTraderID().equals(traderData.getTraderID());
                    }
                    return true;
                }
                return false;
            });
        }
    }

    public static boolean isAdminPlayer(Player player) {
        return adminPlayers.contains(player.m_142081_()) && player.m_20310_(2);
    }

    public static void toggleAdminPlayer(Player player) {
        UUID playerID = player.m_142081_();
        if (adminPlayers.contains(playerID)) {
            adminPlayers.remove(playerID);
        } else {
            adminPlayers.add(playerID);
            if (!player.f_19853_.f_46443_) {
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)TradingOffice.getAdminSyncMessage());
            }
        }
    }

    public static MessageSyncAdminList getAdminSyncMessage() {
        return new MessageSyncAdminList(adminPlayers);
    }

    public static void loadAdminPlayers(List<UUID> serverAdminList) {
        adminPlayers = serverAdminList;
    }
}

