/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.data;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ILoggerSupport;
import io.github.lightman314.lightmanscurrency.api.ItemShopLogger;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.menus.UniversalItemEditMenu;
import io.github.lightman314.lightmanscurrency.menus.UniversalItemTraderMenu;
import io.github.lightman314.lightmanscurrency.menus.UniversalItemTraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.UniversalMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageOpenStorage2;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageSetTraderRules2;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class UniversalItemTraderData
extends UniversalTraderData
implements IItemTrader,
ILoggerSupport<ItemShopLogger>,
ITradeRuleHandler {
    public static final int TRADELIMIT = 16;
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "item_trader");
    public static final int VERSION = 1;
    int tradeCount = 1;
    NonNullList<ItemTradeData> trades = null;
    Container inventory;
    private final ItemShopLogger logger = new ItemShopLogger();
    List<TradeRule> tradeRules = new ArrayList<TradeRule>();

    public UniversalItemTraderData() {
    }

    public UniversalItemTraderData(Entity owner, BlockPos pos, ResourceKey<Level> world, UUID traderID, int tradeCount) {
        super(owner.m_142081_(), owner.m_5446_().getString(), pos, world, traderID);
        this.tradeCount = MathUtil.clamp(tradeCount, 1, 16);
        this.trades = ItemTradeData.listOfSize(this.tradeCount);
        this.inventory = new SimpleContainer(this.inventorySize());
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128425_("TradeLimit", 3)) {
            this.tradeCount = MathUtil.clamp(compound.m_128451_("TradeLimit"), 1, 16);
        }
        if (compound.m_128425_("Trades", 9)) {
            this.trades = ItemTradeData.loadAllData(compound, this.tradeCount);
        }
        if (compound.m_128425_("Storage", 9)) {
            this.inventory = InventoryUtil.loadAllItems("Storage", compound, this.getTradeCount() * 9);
        }
        this.logger.read(compound);
        if (compound.m_128425_("TradeRules", 9)) {
            this.tradeRules = TradeRule.readRules(compound);
        }
        super.read(compound);
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        this.writeTrades(compound);
        this.writeStorage(compound);
        this.writeLogger(compound);
        this.writeRules(compound);
        return super.write(compound);
    }

    protected final CompoundTag writeTrades(CompoundTag compound) {
        compound.m_128405_("TradeLimit", this.trades.size());
        ItemTradeData.saveAllData(compound, this.trades);
        return compound;
    }

    protected final CompoundTag writeStorage(CompoundTag compound) {
        InventoryUtil.saveAllItems("Storage", compound, this.inventory);
        return compound;
    }

    protected final CompoundTag writeLogger(CompoundTag compound) {
        this.logger.write(compound);
        return compound;
    }

    protected final CompoundTag writeRules(CompoundTag compound) {
        TradeRule.writeRules(compound, this.tradeRules);
        return compound;
    }

    @Override
    public int getTradeCount() {
        return this.tradeCount;
    }

    public void addTrade() {
        if (this.getTradeCount() >= 16) {
            return;
        }
        this.overrideTradeCount(this.tradeCount + 1);
        this.forceReOpen();
    }

    public void removeTrade() {
        if (this.getTradeCount() <= 1) {
            return;
        }
        this.overrideTradeCount(this.tradeCount - 1);
        this.forceReOpen();
    }

    private void forceReOpen() {
        UniversalMenu.onForceReopen(this.traderID);
    }

    public void overrideTradeCount(int newTradeCount) {
        int i;
        if (this.tradeCount == newTradeCount) {
            return;
        }
        this.tradeCount = MathUtil.clamp(newTradeCount, 1, 16);
        NonNullList<ItemTradeData> oldTrades = this.trades;
        this.trades = ItemTradeData.listOfSize(this.getTradeCount());
        for (int i2 = 0; i2 < oldTrades.size() && i2 < this.trades.size(); ++i2) {
            this.trades.set(i2, (Object)((ItemTradeData)oldTrades.get(i2)));
        }
        Container oldInventory = this.inventory;
        this.inventory = new SimpleContainer(this.inventorySize());
        for (i = 0; i < this.inventory.m_6643_() && i < oldInventory.m_6643_(); ++i) {
            this.inventory.m_6836_(i, oldInventory.m_8020_(i));
        }
        if (oldInventory.m_6643_() > this.inventorySize()) {
            for (i = this.inventorySize(); i < oldInventory.m_6643_(); ++i) {
                InventoryUtil.TryPutItemStack(this.inventory, oldInventory.m_8020_(i));
            }
        }
        CompoundTag compound = this.writeTrades(new CompoundTag());
        this.writeStorage(compound);
        this.markDirty(compound);
    }

    @Override
    public ItemTradeData getTrade(int tradeIndex) {
        if (tradeIndex >= 0 && tradeIndex < this.getTradeCount()) {
            return (ItemTradeData)this.trades.get(tradeIndex);
        }
        return new ItemTradeData();
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return this.getTrade(tradeIndex).stockCount(this);
    }

    public NonNullList<ItemTradeData> getAllTrades() {
        return this.trades;
    }

    @Override
    public void markTradesDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeTrades));
    }

    @Override
    public ItemShopLogger getLogger() {
        return this.logger;
    }

    @Override
    public void clearLogger() {
        this.logger.clear();
        this.markLoggerDirty();
    }

    @Override
    public void markLoggerDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeLogger));
    }

    public int inventorySize() {
        return this.tradeCount * 9;
    }

    @Override
    public Container getStorage() {
        return this.inventory;
    }

    @Override
    public void markStorageDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeStorage));
    }

    @Override
    public ResourceLocation getTraderType() {
        return TYPE;
    }

    @Override
    protected Component getDefaultName() {
        return new TranslatableComponent("gui.lightmanscurrency.universaltrader.item");
    }

    @Override
    protected MenuProvider getTradeMenuProvider() {
        return new TraderProvider(this.traderID);
    }

    @Override
    protected MenuProvider getStorageMenuProvider() {
        return new StorageProvider(this.traderID);
    }

    protected MenuProvider getItemEditMenuProvider(int tradeIndex) {
        return new ItemEditProvider(this.traderID, tradeIndex);
    }

    @Override
    public void openItemEditMenu(Player player, int tradeIndex) {
        MenuProvider provider = this.getItemEditMenuProvider(tradeIndex);
        if (provider == null) {
            LightmansCurrency.LogError("No storage container provider was given for the universal trader of type " + this.getTraderType().toString());
            return;
        }
        if (player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (Consumer)new UniversalTraderData.TradeIndexDataWriter(this, this.getTraderID(), tradeIndex));
        } else {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
        }
    }

    @Override
    public ResourceLocation IconLocation() {
        return UniversalTraderData.ICON_RESOURCE;
    }

    @Override
    public int IconPositionX() {
        return 0;
    }

    @Override
    public int IconPositionY() {
        return 0;
    }

    @Override
    public int GetCurrentVersion() {
        return 1;
    }

    @Override
    protected void onVersionUpdate(int oldVersion) {
        if (oldVersion < 1) {
            for (ItemTradeData trade : this.trades) {
                ItemStack tradeStack = trade.getSellItem();
                if (!tradeStack.m_41619_()) {
                    tradeStack = InventoryUtil.TryPutItemStack(this.inventory, tradeStack);
                }
                if (tradeStack.m_41619_()) continue;
                LightmansCurrency.LogWarning(tradeStack.m_41613_() + " items lost during Universal Item Trader version update for trader " + this.traderID + ".");
            }
        }
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.beforeTrade(event));
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        this.tradeRules.forEach(rule -> rule.tradeCost(event));
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.afterTrade(event));
    }

    @Override
    public List<TradeRule> getRules() {
        return this.tradeRules;
    }

    @Override
    public void setRules(List<TradeRule> rules) {
        this.tradeRules = rules;
    }

    @Override
    public void addRule(TradeRule newRule) {
        if (newRule == null) {
            return;
        }
        for (int i = 0; i < this.tradeRules.size(); ++i) {
            if (newRule.type != this.tradeRules.get((int)i).type) continue;
            return;
        }
        this.tradeRules.add(newRule);
    }

    @Override
    public void removeRule(TradeRule rule) {
        if (this.tradeRules.contains(rule)) {
            this.tradeRules.remove(rule);
        }
    }

    @Override
    public void clearRules() {
        this.tradeRules.clear();
    }

    @Override
    public void markRulesDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::writeRules));
    }

    public ITradeRuleScreenHandler GetRuleScreenHandler() {
        return new TradeRuleScreenHandler(this);
    }

    private static class TraderProvider
    implements MenuProvider {
        final UUID traderID;

        private TraderProvider(UUID traderID) {
            this.traderID = traderID;
        }

        public AbstractContainerMenu m_7208_(int menuID, Inventory inventory, Player player) {
            return new UniversalItemTraderMenu(menuID, inventory, this.traderID);
        }

        public Component m_5446_() {
            return new TextComponent("");
        }
    }

    private static class StorageProvider
    implements MenuProvider {
        final UUID traderID;

        private StorageProvider(UUID traderID) {
            this.traderID = traderID;
        }

        public AbstractContainerMenu m_7208_(int menuID, Inventory inventory, Player player) {
            return new UniversalItemTraderStorageMenu(menuID, inventory, this.traderID);
        }

        public Component m_5446_() {
            return new TextComponent("");
        }
    }

    private static class ItemEditProvider
    implements MenuProvider {
        final UUID traderID;
        final int tradeIndex;

        private ItemEditProvider(UUID traderID, int tradeIndex) {
            this.traderID = traderID;
            this.tradeIndex = tradeIndex;
        }

        private UniversalItemTraderData getData() {
            UniversalTraderData data = TradingOffice.getData(this.traderID);
            if (data instanceof UniversalItemTraderData) {
                return (UniversalItemTraderData)data;
            }
            return null;
        }

        public AbstractContainerMenu m_7208_(int menuID, Inventory inventory, Player player) {
            return new UniversalItemEditMenu(menuID, inventory, (Supplier<IItemTrader>)((Supplier)() -> this.getData()), this.tradeIndex);
        }

        public Component m_5446_() {
            return new TextComponent("");
        }
    }

    private static class TradeRuleScreenHandler
    implements ITradeRuleScreenHandler {
        private final UniversalItemTraderData trader;

        public TradeRuleScreenHandler(UniversalItemTraderData trader) {
            this.trader = trader;
        }

        @Override
        public ITradeRuleHandler ruleHandler() {
            return this.trader;
        }

        @Override
        public void reopenLastScreen() {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenStorage2(this.trader.traderID));
        }

        @Override
        public void updateServer(List<TradeRule> newRules) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetTraderRules2(this.trader.traderID, newRules));
        }
    }
}

