/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching;

import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class ItemTraderSearchFilter
extends TraderSearchFilter {
    @Override
    public boolean filter(UniversalTraderData data, String searchText) {
        if (data instanceof UniversalItemTraderData) {
            NonNullList<ItemTradeData> trades = ((UniversalItemTraderData)data).getAllTrades();
            for (int i = 0; i < trades.size(); ++i) {
                if (!((ItemTradeData)trades.get(i)).isValid()) continue;
                ItemStack sellItem = ((ItemTradeData)trades.get(i)).getSellItem();
                if (sellItem.m_41786_().getString().toLowerCase().contains(searchText)) {
                    return true;
                }
                if (((ItemTradeData)trades.get(i)).getCustomName().toLowerCase().contains(searchText)) {
                    return true;
                }
                AtomicBoolean foundEnchantment = new AtomicBoolean(false);
                EnchantmentHelper.m_44831_((ItemStack)sellItem).forEach((enchantment, level) -> {
                    if (enchantment.m_44700_(level.intValue()).getString().toLowerCase().contains(searchText)) {
                        foundEnchantment.set(true);
                    }
                });
                if (foundEnchantment.get()) {
                    return true;
                }
                if (!((ItemTradeData)trades.get(i)).isBarter()) continue;
                ItemStack barterItem = ((ItemTradeData)trades.get(i)).getBarterItem();
                if (barterItem.m_41786_().getString().toLowerCase().contains(searchText)) {
                    return true;
                }
                foundEnchantment.set(false);
                EnchantmentHelper.m_44831_((ItemStack)barterItem).forEach((enchantment, level) -> {
                    if (enchantment.m_44700_(level.intValue()).getString().toLowerCase().contains(searchText)) {
                        foundEnchantment.set(true);
                    }
                });
                if (!foundEnchantment.get()) continue;
                return true;
            }
        }
        return false;
    }
}

