/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.blockentity.CashRegisterBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.CoinMintBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.TicketMachineBlockEntity;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.menus.InventoryWalletMenu;
import io.github.lightman314.lightmanscurrency.menus.ItemEditMenu;
import io.github.lightman314.lightmanscurrency.menus.ItemTraderMenu;
import io.github.lightman314.lightmanscurrency.menus.ItemTraderMenuCR;
import io.github.lightman314.lightmanscurrency.menus.ItemTraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.MintMenu;
import io.github.lightman314.lightmanscurrency.menus.PaygateMenu;
import io.github.lightman314.lightmanscurrency.menus.TicketMachineMenu;
import io.github.lightman314.lightmanscurrency.menus.UniversalItemEditMenu;
import io.github.lightman314.lightmanscurrency.menus.UniversalItemTraderMenu;
import io.github.lightman314.lightmanscurrency.menus.UniversalItemTraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.WalletMenu;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.util.SafeTradingOffice;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="lightmanscurrency", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModContainers {
    private static final List<MenuType<?>> CONTAINER_TYPES = new ArrayList();
    public static final MenuType<InventoryWalletMenu> INVENTORY_WALLET = ModContainers.register("inventory_wallet", (id, inventory, data) -> new InventoryWalletMenu(id, inventory));
    public static final MenuType<ATMMenu> ATM = ModContainers.register("atm", (id, inventory, data) -> new ATMMenu(id, inventory));
    public static final MenuType<MintMenu> MINT = ModContainers.register("coinmint", (id, playerInventory, data) -> {
        CoinMintBlockEntity tileEntity = (CoinMintBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        return new MintMenu(id, playerInventory, tileEntity);
    });
    public static final MenuType<ItemTraderMenu> ITEMTRADER = ModContainers.register("item_trader", (id, playerInventory, data) -> {
        ItemTraderBlockEntity tileEntity = (ItemTraderBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        return new ItemTraderMenu(id, playerInventory, tileEntity);
    });
    public static final MenuType<ItemTraderStorageMenu> ITEMTRADERSTORAGE = ModContainers.register("item_trader_storage", (id, playerInventory, data) -> {
        ItemTraderBlockEntity tileEntity = (ItemTraderBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        return new ItemTraderStorageMenu(id, playerInventory, tileEntity);
    });
    public static final MenuType<ItemTraderMenuCR> ITEMTRADERCR = ModContainers.register("item_trader_cr", (id, playerInventory, data) -> {
        ItemTraderBlockEntity traderEntity = (ItemTraderBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        CashRegisterBlockEntity registerEntity = (CashRegisterBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        return new ItemTraderMenuCR(id, playerInventory, traderEntity, registerEntity);
    });
    public static final MenuType<UniversalItemTraderMenu> UNIVERSAL_ITEMTRADER = ModContainers.register("universal_item_trader", (id, playerInventory, data) -> new UniversalItemTraderMenu(id, playerInventory, data.m_130259_()));
    public static final MenuType<UniversalItemTraderStorageMenu> UNIVERSAL_ITEMTRADERSTORAGE = ModContainers.register("universal_item_trader_storage", (id, playerInventory, data) -> new UniversalItemTraderStorageMenu(id, playerInventory, data.m_130259_()));
    public static final MenuType<WalletMenu> WALLET = ModContainers.register("wallet", (id, playerInventory, data) -> new WalletMenu(id, playerInventory, data.readInt()));
    public static final MenuType<PaygateMenu> PAYGATE = ModContainers.register("paygate", (id, playerInventory, data) -> {
        PaygateBlockEntity tileEntity = (PaygateBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        return new PaygateMenu(id, playerInventory, tileEntity);
    });
    public static final MenuType<TicketMachineMenu> TICKET_MACHINE = ModContainers.register("ticket_machine", (id, playerInventory, data) -> {
        TicketMachineBlockEntity tileEntity = (TicketMachineBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        return new TicketMachineMenu(id, playerInventory, tileEntity);
    });
    public static final MenuType<ItemEditMenu> ITEM_EDIT = ModContainers.register("item_edit", (id, playerInventory, data) -> {
        ItemTraderBlockEntity tileEntity = (ItemTraderBlockEntity)playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        return new ItemEditMenu(id, playerInventory, (Supplier<IItemTrader>)((Supplier)() -> tileEntity), data.readInt());
    });
    public static final MenuType<UniversalItemEditMenu> UNIVERSAL_ITEM_EDIT = ModContainers.register("universal_item_edit", (id, playerInventory, data) -> {
        UUID traderID = data.m_130259_();
        return new UniversalItemEditMenu(id, playerInventory, (Supplier<IItemTrader>)((Supplier)() -> (UniversalItemTraderData)SafeTradingOffice.getData(traderID)), data.readInt());
    });

    private static <T extends AbstractContainerMenu> MenuType<T> register(String key, IContainerFactory<T> factory) {
        MenuType type = new MenuType(factory);
        type.setRegistryName(key);
        CONTAINER_TYPES.add(type);
        return type;
    }

    @SubscribeEvent
    public static void registerTypes(RegistryEvent.Register<MenuType<?>> event) {
        CONTAINER_TYPES.forEach(type -> event.getRegistry().register((IForgeRegistryEntry)type));
        CONTAINER_TYPES.clear();
    }
}

