/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.gamerule;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ModGameRules {
    private static final List<RuleData<?>> GAME_RULES = Lists.newArrayList();
    public static final GameRules.Key<GameRules.BooleanValue> KEEP_WALLET = ModGameRules.register("keepWallet", GameRules.Category.PLAYER, ModGameRules.createBoolean(false));
    public static final GameRules.Key<GameRules.IntegerValue> COIN_DROP_PERCENT = ModGameRules.register("coinDropPercent", GameRules.Category.PLAYER, ModGameRules.createInteger(0));

    private static GameRules.Type<GameRules.IntegerValue> createInteger(int defaultVal) {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(GameRules.IntegerValue.class, (String)"m_46312_", (Class[])new Class[]{Integer.TYPE});
            m.setAccessible(true);
            return (GameRules.Type)m.invoke(null, defaultVal);
        }
        catch (Exception e) {
            try {
                Method m2 = ObfuscationReflectionHelper.findMethod(GameRules.IntegerValue.class, (String)"create", (Class[])new Class[]{Integer.TYPE});
                m2.setAccessible(true);
                return (GameRules.Type)m2.invoke(null, defaultVal);
            }
            catch (Exception e2) {
                LightmansCurrency.LogError("Create gamerule error", e);
                return null;
            }
        }
    }

    private static GameRules.Type<GameRules.BooleanValue> createBoolean(boolean defaultVal) {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(GameRules.BooleanValue.class, (String)"m_46250_", (Class[])new Class[]{Boolean.TYPE});
            m.setAccessible(true);
            return (GameRules.Type)m.invoke(null, defaultVal);
        }
        catch (Exception e) {
            try {
                Method m2 = ObfuscationReflectionHelper.findMethod(GameRules.BooleanValue.class, (String)"create", (Class[])new Class[]{Boolean.TYPE});
                m2.setAccessible(true);
                return (GameRules.Type)m2.invoke(null, defaultVal);
            }
            catch (Exception e2) {
                LightmansCurrency.LogError("Create gamerule error", e);
                return null;
            }
        }
    }

    private static <T extends GameRules.Value<T>> GameRules.Key<T> register(String name, GameRules.Category category, GameRules.Type<T> ruleType) {
        if (ruleType == null) {
            return null;
        }
        GameRules.Key ruleKey = new GameRules.Key(name, category);
        RuleData<T> ruleData = new RuleData<T>(name, category, ruleType);
        GAME_RULES.add(ruleData);
        return ruleKey;
    }

    public static <T extends GameRules.Value<T>> T getCustomValue(Level level, GameRules.Key<T> ruleKey) {
        if (ruleKey == null) {
            return null;
        }
        return (T)level.m_46469_().m_46170_(ruleKey);
    }

    public static void registerRules() {
        GAME_RULES.forEach(rule -> GameRules.m_46189_((String)rule.name, (GameRules.Category)rule.category, rule.ruleType));
        GAME_RULES.clear();
    }

    private static class RuleData<T extends GameRules.Value<T>> {
        public final String name;
        public final GameRules.Category category;
        public final GameRules.Type<T> ruleType;

        public RuleData(String name, GameRules.Category category, GameRules.Type<T> ruleType) {
            this.name = name;
            this.category = category;
            this.ruleType = ruleType;
        }
    }
}

