/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.lightman314.lightmanscurrency.client.ModLayerDefinitions;
import io.github.lightman314.lightmanscurrency.client.model.ModelWallet;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

public class Curios {
    public static ItemStack getWalletStack(Player player) {
        AtomicReference<ItemStack> wallet = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(SlotTypePreset.BELT.getIdentifier());
            stacksOptional.ifPresent(stacksHandler -> {
                for (int i = 0; i < stacksHandler.getStacks().getSlots(); ++i) {
                    ItemStack stack = stacksHandler.getStacks().getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof WalletItem)) continue;
                    wallet.set(stack);
                }
            });
        });
        return wallet.get();
    }

    public static void RegisterCuriosRenderers() {
        CuriosRendererRegistry.register((Item)ModItems.WALLET_COPPER, WalletCuriosRenderer::new);
        CuriosRendererRegistry.register((Item)ModItems.WALLET_IRON, WalletCuriosRenderer::new);
        CuriosRendererRegistry.register((Item)ModItems.WALLET_GOLD, WalletCuriosRenderer::new);
        CuriosRendererRegistry.register((Item)ModItems.WALLET_EMERALD, WalletCuriosRenderer::new);
        CuriosRendererRegistry.register((Item)ModItems.WALLET_DIAMOND, WalletCuriosRenderer::new);
        CuriosRendererRegistry.register((Item)ModItems.WALLET_NETHERITE, WalletCuriosRenderer::new);
    }

    public static ICapabilityProvider createWalletProvider(ItemStack walletStack) {
        return CurioItemCapability.createProvider((ICurio)new WalletCuriosCapability(walletStack));
    }

    public static class WalletCuriosCapability
    implements ICurio {
        private final ItemStack walletStack;

        public WalletCuriosCapability(ItemStack walletStack) {
            this.walletStack = walletStack;
        }

        public ItemStack getStack() {
            return this.walletStack;
        }

        public boolean canRightClickEquip() {
            return false;
        }

        public boolean canSync(String identifier, int index, LivingEntity livingEntity) {
            return true;
        }

        @Nonnull
        public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
            return ICurio.DropRule.DEFAULT;
        }
    }

    public static class WalletCuriosRenderer
    implements ICurioRenderer {
        private final ModelWallet<LivingEntity> model = new ModelWallet(Minecraft.m_91087_().m_167973_().m_171103_(ModLayerDefinitions.WALLET));

        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource bufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            WalletItem walletItem = (WalletItem)stack.m_41720_();
            LivingEntity entity = slotContext.entity();
            this.model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
            this.model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{this.model});
            VertexConsumer vertexConsumer = ItemRenderer.m_115211_((MultiBufferSource)bufferSource, (RenderType)this.model.m_103119_(walletItem.getModelTexture()), (boolean)false, (boolean)stack.m_41790_());
            this.model.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

