/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.ItemTraderStorageUtil;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.interfaces.ICreativeTraderMenu;
import io.github.lightman314.lightmanscurrency.menus.interfaces.IItemEditCapable;
import io.github.lightman314.lightmanscurrency.menus.interfaces.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.item_trader.MessageOpenItemEdit;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ItemTraderStorageMenu
extends AbstractContainerMenu
implements ITraderStorageMenu,
ICreativeTraderMenu,
IItemEditCapable {
    public static final int SCREEN_EXTENSION = 99;
    public final Player player;
    public final ItemTraderBlockEntity tileEntity;
    final Container coinSlots;

    public ItemTraderStorageMenu(int windowId, Inventory inventory, ItemTraderBlockEntity tileEntity) {
        super(ModContainers.ITEMTRADERSTORAGE, windowId);
        int x;
        this.tileEntity = tileEntity;
        this.player = inventory.f_35978_;
        this.tileEntity.userOpen(this.player);
        int tradeCount = this.tileEntity.getTradeCount();
        int rowCount = ItemTraderStorageUtil.getRowCount(tradeCount);
        int columnCount = 9 * ItemTraderStorageUtil.getColumnCount(tradeCount);
        for (int y = 0; y < rowCount; ++y) {
            for (x = 0; x < columnCount && x + y * columnCount < tileEntity.getStorage().m_6643_(); ++x) {
                this.m_38897_(new Slot(this.tileEntity.getStorage(), x + y * columnCount, 8 + x * 18 + 99 + ItemTraderStorageUtil.getStorageSlotOffset(tradeCount, y), 18 + y * 18));
            }
        }
        int inventoryOffset = ItemTraderStorageUtil.getInventoryOffset(tradeCount);
        this.coinSlots = new SimpleContainer(5);
        for (int i = 0; i < 5; ++i) {
            this.m_38897_(new CoinSlot(this.coinSlots, i, inventoryOffset + 176 + 8 + 99, this.getStorageBottom() + 3 + i * 18));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, inventoryOffset + 8 + x2 * 18 + 99, this.getStorageBottom() + 15 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, inventoryOffset + 8 + x * 18 + 99, this.getStorageBottom() + 15 + 58));
        }
    }

    public int getStorageBottom() {
        return ItemTraderStorageUtil.getRowCount(this.tileEntity.getTradeCount()) * 18 + 28;
    }

    public void tick() {
        if (this.tileEntity.m_58901_()) {
            this.player.m_6915_();
            return;
        }
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < this.tileEntity.getStorage().m_6643_()) {
                if (!this.m_38903_(slotStack, this.tileEntity.getStorage().m_6643_() + this.coinSlots.m_6643_(), this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index < this.tileEntity.getStorage().m_6643_() + this.coinSlots.m_6643_()) {
                LightmansCurrency.LogInfo("Merging coin slots back into inventory.");
                if (!this.m_38903_(slotStack, this.tileEntity.getStorage().m_6643_() + this.coinSlots.m_6643_(), this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (MoneyUtil.isCoin(slotStack) ? !this.m_38903_(slotStack, this.tileEntity.getStorage().m_6643_(), this.tileEntity.getStorage().m_6643_() + this.coinSlots.m_6643_(), false) : !this.m_38903_(slotStack, 0, this.tileEntity.getStorage().m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, this.coinSlots);
        this.tileEntity.userClose(this.player);
    }

    public boolean isOwner() {
        return this.tileEntity.isOwner(this.player);
    }

    public boolean hasPermissions() {
        return this.tileEntity.hasPermissions(this.player);
    }

    @Override
    public void openItemEditScreenForTrade(int tradeIndex) {
        if (this.player.f_19853_.f_46443_) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenItemEdit(tradeIndex));
        } else {
            this.tileEntity.openItemEditMenu(this.player, tradeIndex);
        }
    }

    public boolean HasCoinsToAdd() {
        return !this.coinSlots.m_7983_();
    }

    @Override
    public void AddCoins() {
        if (this.tileEntity.m_58901_()) {
            this.player.m_6915_();
            return;
        }
        MoneyUtil.CoinValue addValue = MoneyUtil.CoinValue.easyBuild2(this.coinSlots);
        this.tileEntity.addStoredMoney(addValue);
        this.coinSlots.m_6211_();
    }

    @Override
    public void CollectCoinStorage() {
        int i;
        if (this.tileEntity.m_58901_()) {
            this.player.m_6915_();
            return;
        }
        List<ItemStack> coinList = MoneyUtil.getCoinsOfValue(this.tileEntity.getStoredMoney());
        ItemStack wallet = LightmansCurrency.getWalletStack(this.player);
        if (!wallet.m_41619_()) {
            ArrayList<ItemStack> spareCoins = new ArrayList<ItemStack>();
            for (i = 0; i < coinList.size(); ++i) {
                ItemStack extraCoins = WalletItem.PickupCoin(wallet, coinList.get(i));
                if (extraCoins.m_41619_()) continue;
                spareCoins.add(extraCoins);
            }
            coinList = spareCoins;
        }
        SimpleContainer inventory = new SimpleContainer(coinList.size());
        for (i = 0; i < coinList.size(); ++i) {
            inventory.m_6836_(i, coinList.get(i));
        }
        this.m_150411_(this.player, (Container)inventory);
        this.tileEntity.clearStoredMoney();
    }

    @Override
    public void ToggleCreative() {
        if (this.tileEntity.m_58901_()) {
            this.player.m_6915_();
            return;
        }
        this.tileEntity.toggleCreative();
    }

    @Override
    public void AddTrade() {
        this.tileEntity.addTrade();
    }

    @Override
    public void RemoveTrade() {
        this.tileEntity.removeTrade();
    }
}

