/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.slots.BlacklistSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.DisplaySlot;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WalletMenu
extends AbstractContainerMenu {
    private final int walletStackIndex;
    private final Inventory inventory;
    private final Container coinInput;
    private WalletItem walletItem;
    public final Component title;
    boolean autoConvert = false;

    public int getWalletIndex() {
        return this.walletStackIndex;
    }

    private ItemStack getWallet() {
        if (this.walletStackIndex < 0) {
            return LightmansCurrency.getWalletStack(this.inventory.f_35978_);
        }
        return this.inventory.m_8020_(this.walletStackIndex);
    }

    public WalletMenu(int windowId, Inventory inventory, int walletStackIndex) {
        super(ModContainers.WALLET, windowId);
        int x;
        this.walletStackIndex = walletStackIndex;
        this.inventory = inventory;
        this.walletItem = (WalletItem)this.getWallet().m_41720_();
        this.title = this.getWallet().m_41786_();
        this.coinInput = new SimpleContainer(WalletItem.InventorySize(this.walletItem));
        NonNullList<ItemStack> walletInventory = WalletItem.getWalletInventory(this.getWallet());
        for (int i = 0; i < this.coinInput.m_6643_() && i < walletInventory.size(); ++i) {
            this.coinInput.m_6836_(i, (ItemStack)walletInventory.get(i));
        }
        int y = 0;
        while (y * 9 < this.coinInput.m_6643_()) {
            for (x = 0; x < 9 && x + y * 9 < this.coinInput.m_6643_(); ++x) {
                this.m_38897_(new CoinSlot(this.coinInput, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
            ++y;
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                int index = x + y * 9 + 9;
                if (index == this.walletStackIndex) {
                    this.m_38897_(new DisplaySlot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 32 + (y + this.getRowCount()) * 18));
                    continue;
                }
                this.m_38897_(new BlacklistSlot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 32 + (y + this.getRowCount()) * 18, (Container)this.inventory, this.walletStackIndex));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            if (x2 == this.walletStackIndex) {
                this.m_38897_(new DisplaySlot((Container)inventory, x2, 8 + x2 * 18, 90 + this.getRowCount() * 18));
                continue;
            }
            this.m_38897_(new BlacklistSlot((Container)inventory, x2, 8 + x2 * 18, 90 + this.getRowCount() * 18, (Container)this.inventory, this.walletStackIndex));
        }
        this.autoConvert = WalletItem.getAutoConvert(this.getWallet());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int getRowCount() {
        return 1 + (this.coinInput.m_6643_() - 1) / 9;
    }

    public int getSlotCount() {
        return this.coinInput.m_6643_();
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.saveWalletContents();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.inventory == null) {
            return;
        }
        if (this.getWallet().m_41619_()) {
            this.inventory.f_35978_.m_6915_();
            return;
        }
        this.saveWalletContents();
    }

    public void saveWalletContents() {
        NonNullList walletInventory = NonNullList.m_122780_((int)WalletItem.InventorySize(this.walletItem), (Object)ItemStack.f_41583_);
        for (int i = 0; i < walletInventory.size() && i < this.coinInput.m_6643_(); ++i) {
            walletInventory.set(i, (Object)this.coinInput.m_8020_(i));
        }
        WalletItem.putWalletInventory(this.getWallet(), (NonNullList<ItemStack>)walletInventory);
        if (this.autoConvert != WalletItem.getAutoConvert(this.getWallet())) {
            WalletItem.toggleAutoConvert(this.getWallet());
        }
    }

    public boolean canConvert() {
        return WalletItem.CanConvert(this.walletItem);
    }

    public boolean canPickup() {
        return WalletItem.CanPickup(this.walletItem);
    }

    public boolean getAutoConvert() {
        return this.autoConvert;
    }

    public void ToggleAutoConvert() {
        this.autoConvert = !this.autoConvert;
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        if (index + this.coinInput.m_6643_() == this.walletStackIndex) {
            return ItemStack.f_41583_;
        }
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < this.coinInput.m_6643_() ? MoneyUtil.isCoin(slotStack.m_41720_()) && !this.m_38903_(slotStack, this.coinInput.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.coinInput.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public void ConvertCoins() {
        MoneyUtil.ConvertAllCoinsUp(this.coinInput);
        MoneyUtil.SortCoins(this.coinInput);
    }

    public ItemStack PickupCoins(ItemStack stack) {
        ItemStack returnValue = stack.m_41777_();
        for (int i = 0; i < this.coinInput.m_6643_() && !returnValue.m_41619_(); ++i) {
            ItemStack thisStack = this.coinInput.m_8020_(i);
            if (thisStack.m_41619_()) {
                this.coinInput.m_6836_(i, returnValue.m_41777_());
                returnValue = ItemStack.f_41583_;
                continue;
            }
            if (thisStack.m_41720_() != returnValue.m_41720_()) continue;
            int amountToAdd = MathUtil.clamp(returnValue.m_41613_(), 0, thisStack.m_41741_() - thisStack.m_41613_());
            thisStack.m_41764_(thisStack.m_41613_() + amountToAdd);
            returnValue.m_41764_(returnValue.m_41613_() - amountToAdd);
        }
        if (this.autoConvert) {
            this.ConvertCoins();
        }
        return returnValue;
    }
}

