/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.item_trader;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.events.TradeEditEvent;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageSetItemPrice {
    private BlockPos pos;
    private int tradeIndex;
    private MoneyUtil.CoinValue newPrice;
    private boolean isFree;
    private String customName;
    String newDirection;

    public MessageSetItemPrice(BlockPos pos, int tradeIndex, MoneyUtil.CoinValue newPrice, boolean isFree, String customName, String newDirection) {
        this.pos = pos;
        this.tradeIndex = tradeIndex;
        this.newPrice = newPrice;
        this.isFree = isFree;
        this.customName = customName;
        this.newDirection = newDirection;
    }

    public static void encode(MessageSetItemPrice message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.writeInt(message.tradeIndex);
        buffer.m_130079_(message.newPrice.writeToNBT(new CompoundTag(), "CoinValue"));
        buffer.writeBoolean(message.isFree);
        buffer.m_130070_(message.customName);
        buffer.m_130070_(message.newDirection);
    }

    public static MessageSetItemPrice decode(FriendlyByteBuf buffer) {
        return new MessageSetItemPrice(buffer.m_130135_(), buffer.readInt(), new MoneyUtil.CoinValue(buffer.m_130260_()), buffer.readBoolean(), buffer.m_130136_(30), buffer.m_130136_(ItemTradeData.MaxTradeTypeStringLength()));
    }

    public static void handle(MessageSetItemPrice message, java.util.function.Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (blockEntity = player.f_19853_.m_7702_(message.pos)) != null && blockEntity instanceof ItemTraderBlockEntity) {
                ItemTraderBlockEntity traderEntity = (ItemTraderBlockEntity)blockEntity;
                MoneyUtil.CoinValue oldPrice = traderEntity.getTrade(message.tradeIndex).getCost();
                boolean wasFree = traderEntity.getTrade(message.tradeIndex).isFree();
                traderEntity.getTrade(message.tradeIndex).setCost(message.newPrice);
                traderEntity.getTrade(message.tradeIndex).setFree(message.isFree);
                traderEntity.getTrade(message.tradeIndex).setCustomName(message.customName);
                traderEntity.getTrade(message.tradeIndex).setTradeType(ItemTradeData.loadTradeType(message.newDirection));
                if (oldPrice.getRawValue() != message.newPrice.getRawValue() || wasFree != message.isFree) {
                    TradeEditEvent.TradePriceEditEvent e = new TradeEditEvent.TradePriceEditEvent((Supplier<ITrader>)((Supplier)() -> {
                        BlockEntity be = player.f_19853_.m_7702_(message.pos);
                        if (be instanceof ItemTraderBlockEntity) {
                            return (ItemTraderBlockEntity)be;
                        }
                        return null;
                    }), message.tradeIndex, oldPrice, wasFree);
                    MinecraftForge.EVENT_BUS.post((Event)e);
                }
                traderEntity.markTradesDirty();
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

